/**********************************************************************
Copyright (c) 2004 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.internal.config.generator;

import org.w3c.dom.Element;

public class PluginConfigFile extends ConfigFile {
	protected static String TAG = ConfigUtility.getString("Config.PluginConfig.Tag");
	protected Element pConfig = null;
	private static String sr = PlatformObject.sr;

	public PluginConfigFile() {
		super();
	}

	public PluginConfigFile(String name) {
		super(name);
	}

	public void generateConfiguration_datacollection(String name) {
		Element aEnv;
		Element agent;
		Element app;
		Element option;
		Element var;

		//
		// Standard initializer 
		//
		pConfig = doc.createElement(PluginConfig.TAG);
		holder = doc.createElement("ElementHolder");
		holder.appendChild(pConfig);

		//
		// Plugin specific information
		//
		// Bug 74089 begins
		aEnv = doc.createElement(AgentControllerEnvironment.TAG);
		AgentControllerEnvironment.setConfiguration(aEnv, "default");
		pConfig.appendChild(aEnv);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "JBOSS_HOME");
		Variable.setPosition(var, "replace");
		Variable.setValue(var, getValue("JBOSS_HOME"));
		aEnv.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "JONAS_HOME");
		Variable.setPosition(var, "replace");
		Variable.setValue(var, getValue("JONAS_HOME"));
		aEnv.appendChild(var);
		// Bug 74089 ends

		if(PlatformObject.name.startsWith("Windows")) {
			app = doc.createElement(Application.TAG);
			Application.setConfiguration(app, "default");
			Application.setExecutable(app, "PerfmonAgent");
			Application.setLocation(app, "%RASERVER_HOME%" + sr + "bin");
			Application.setPath(app, "%RASERVER_HOME%" + sr + "bin" + sr + "PerfmonAgent" + PlatformObject.exeExt);
			pConfig.appendChild(app);
		}

		agent = doc.createElement(Agent.TAG);
		Agent.setConfiguration(agent, "default");
		Agent.setName(agent, "Java Profiling Agent");
		Agent.setClient(agent, "DYNAMIC");
		if(PlatformObject.name.startsWith("Windows")) {
			Agent.setDataChannelSize(agent, "64M");
		}
		else {
			Agent.setDataChannelSize(agent, "30M");
		}
		Agent.setType(agent, "Profiler");
		pConfig.appendChild(agent);

		option = doc.createElement(Option.TAG);
		Option.setName(option, "Thread Analysis Agent");
		Option.setType(option, "Profiler");
		Option.setValue(option, "hcthread");
		pConfig.appendChild(option);

		//
		// The following can be reused for other plugins
		//
		option = doc.createElement(Option.TAG);
		Option.setName(option, name);
		Option.setType(option, "version");
		Option.setValue(option, ConfigUtility.getString("Config.AgentController.Version"));
		pConfig.appendChild(option);

		saveToFile(getValue("RASERVER_HOME") + sr + "plugins" + sr + name + sr + "config" + sr + "pluginconfig.xml");
	}

	public void generateConfiguration_parsers(String name) {
		Element agent;
		Element app;
		Element option;
		Element param;
		Element var;

		//
		// Standard initializer 
		//
		pConfig = doc.createElement(PluginConfig.TAG);
		holder = doc.createElement("ElementHolder");
		holder.appendChild(pConfig);

		//
		// Plugin specific information
		//
		app = doc.createElement(Application.TAG);
		Application.setConfiguration(app, "default");
		Application.setExecutable(app, "RemoteLogParserLoader");
		Application.setLocation(app, "%SYS_TEMP_DIR%"); // Bug 62317
		Application.setPath(app, "%JAVA_PATH%");
		pConfig.appendChild(app);

		// Bug 73902
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "GLA_HOME");
		Variable.setPosition(var, "replace");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + name);
		app.appendChild(var);

		// Bug 62317 begins
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "GLA_CONFIG_PATH");
		Variable.setPosition(var, "replace");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + name + sr + "config");
		app.appendChild(var);
		// Bug 62317 ends

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + "org.eclipse.hyades.logging.parsers" + sr + "lib" + sr + "hgla.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + "org.eclipse.hyades.logging.parsers" + sr + "lib" + sr + "hglaconfig.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + "org.eclipse.hyades.logging.parsers" + sr + "lib" + sr + "hparse.jar");
		app.appendChild(var);

		param = doc.createElement(Parameter.TAG);
		Parameter.setPosition(param, "prepend");
		Parameter.setValue(param, "org.eclipse.hyades.logging.parsers.RemoteLogParserLoader");
		app.appendChild(param);

		// Bug 73902
		param = doc.createElement(Parameter.TAG);
		Parameter.setPosition(param, "prepend");
		Parameter.setValue(param, "-DGLA_HOME=&quot;%GLA_HOME%&quot;");
		app.appendChild(param);

		// Bug 60191
		param = doc.createElement(Parameter.TAG);
		Parameter.setPosition(param, "prepend");
		Parameter.setValue(param, "-Djava.version=1.4");
		app.appendChild(param);

		// Bug 62317 begins
		param = doc.createElement(Parameter.TAG);
		Parameter.setPosition(param, "append");
		Parameter.setValue(param, "&quot;config_path=%GLA_CONFIG_PATH%&quot;");
		app.appendChild(param);
		// Bug 62317 ends

		//
		// The following can be reused for other plugins
		//
		option = doc.createElement(Option.TAG);
		Option.setName(option, name);
		Option.setType(option, "version");
		Option.setValue(option, ConfigUtility.getString("Config.AgentController.Version"));
		pConfig.appendChild(option);

		saveToFile(getValue("RASERVER_HOME") + sr + "plugins" + sr + name + sr + "config" + sr + "pluginconfig.xml");
	}

	public void generateConfiguration_test(String name) {
		Element agent;
		Element aEnv;
		Element app;
		Element option;
		Element param;
		Element var;

		//
		// Standard initializer 
		//
		pConfig = doc.createElement(PluginConfig.TAG);
		holder = doc.createElement("ElementHolder");
		holder.appendChild(pConfig);

		//
		// Plugin specific information
		//
		aEnv = doc.createElement(AgentControllerEnvironment.TAG);
		AgentControllerEnvironment.setConfiguration(aEnv, "default");
		pConfig.appendChild(aEnv);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + "org.eclipse.hyades.test" + sr + "lib" + sr + "junit.jar");
		aEnv.appendChild(var);

		app = doc.createElement(Application.TAG);
		Application.setConfiguration(app, "default");
		Application.setExecutable(app, "HyadesTestingSession");
		Application.setLocation(app, "%SYS_TEMP_DIR%");
		Application.setPath(app, "%JAVA_PATH%");
		pConfig.appendChild(app);

		param = doc.createElement(Parameter.TAG);
		Parameter.setPosition(param, "prepend");
		Parameter.setValue(param, "&quot;-Dhyades.test.JVM=%JAVA_PATH%&quot;");
		app.appendChild(param);
		
		String testLibDir = "%RASERVER_HOME%" + sr + "plugins" + sr + "org.eclipse.hyades.test" + sr + "lib" + sr;

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "common.runner.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "hexrecr.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "http.hexrecr.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "http.runner.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "java.runner.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "manual.runner.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "common_model.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "ecore.xmi.jar");
		app.appendChild(var);
		
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "hmodel.jar");
		app.appendChild(var);
		
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "runtime.jar");
		app.appendChild(var);
		
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, testLibDir + "datapool_api.jar");
		app.appendChild(var);
		
		//
		// The following can be reused for other plugins
		//
		option = doc.createElement(Option.TAG);
		Option.setName(option, name);
		Option.setType(option, "version");
		Option.setValue(option, ConfigUtility.getString("Config.AgentController.Version"));
		pConfig.appendChild(option);

		saveToFile(getValue("RASERVER_HOME") + sr + "plugins" + sr + name + sr + "config" + sr + "pluginconfig.xml");
	}

	public void generateHyadesConfiguration() {
		// Do nothing, this feature is not supported
	}

	public void saveToFile() {
		// Do nothing, this feature is not supported
	}

}
