/**********************************************************************
Copyright (c) 2004 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.internal.config.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class SetConfig {
	protected static ConfigFile conf = null;
	protected static boolean overwrite = false;
	protected static boolean silent = false;
	protected static boolean verify = true;
	private static int size = 100;
	private static String defaultConfigFile = null;
	private static Hashtable hash = new Hashtable(size);
	private static String sr = PlatformObject.sr;

	public static void main(String[] args) {
		if(TestJvm.isMinimumVersion(ConfigUtility.getString("Config.Java.Version"), System.getProperty("java.version"))) {
			doIt(args);
		}
		else {
			System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_Version.Err") + ": " + ConfigUtility.getString("Config.Java.Version"));
			System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_Version.Msg"));
		}
	}

	protected static void doIt(String[] args) {
		String[] hostList = null;

		populateHashtable(args); // add all command line input to the hash table

		if (exist("-help") || exist("-h") || exist("-?")) {
			printHelp();
			return;
		}
		if (exist("-example") || exist("-ex")) {
			printExamples();
			return;
		}
		if (exist("-debug")) {
			Logger.setDebug(true);
		}
		if (exist("-overwrite") || exist("-ovr")) {
			overwrite = true;
		}
		if (exist("-silent") || exist("-s")) {
			silent = true;
		}
		if (exist("-noverify") || exist("-nov")) {
			verify = false;
		}
		//
		// Try to use the $PWD/.. directory as the RASERVER_HOME if none
		// specified
		//
		if (getValue("RASERVER_HOME") == null) {
			File pwd = new File("..");
			try {
				setValue("RASERVER_HOME", pwd.getCanonicalPath());
			} catch (IOException e) {
				// cannot resolve ".."
			}
		}
		//
		// Get the required parameters
		//
		if (!isValidRaserverHome(getValue("RASERVER_HOME"))) {
			if(silent) {
				return; // cannot resolve RASERVER_HOME under silent mode, return
			}
			else {
				setValue("RASERVER_HOME", promptRaserverHome(getValue("RASERVER_HOME")));
			}
		}

		defaultConfigFile = new String(getValue("RASERVER_HOME") + sr + "config" + sr + "serviceconfig.xml");

		//
		// Bug 61264
		// Check to see if the current user can write to the directory and the config file
		//
		if(!isWritable(defaultConfigFile)) {
			System.out.println(ConfigUtility.getString("Config.Writer.Error.CannotWriteFile") + " " + defaultConfigFile);
			return;
		}

		//
		// If input file is specified, load it if not overwriting
		//
		if (overwrite) {
			conf = new ConfigFile();
		} else {
			File input = new File(defaultConfigFile);
			//
			// If default configuration file exist, load it
			//
			if (input.exists()) {
				conf = new ConfigFile(input.getAbsolutePath());
			}
			//
			// Otherwise, create a new one
			//
			else {
				conf = new ConfigFile();
			}
		}
		//
		// RASERVER_HOME
		//
		conf.setValue("RASERVER_HOME", getValue("RASERVER_HOME"));
		//
		// JAVA_PATH=
		//
		if(PlatformObject.name.equals("OS/400")) {
			conf.setValue("JAVA_PATH", "/QSYS.LIB/Q5BVAJVM.PGM");
		}
		else {
			if(silent) {
				if ((getValue("JAVA_PATH") == null) || (getValue("JAVA_PATH").equals(""))){
					if((conf.getValue("JAVA_PATH") == null) || (conf.getValue("JAVA_PATH").equals(""))) {
						if(isValidJava(System.getProperty("java.home") + sr + "bin" + sr + "java" + PlatformObject.exeExt)) {
							conf.setValue("JAVA_PATH", System.getProperty("java.home") + sr + "bin" + sr + "java" + PlatformObject.exeExt);
						}
						else {
							conf.setValue("JAVA_PATH", "%JAVA_PATH%");
						}
					}
				}
				else {
					conf.setValue("JAVA_PATH", getValue("JAVA_PATH"));
				}
			}
			else {
				if (getValue("JAVA_PATH") == null) {
					if(conf.getValue("JAVA_PATH") == null) {
						conf.setValue("JAVA_PATH", promptJavaPath(System.getProperty("java.home") + sr + "bin" + sr + "java" + PlatformObject.exeExt));
					}
					else{
						conf.setValue("JAVA_PATH", promptJavaPath(conf.getValue("JAVA_PATH")));
					}
				}
				else {
					if(isValidJava(getValue("JAVA_PATH"))) {
						conf.setValue("JAVA_PATH", getValue("JAVA_PATH"));
					}
					else {
						conf.setValue("JAVA_PATH", promptJavaPath(getValue("JAVA_PATH")));
					}
				}
			}
		}
		//
		// ALLOW=
		//
		if(silent) {
			if (getValue("ALLOW") == null) {
				if(conf.getValue("ALLOW") == null) {
					conf.setValue("ALLOW", "LOCAL");
				}
			}
			else {
				conf.setValue("ALLOW", getValue("ALLOW"));
			}
		}
		else {
			if (getValue("ALLOW") == null) {
				if(conf.getValue("ALLOW") == null) {
					conf.setValue("ALLOW", promptAllow("LOCAL"));
				}
				else{
					conf.setValue("ALLOW", promptAllow(conf.getValue("ALLOW")));
				}
			}
			else {
				if(isValidAllow(getValue("ALLOW"))) {
					conf.setValue("ALLOW", getValue("ALLOW"));
				}
				else {
					conf.setValue("ALLOW", promptAllow(getValue("ALLOW")));
				}
			}
		}
		//
		// HOSTS=
		//
		if(conf.getValue("ALLOW").toUpperCase().equals("CUSTOM")) {
			if(silent) {
				if (getValue("HOSTS") == null) {
					if(conf.getValue("HOSTS") == null) {
						conf.setValue("HOSTS", "localhost");
					}
				}
				else {
					conf.setValue("HOSTS", getValue("HOSTS"));
				}
			}
			else {
				if (getValue("HOSTS") == null) {
					if(conf.getValue("HOSTS") == null) {
						conf.setValue("HOSTS", promptHosts("localhost"));
					}
					else{
						conf.setValue("HOSTS", promptHosts(conf.getValue("HOSTS")));
					}
				}
				else {
					if(isValidHosts(getValue("HOSTS"))) {
						conf.setValue("HOSTS", getValue("HOSTS"));
					}
					else {
						conf.setValue("HOSTS", promptHosts(getValue("HOSTS")));
					}
				}
			}
		}

		// Bug 74089 begins
		// JBOSS_HOME
		if(silent) {
			if (getValue("JBOSS_HOME") == null) {
				setValue("JBOSS_HOME", "");
			}
		}
		else {
			if (getValue("JBOSS_HOME") == null) {
				setValue("JBOSS_HOME", promptJBossHome(""));
			}
			else {
				if(isValidJBossHome(getValue("JBOSS_HOME"))) {
					setValue("JBOSS_HOME", getValue("JBOSS_HOME"));
				}
				else {
					setValue("JBOSS_HOME", promptJBossHome(getValue("JBOSS_HOME")));
				}
			}
		}
		// Bug 74706
		if((getValue("JBOSS_HOME") == null) || (getValue("JBOSS_HOME").equals(""))) {
			setValue("JBOSS_HOME", "null");
		}

		// JONAS_HOME
		if(silent) {
			if (getValue("JONAS_HOME") == null) {
				setValue("JONAS_HOME", "");
			}
		}
		else {
			if (getValue("JONAS_HOME") == null) {
				setValue("JONAS_HOME", promptJOnASHome(""));
			}
			else {
				if(isValidJOnASHome(getValue("JONAS_HOME"))) {
					setValue("JONAS_HOME", getValue("JONAS_HOME"));
				}
				else {
					setValue("JONAS_HOME", promptJOnASHome(getValue("JONAS_HOME")));
				}
			}
		}
		// Bug 74706
		if((getValue("JONAS_HOME") == null) || (getValue("JONAS_HOME").equals(""))) {
			setValue("JONAS_HOME", "null");
		}
		// Bug 74089 ends

		//
		// Generate the config
		//
		conf.generateConfiguration();
		if (conf != null) {
			conf.saveToFile();
		}

		//
		// Generate the plugin config
		//
		generatePluginConfigurations();
	}

	//
	// Retrieve the raserver home specified by the user
	//
	private static String promptRaserverHome(String defaultValue) {
		String rc = null;
		System.out.println(ConfigUtility.getString("Config.Prompt.RASERVER_HOME.Tag"));
		System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + defaultValue + "\"");
		System.out.print(" (");
		System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
		System.out.println(")");
		do {
			System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
			rc = promptUserInput(defaultValue);
		} while (!isValidRaserverHome(rc));
		return rc;
	}

	//
	// Retrieve the java home specified by the user
	//
	private static String promptJavaPath(String defaultValue) {
		String rc = null;
		if(PlatformObject.name.startsWith("Windows")) {
			System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_PATH.Tag.Windows"));
		}
		else {
			System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_PATH.Tag.Unix"));
		}
		System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + defaultValue + "\"");
		System.out.print(" (");
		System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
		System.out.println(")");
		do {
			System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
			rc = promptUserInput(defaultValue);
		} while (!isValidJava(rc));
		return rc;
	}

	//
	// Retrieve the allowed hosts specified by the user
	//
	private static String promptAllow(String defaultValue) {
		String rc = null;
		System.out.println(ConfigUtility.getString("Config.Prompt.Allow.Tag"));
		System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + defaultValue + "\"");
		System.out.print(" (");
		System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
		System.out.println(")");
		do {
			System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
			rc = promptUserInput(defaultValue);
		} while (!isValidAllow(rc));
		return rc;
	}

	//
	// Retrieve the host names specified by the user
	//
	private static String promptHosts(String defaultValue) {
		System.out.println(ConfigUtility.getString("Config.Prompt.Hosts.Tag"));
		System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + defaultValue + "\"");
		System.out.print(" (");
		System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
		System.out.println(")");
		System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
		return promptUserInput(defaultValue);
	}

	// Bug 74089 begins
	private static String promptJBossHome(String defaultValue) {
		System.out.println(ConfigUtility.getString("Config.Prompt.JBOSS_HOME.Tag"));
		System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + defaultValue + "\"");
		System.out.print(" (");
		System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
		System.out.println(")");
		System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
		return promptUserInput(defaultValue);
	}

	private static String promptJOnASHome(String defaultValue) {
		System.out.println(ConfigUtility.getString("Config.Prompt.JONAS_HOME.Tag"));
		System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + defaultValue + "\"");
		System.out.print(" (");
		System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
		System.out.println(")");
		System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
		return promptUserInput(defaultValue);
	}
	// Bug 74089 ends

	//
	// Return the user's input
	//
	protected static String promptUserInput(String defaultValue) {
		String input;
		BufferedReader bReader = new BufferedReader(new InputStreamReader(System.in));
		try {
			input = bReader.readLine();
		} catch (IOException e) {
			input = defaultValue;
		}
		if (input.equals("")) {
			input = defaultValue;
		}
		return ConfigUtility.removeTrailings(input);
	}

	//
	// Check if RASREVER_HOME is valid
	//
	private static boolean isValidRaserverHome(String path) {
		if(!verify) {
			return true;
		}
		else {
			boolean rc = false;
			if (path == null) {
				System.out.println(ConfigUtility.getString("Config.Prompt.InvalidValue"));
				return false;
			} else {
				File p = new File(path);
				// Make sure specified path is a directory and exist
				if (p.exists() && p.isDirectory()) {
					if(PlatformObject.name.equals("OS/400")) {
						// Check if SetConfig.sh exists
						File f = new File(p.getAbsolutePath() + File.separator + "bin" + File.separator + "SetConfig.sh");
						if (f.exists()) {
							rc = true;
						}
					}
					else {
						// Check if RAServer.exe or RAServer exists
						File f = new File(p.getAbsolutePath() + File.separator + "bin" + File.separator + "RAServer" + PlatformObject.exeExt);
						if (f.exists()) {
							rc = true;
						}
					}
				}
				if (!rc) {
					System.out.println(ConfigUtility.getString("Config.Prompt.InvalidValue"));
				}
				return rc;
			}
		}
	}

	//
	// Check if JAVA_PATH is valid
	//
	private static boolean isValidJava(String path) {
		if(!verify) {
			return true;
		}
		else {
			if (path == null) {
				System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_PATH.Err"));
				return false;
			}
			else {
				File p = new File(path);
				// Make sure specified path is a directory and exist
				if (p.exists() && p.isFile()) {
					boolean rc = TestJvm.isSupportedJava(path, ConfigUtility.getString("Config.Java.Version"));
					if (!rc) {
						System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_Version.Err") + ": " + ConfigUtility.getString("Config.Java.Version"));
					}
					return rc;
				}
				else {
					System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_PATH.Err"));
					return false;
				}
			}
		}
	}

	//
	// Check if ALLOW is valid
	//
	private static boolean isValidAllow(String allow) {
		if(!verify) {
			return true;
		}
		else {
			boolean rc = false;
			if(allow == null) {
				System.out.println(ConfigUtility.getString("Config.Prompt.Allow.Err"));
				return false;
			}
			else {
				if (allow.toLowerCase().equals("all") || allow.toLowerCase().equals("local") || allow.toLowerCase().equals("custom")) {
					rc = true;
				}
				if (!rc) {
					System.out.println(ConfigUtility.getString("Config.Prompt.Allow.Err"));
				}
				return rc;
			}
		}
	}

	//
	// Check if HOSTS is valid
	//
	private static boolean isValidHosts(String hosts) {
		if(!verify) {
			return true;
		}
		else {
			return (hosts != null);
		}
	}

	// Bug 74089 begins
	//
	// Check JBOSS_HOME
	//
	private static boolean isValidJBossHome(String path) {
		return true; // TODO: insert validation logic here
	}

	//
	// Check JONAS_HOME
	//
	private static boolean isValidJOnASHome(String path) {
		return true; // TODO: insert validation logic here
	}

	// Bug 74089 ends

	//
	// Bug 61264
	// Check if path is writable
	//
	private static boolean isWritable(String path) {
		File f = new File(path);
		if(f.exists()) {
			return f.canWrite();
		}
		else {
			return f.getParentFile().canWrite();
		}
	}

	//
	// Check if a parameter exist
	//
	protected static boolean exist(String tag) {
		return hash.containsKey(tag);
	}

	//
	// Return the value specified by the parameter
	//
	protected static String getValue(String tag) {
		if (hash.containsKey(tag)) {
			return (String) hash.get(tag);
		} else {
			return null;
		}
	}

	//
	// Set the value specified by the parameter
	//
	protected static void setValue(String tag, String value) {
		hash.put(tag, value);
	}

	protected static void removeKey(String tag) {
		hash.remove(tag);
	}

	//
	// Populate the hash table using the command line arguments
	//
	private static void populateHashtable(String[] args) {
		if (args != null) {
			for (int i = 0; i < args.length; i++) {
				int eq = args[i].indexOf('=');
				if (eq == -1) { // a flags, e.g. -help
					setValue(args[i], "");
				} else { // a parameter, e.g. name=value
					String name = trim(args[i].substring(0, eq));
					String value = trim(args[i].substring(eq + 1));
					if((name != null) && (value != null)) {
						setValue(name, value);
					}
				}
			}
		}
	}

	//
	// Trim off leading/trailing quotes and spaces
	//
	private static String trim(String str) {
		if((str == null) || (str.length() == 0)) {
			return null;
		}
		else {
			int start = 0; // position of the first non-quote and non-space char
			int end = str.length() - 1; // position of the last non-quote and non-space char

			while((start < end) && ((str.charAt(start) == ' ') || (str.charAt(start) == '\"') || (str.charAt(start) == '\''))) {
				start++;
			}

			while((end > start) && ((str.charAt(end) == ' ') || (str.charAt(end) == '\"') || (str.charAt(end) == '\''))) {
				end--;
			}

			if(start != end) {
				return str.substring(start, end + 1);
			}
			else {
				return null;
			}
		}
	}

	//
	// Print the help menu
	//
	private static void printHelp() {
		if (PlatformObject.name.startsWith("Windows")) {
			System.out.println(ConfigUtility.getString("Config.Cmd.Usage.Windows"));
		} else {
			System.out.println(ConfigUtility.getString("Config.Cmd.Usage.Unix"));
		}
		System.out.println(ConfigUtility.getString("Config.Cmd.Flags"));
		System.out.println(ConfigUtility.getString("Config.Cmd.Help.Tag"));
		System.out.println("\t" + ConfigUtility.getString("Config.Cmd.Help.Msg"));
		System.out.println(ConfigUtility.getString("Config.Cmd.Silent.Tag"));
		System.out.println("\t" + ConfigUtility.getString("Config.Cmd.Silent.Msg"));
		System.out.println(ConfigUtility.getString("Config.Cmd.NoVerify.Tag"));
		System.out.println("\t" + ConfigUtility.getString("Config.Cmd.NoVerify.Msg"));
		System.out.println(ConfigUtility.getString("Config.Cmd.Examples.Tag"));
		System.out.println("\t" + ConfigUtility.getString("Config.Cmd.Examples.Msg"));
		System.out.println();
		System.out.println(ConfigUtility.getString("Config.Cmd.Params"));
		System.out.println(ConfigUtility.getString("Config.Cmd.RASERVER_HOME.Tag"));
		System.out.println("\t" + ConfigUtility.getString("Config.Cmd.RASERVER_HOME.Msg"));
		System.out.println(ConfigUtility.getString("Config.Cmd.JAVA_PATH.Tag"));
		System.out.println("\t" + ConfigUtility.getString("Config.Cmd.JAVA_PATH.Msg"));
		System.out.println(ConfigUtility.getString("Config.Cmd.ALLOW.Tag"));
		System.out.println("\t" + ConfigUtility.getString("Config.Cmd.ALLOW.Msg"));
		System.out.println(ConfigUtility.getString("Config.Cmd.HOSTS.Tag"));
		System.out.println("\t" + ConfigUtility.getString("Config.Cmd.HOSTS.Msg"));
	}

	//
	// Print the help menu
	//
	private static void printExamples() {
		System.out.println(ConfigUtility.getString("Config.Example.Tag"));
		System.out.println(ConfigUtility.getString("Config.Example.Example1.Tag"));
		if (PlatformObject.name.startsWith("Windows")) {
			System.out.println("\t" + ConfigUtility.getString("Config.Example.Example1.Msg.Windows"));
		} else {
			System.out.println("\t" + ConfigUtility.getString("Config.Example.Example1.Msg.Unix"));
		}
		System.out.println(ConfigUtility.getString("Config.Example.Example2.Tag"));
		if (PlatformObject.name.startsWith("Windows")) {
			System.out.println("\t" + ConfigUtility.getString("Config.Example.Example2.Msg.Windows"));
		} else {
			System.out.println("\t" + ConfigUtility.getString("Config.Example.Example2.Msg.Unix"));
		}
		System.out.println(ConfigUtility.getString("Config.Example.Example3.Tag"));
		if (PlatformObject.name.startsWith("Windows")) {
			System.out.println("\t" + ConfigUtility.getString("Config.Example.Example3.Msg.Windows"));
		} else {
			System.out.println("\t" + ConfigUtility.getString("Config.Example.Example3.Msg.Unix"));
		}
		System.out.println(ConfigUtility.getString("Config.Example.Example4.Tag"));
		if (PlatformObject.name.startsWith("Windows")) {
			System.out.println("\t" + ConfigUtility.getString("Config.Example.Example4.Msg.Windows"));
		} else {
			System.out.println("\t" + ConfigUtility.getString("Config.Example.Example4.Msg.Unix"));
		}
	}

	//
	// Generate the plugin config files
	//
	protected static void generatePluginConfigurations() {
		// Data collection configurations
		generateDatacollectionConfiguration();

		// Parser configurations
		generateParsersConfiguration();

		// Test configurations
		generateTestConfiguration();
	}

	private static void generateDatacollectionConfiguration() {
		String name = "org.eclipse.hyades.datacollection";
		String f = new String(getValue("RASERVER_HOME") + sr + "plugins" + sr + name + sr + "config" + sr + "pluginconfig.xml");
		PluginConfigFile pluginConfig = null;

		File input = new File(f);
		//
		// If configuration file exist, load it
		//
		if (input.exists() && !overwrite) {
			pluginConfig = new PluginConfigFile(input.getAbsolutePath());
		}
		else {
			pluginConfig = new PluginConfigFile();
		}

		pluginConfig.setValue("RASERVER_HOME", getValue("RASERVER_HOME"));

		// Bug 74089 begins
		pluginConfig.setValue("JBOSS_HOME", getValue("JBOSS_HOME"));
		pluginConfig.setValue("JONAS_HOME", getValue("JONAS_HOME"));
		// Bug 74089 ends

		pluginConfig.generateConfiguration_datacollection(name);
	}

	private static void generateParsersConfiguration() {
		String name = "org.eclipse.hyades.logging.parsers";
		String f = new String(getValue("RASERVER_HOME") + sr + "plugins" + sr + name + sr + "config" + sr + "pluginconfig.xml");
		PluginConfigFile pluginConfig = null;

		File input = new File(f);
		//
		// If configuration file exist, load it
		//
		if (input.exists() && !overwrite) {
			pluginConfig = new PluginConfigFile(input.getAbsolutePath());
		}
		else {
			pluginConfig = new PluginConfigFile();
		}

		pluginConfig.setValue("RASERVER_HOME", getValue("RASERVER_HOME"));

		pluginConfig.generateConfiguration_parsers(name);
	}

	private static void generateTestConfiguration() {
		String name = "org.eclipse.hyades.test";
		String f = new String(getValue("RASERVER_HOME") + sr + "plugins" + sr + name + sr + "config" + sr + "pluginconfig.xml");
		PluginConfigFile pluginConfig = null;

		File input = new File(f);
		//
		// If configuration file exist, load it
		//
		if (input.exists() && !overwrite) {
			pluginConfig = new PluginConfigFile(input.getAbsolutePath());
		}
		else {
			pluginConfig = new PluginConfigFile();
		}

		pluginConfig.setValue("RASERVER_HOME", getValue("RASERVER_HOME"));

		pluginConfig.generateConfiguration_test(name);
	}

}
