/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.extensions;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.impl.ClassMetadata;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.QueryStatement;
import org.eclipse.hyades.resources.database.internal.impl.RDBHelper;
import org.eclipse.hyades.resources.database.internal.impl.StatementFactory;
/**
 * This class obtains the URIs for the resources for the given objects. It
 * returns an array of Strings.
 */
public class GetURICommand extends DBCommand {
	protected List classesAndIds;
	protected Map classesToMetadata;
	protected DatabaseType type;
	public GetURICommand(JDBCHelper helper, DBMap map, DatabaseType type, List classesAndIds) {
		super(helper, map);
		this.type = type;
		this.classesAndIds = classesAndIds;
	}
	public Object execute() throws Exception {
		List uris = new ArrayList();
		for (int i = 0, l = classesAndIds.size(); i < l; i += 2) {
			EClass eClass = (EClass) classesAndIds.get(i);
			List ids = (List) classesAndIds.get(i + 1);
			getURIs(eClass, ids, uris);
		}
		return uris.toArray(new String[0]);
	}
	protected void getURIs(EClass eClass, List ids, List uris) throws Exception {
		ClassMetadata metadata = getMetadata(eClass);
		EReference containerReference = metadata.getContainerReference();
		if (containerReference == null)
			processResourceTable(eClass, ids, uris);
		else {
			List containerIds = getContainers(containerReference, ids);
			getURIs(containerReference.getEReferenceType(), containerIds, uris);
		}
	}
	protected List getContainers(EReference containerReference, List ids) throws Exception {
		List noDuplicates = removeDuplicates(ids);
		DBMap.ReferenceData data = (DBMap.ReferenceData) dbMap.getDBRepresentation(containerReference);
		StatementFactory factory = StatementFactory.INSTANCE;
		int[] sourceIds = new int[noDuplicates.size()];
		for (int i = 0, l = noDuplicates.size(); i < l; i++)
			sourceIds[i] = ((Integer) noDuplicates.get(i)).intValue();
		QueryStatement query = factory.createGreedyReferenceQuery(sourceIds, containerReference, dbMap, type, true);
		String queryString = query.getStatement();
		String[] queryStrings;
		if (queryString != null) {
			queryStrings = new String[1];
			queryStrings[0] = queryString;
		} else
			queryStrings = query.getStatements();
		Map sourceToContainer = new HashMap();
		for (int i = 0; i < queryStrings.length; i++) {
			if (debug)
				System.out.println(queryStrings[i]);
			Statement queryStatement = helper.createStatement();
			ResultSet rs = helper.executeQuery(queryStatement, queryStrings[i]);
			while (rs.next()) {
				int source = rs.getInt(1);
				int target = rs.getInt(2);
				if (target > 0)
					sourceToContainer.put(new Integer(source), new Integer(target));
			}
			rs.close();
			queryStatement.close();
		}
		List containers = new ArrayList();
		for (int i = 0, l = ids.size(); i < l; i++) {
			Integer container = (Integer) sourceToContainer.get(ids.get(i));
			containers.add(container);
		}
		return containers;
	}
	protected List removeDuplicates(List ids) {
		List noDuplicates = new ArrayList();
		Set idSet = new HashSet();
		for (int i = 0, l = ids.size(); i < l; i++) {
			Object id = ids.get(i);
			if (id == null || idSet.contains(id))
				continue;
			idSet.add(id);
			noDuplicates.add(id);
		}
		return noDuplicates;
	}
	protected void processResourceTable(EClass eClass, List ids, List uris) throws Exception {
		ClassMetadata metadata = getMetadata(eClass);
		EClass[] subclasses = metadata.getAllSubclasses();
		List tableNames = new ArrayList();
		tableNames.add(getTableName(eClass));
		for (int i = 0; i < subclasses.length; i++)
			tableNames.add(getTableName(subclasses[i]));
		getURIsFromResourceTable(tableNames, ids, uris);
	}
	protected String getTableName(EClass eClass) {
		DBMap.ClassData data = (DBMap.ClassData) dbMap.getDBRepresentation(eClass);
		return data.getTable().getName();
	}
	protected void getURIsFromResourceTable(List tables, List ids, List uris) throws Exception {
		List noDuplicates = removeDuplicates(ids);
		Table resourceTable = dbMap.getResourceTable();
		Map idsToURIs = new HashMap();
		String query = createResourceTableQuery(resourceTable, tables, noDuplicates);
		Statement statement = helper.createStatement();
		ResultSet result = helper.executeQuery(statement, query);
		while (result.next()) {
			String uri = result.getString(1);
			int id = result.getInt(2);
			if (uri != null)
				idsToURIs.put(new Integer(id), uri);
		}
		for (int i = 0, l = ids.size(); i < l; i++)
			uris.add(idsToURIs.get(ids.get(i)));
		result.close();
		statement.close();
	}
	protected String createResourceTableQuery(Table resourceTable, List tables, List ids) {
		StringBuffer query = new StringBuffer();
		String uri = ((Column) resourceTable.getColumns().get(0)).getName();
		String table = ((Column) resourceTable.getColumns().get(1)).getName();
		String id = ((Column) resourceTable.getColumns().get(2)).getName();
		query.append("SELECT ");
		query.append(addQuotes(uri));
		query.append(", ");
		query.append(addQuotes(id));
		query.append(" FROM ");
		query.append(addQuotes(resourceTable.getName()));
		query.append(" WHERE ");
		query.append(addQuotes(table));
		query.append(" IN (");
		for (int i = 0, l = tables.size(); i < l; i++) {
			if (i == 0)
				query.append("'");
			else
				query.append(", '");
			query.append(tables.get(i));
		}
		query.append("\'");
		query.append(") AND ");
		query.append(addQuotes(id));
		query.append(" IN (");
		for (int i = 0, l = ids.size(); i < l; i++) {
			if (i != 0)
				query.append(", ");
			query.append(ids.get(i));
		}
		query.append(")");
		return query.toString();
	}
	protected ClassMetadata getMetadata(EClass eClass) {
		if (classesToMetadata == null)
			classesToMetadata = new HashMap();
		ClassMetadata metadata = (ClassMetadata) classesToMetadata.get(eClass);
		if (metadata == null) {
			metadata = new ClassMetadata(eClass, dbMap, new RDBHelper());
			classesToMetadata.put(eClass, metadata);
		}
		return metadata;
	}
} // GetURICommand
