/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

/*
* CONTEXT_ID tbpp0001 for Enable Profiling checkbox in Profiling(Trace) preference page
*/
/*
* CONTEXT_ID tbpp0002 for Enable JVM RAS information checkbox in Profiling(Trace) preference page
*/
/*
* CONTEXT_ID tbpp0003 for Enable Logging checkbox in Profiling(Trace) preference page
*/
/*
* CONTEXT_ID tbpp0004 for Default Trace Project Name entry field in Profiling(Trace) preference page
*/
/*
* CONTEXT_ID tbpp0005 for Enable Profiling Tips checkbox in Profiling(Trace) preference page
*/
/*
* CONTEXT_ID tbpp0006 for Local IBM Remote Agent port number entry field in Profiling(Trace) preference page
*/

public class TraceOptionsUI implements SelectionListener, ModifyListener
{
	private Button _enableProf;
	private Button _enableLog;
	private Button _enableInfoMsg;
	private Button _always;
	private Button _never;
	private Button _prompt;
	private Text _projectName;
	private Text _localPort;
    private PreferencePage _preferencePage;
    
    private Button _manualRefreshBtn;
    private Button _automaticRefreshBtn;
    private Text   _refreshIntervalText;
    private Label   _refreshLabel;
    
/**
 * TraceOptionsUI constructor comment.
 */
public TraceOptionsUI(PreferencePage preferencePage) {
	super();
	_preferencePage = preferencePage;
	
}

public TraceOptionsUI() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 3:45:54 PM)
 * @param parent com.ibm.swt.widgets.Composite
 */
public Composite createControl(Composite parent)
{
	GridLayout layout;
	GridData data;
	
	Composite content = new Composite(parent, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing = 10;
	content.setLayout(layout);
	content.setLayoutData(GridUtil.createFill());

    Group profilingOptions = new Group(content, SWT.NULL);
    profilingOptions.setText(UIPlugin.getResourceString("PROF_LOG_GRP"));
	layout = new GridLayout();
	layout.numColumns = 1;
	profilingOptions.setLayout(layout);
	profilingOptions.setLayoutData(GridUtil.createHorizontalFill());
    
	_enableProf = new Button(profilingOptions, SWT.CHECK);
	_enableProf.setText(UIPlugin.getResourceString("ENABLE_PROFILE_TEXT"));
	data = new GridData();
	_enableProf.setLayoutData(data);
		
	_enableLog = new Button(profilingOptions, SWT.CHECK);
	_enableLog.setText(UIPlugin.getResourceString("ENABLE_LOGGING"));
	data = new GridData();
	_enableLog.setLayoutData(data);

	Group profilingInfo = new Group(content, SWT.NULL);
	profilingInfo.setText(UIPlugin.getResourceString("PROF_INFO_GRP"));	
	layout = new GridLayout();
	layout.numColumns = 2;
	profilingInfo.setLayout(layout);
	profilingInfo.setLayoutData(GridUtil.createHorizontalFill());
		
	Label desc = new Label(profilingInfo, SWT.NULL);
	desc.setText(UIPlugin.getResourceString("TRACEOPTIONSUI_TEXT"));
	_projectName = new Text(profilingInfo, SWT.BORDER);
	data = GridUtil.createHorizontalFill();
	_projectName.setLayoutData(data);

	Label portdesc = new Label(profilingInfo, SWT.NULL);
	portdesc.setText(UIPlugin.getResourceString("RAC_LOCALHOST_PORT_TEXT"));
	_localPort = new Text(profilingInfo, SWT.BORDER);
	data = GridUtil.createHorizontalFill();
	_localPort.setLayoutData(data);
	_localPort.addModifyListener(this);

	_enableInfoMsg = new Button(profilingInfo, SWT.CHECK);
	_enableInfoMsg.setText(UIPlugin.getResourceString("SHOW_PROFILE_TIPS"));
	data = new GridData();
	data.horizontalSpan = 2;
	_enableInfoMsg.setLayoutData(data);

	Group saveOnExitGroup = new Group(content, SWT.NONE);
	saveOnExitGroup.setText(UIPlugin.getResourceString("SAVE_ON_EXIT_GRP"));
	layout = new GridLayout();
	layout.numColumns = 3;
	saveOnExitGroup.setLayout(layout);
	data = GridUtil.createHorizontalFill();
	data.horizontalSpan = 2;	
	saveOnExitGroup.setLayoutData(data);
	
	_always = new Button(saveOnExitGroup, SWT.RADIO);
	_always.setText(UIPlugin.getResourceString("ALWAYS"));

	_never = new Button(saveOnExitGroup, SWT.RADIO);
	_never.setText(UIPlugin.getResourceString("NEVER"));

	_prompt = new Button(saveOnExitGroup, SWT.RADIO);
	_prompt.setText(UIPlugin.getResourceString("PROMPT"));

	Group refreshGroup = new Group(content, SWT.NONE);
	refreshGroup.setText(UIPlugin.getResourceString("REFRESH_V_GRP"));
	layout = new GridLayout();
	layout.numColumns = 2;
	refreshGroup.setLayout(layout);
	data = GridUtil.createHorizontalFill();
	data.horizontalSpan = 2;	
	refreshGroup.setLayoutData(data);
	
	_manualRefreshBtn = new Button(refreshGroup, SWT.RADIO);
	_manualRefreshBtn.setText(UIPlugin.getResourceString("MANUAL_REF"));
	data = GridUtil.createHorizontalFill();
	data.horizontalSpan = 2;	
	_manualRefreshBtn.setLayoutData(data);
	
	_automaticRefreshBtn = new Button(refreshGroup, SWT.RADIO);
	_automaticRefreshBtn.setText(UIPlugin.getResourceString("AUT_REF"));
	data = GridUtil.createHorizontalFill();
	data.horizontalSpan = 2;	
	_automaticRefreshBtn.setLayoutData(data);
	
	_refreshLabel = new Label(refreshGroup, SWT.NULL);
	data = new GridData();
	data.horizontalIndent = 20;
	_refreshLabel.setLayoutData(data);	
	_refreshLabel.setText(UIPlugin.getResourceString("REF_INTERVAL"));
	_refreshIntervalText = new Text(refreshGroup, SWT.BORDER);
	_refreshIntervalText.setLayoutData(GridUtil.createHorizontalFill());
	
	_enableProf.addSelectionListener(this);	
	_manualRefreshBtn.addSelectionListener(this);
	_automaticRefreshBtn.addSelectionListener(this);
		
	initializeValues();
		
	return content; 
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 10:44:50 AM)
 * @return boolean
 */
public boolean getLogOption() {
	return _enableLog.getSelection();
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 10:44:50 AM)
 * @return boolean
 */
public boolean getProfOption() {
	return _enableProf.getSelection();
}

/**
 * 
 * @return profiling message
 */
public boolean getInfoMsgOption(){
	return _enableInfoMsg.getSelection();
}

/**
 * 
 * @return 1 if the refresh is automatic, 0 otherwise 
 */
public int getRefreshType(){
	return _automaticRefreshBtn.getSelection()?1:0;
}

public int getRefreshInterval(){
	
	try {
		return Integer.parseInt(_refreshIntervalText.getText().trim());
	}
	catch(NumberFormatException exc){
		
		return UIPlugin.getDefault().getPreferenceStore().getDefaultInt(TraceConstants.REFRESH_INTERVAL);
	}
}


/**
 * Insert the method's description here.
 * Creation date: (5/10/2001 5:49:55 PM)
 * @return java.lang.String
 */
public String getProjectName() {
	return _projectName.getText().trim();
}

public String getLocalPortNumber() {
	return _localPort.getText().trim();
}

public String getSaveOnExitOption() {
	if (_always.getSelection()) {
		return MessageDialogWithToggle.ALWAYS;
	}
	else if (_never.getSelection()) {
		return MessageDialogWithToggle.NEVER;
	}
	else {
		return MessageDialogWithToggle.PROMPT;
	}
}

/**
 * Initializes states of the controls from the preference store.
 */
private void initializeValues()
{
	IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();

	setProfOption(store.getBoolean(TraceConstants.PROF_OPTION_KEY));
	setLogOption(store.getBoolean(TraceConstants.LOG_OPTION_KEY));	

	setProjectName(store.getString(TraceConstants.TRACE_PROJECT_NAME));		
	setLocalHostPort(store.getString(HyadesConstants.LOCALHOST_PORT));
	setInfoMsgOption(store.getBoolean(TraceConstants.PROFILE_TIPS));
	setSaveOnExitOption(store.getString(TraceConstants.SAVE_ON_EXIT_KEY));
	
	setRefreshType(store.getInt(TraceConstants.REFRESH_TYPE), store.getInt(TraceConstants.REFRESH_INTERVAL));			
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 10:43:06 AM)
 * @param option boolean
 */
public void setLogOption(boolean option)
{
	_enableLog.setSelection(option);
}

public void setRefreshType(int type, int interval)
{
	if(type == 1) //automatic
	{
		_manualRefreshBtn.setSelection(false);
		_automaticRefreshBtn.setSelection(true);		
	}
	else
	{
		_manualRefreshBtn.setSelection(true);
		_automaticRefreshBtn.setSelection(false);
		
		_refreshLabel.setEnabled(false);
		_refreshIntervalText.setEnabled(false);				
	}
	
	_refreshIntervalText.setText(String.valueOf(interval));	
}


public void setInfoMsgOption(boolean option){
	_enableInfoMsg.setSelection(option);
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 10:43:06 AM)
 * @param option boolean
 */
public void setProfOption(boolean option)
{
	_enableProf.setSelection(option);
}
/**
 * Insert the method's description here.
 * Creation date: (5/10/2001 5:49:10 PM)
 * @param name java.lang.String
 */
public void setProjectName(String name)
{
	_projectName.setText(name);
}

public void setLocalHostPort(String portNum)
{
	_localPort.setText(portNum);
}

public void setSaveOnExitOption(String value) {
	if (MessageDialogWithToggle.ALWAYS.equals(value)) {
		_always.setSelection(true);
	}
	else if (MessageDialogWithToggle.NEVER.equals(value)) {
		_never.setSelection(true);
	}
	else {
		_prompt.setSelection(true);
	}
}

/**
 * Sent when default selection occurs in the control.
 * <p>
 * For example, on some platforms default selection occurs
 * in a List when the user double-clicks an item or types
 * return in a Text.
 * </p>
 *
 * @param e an event containing information about the default selection
 */
public void widgetDefaultSelected(SelectionEvent e)
{}
/**
 * Sent when selection occurs in the control.
 * <p>
 * For example, on some platforms selection occurs in
 * a List when the user selects an item or items.
 * </p>
 *
 * @param e an event containing information about the selection
 */
public void widgetSelected(SelectionEvent e)
{
	if(e.widget == _manualRefreshBtn || e.widget == _automaticRefreshBtn)
   {
		_refreshLabel.setEnabled(_automaticRefreshBtn.getSelection());
		_refreshIntervalText.setEnabled(_automaticRefreshBtn.getSelection());				  	 
   }
}

public void modifyText(ModifyEvent e)
{
	if (e.widget == _localPort)
	{
		try
		{
			if (_localPort.getText().trim() == "")
			{
				_preferencePage.setErrorMessage(UIPlugin.getResourceString("RAC_EMPTY_PORT"));
				return;
			}
			
			int value = Integer.parseInt(_localPort.getText().trim());
			if (value<0)
			{
				_preferencePage.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
				_localPort.setFocus();
				return;
			}
			_preferencePage.setErrorMessage(null);
		}
		catch (NumberFormatException nfe)
		{
			if (_preferencePage != null)
				_preferencePage.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
				_localPort.setFocus();
		}
	}
}
}
