/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.net.UnknownHostException;
import java.util.ArrayList;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaArgumentsTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaSourceLookupTab;
import org.eclipse.jdt.internal.debug.ui.launcher.WorkingDirectoryBlock;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;

public class ProfileExternalJavaApplicationTabGroup extends AbstractLaunchConfigurationTabGroup
{
	public void createTabs(ILaunchConfigurationDialog dialog, String mode)
	{
		// check preferences whether profiling is enabled
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		boolean isProfilingEnabled = store.getBoolean(TraceConstants.PROF_OPTION_KEY);

		ArrayList tabs = new ArrayList(10);

		ProfileHostTab _hostTab = new ProfileHostTab();
		tabs.add(_hostTab);
		tabs.add(new ProfileMainTab(_hostTab));

		/*
		 * A customized arguments tab without the working path
		 * section.
		 */
		tabs.add(new JavaArgumentsTab() {
			protected WorkingDirectoryBlock createWorkingDirBlock() {
				return new WorkingDirectoryBlock() {
					public void createControl(Composite parent) {
					}
					public String getErrorMessage() {
						return null;
					}
					public String getMessage() {
						return null;
					}
					public void initializeFrom(ILaunchConfiguration configuration) {
					}
					public boolean isValid(ILaunchConfiguration config) {
						return true;
					}
					public void performApply(ILaunchConfigurationWorkingCopy configuration) {
					}
					public void setDefaults(ILaunchConfigurationWorkingCopy config) {
					}
				};
			}
		});

		if (isProfilingEnabled)
		{
			tabs.add(new ProfileTab(false));
		}

		tabs.add(new JavaSourceLookupTab());
		tabs.add(new ProfileEnvironmentTab());
		tabs.add(new CommonTab());

		AbstractLaunchConfigurationTab[] array = new AbstractLaunchConfigurationTab[tabs.size()];
		tabs.toArray(array);
		setTabs(array);
	}
}


