/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfiguration;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;

public class ProfileJUnitDelegate extends JUnitLaunchConfiguration {

	/*
	 * @see org.eclipse.jdt.internal.junit.launcher.JUnitBaseLaunchConfiguration#launch(org.eclipse.debug.core.ILaunchConfiguration, java.lang.String, org.eclipse.debug.core.ILaunch, org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
		try {
			monitor.beginTask("", 4);
			boolean success = ProfileLaunchUtil.performProfilingTypesLaunch(configuration);
			monitor.worked(1);
			
			if (!success) {
				monitor.setCanceled(true);
				return;
			}

			IJavaProject javaProject= getJavaProject(configuration);
			IType[] testTypes = getTestTypes(configuration, javaProject, monitor);
	
			IVMInstall install= getVMInstall(configuration);
			IVMRunner runner = install.getVMRunner("run");
			
			int port = SocketUtil.findFreePort();
			VMRunnerConfiguration runConfig = launchTypes(configuration, "run", testTypes, port);
			setDefaultSourceLocator(launch, configuration);
			monitor.worked(1);
			
			launch.setAttribute(PORT_ATTR, Integer.toString(port));
			launch.setAttribute(TESTTYPE_ATTR, testTypes[0].getHandleIdentifier());
	
			ProfilingSetsManager manager = ProfilingSetsManager.instance();
			IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
	
			TraceArguments args = new TraceArguments(runConfig.getClassToLaunch());
			args.setClassPath(ProfileLaunchUtil.convertToDelimitedString(runConfig.getClassPath(), File.pathSeparatorChar));
			args.setParameters(ProfileLaunchUtil.convertToDelimitedString(runConfig.getProgramArguments(), ' '));
			args.setVMArguments(ProfileLaunchUtil.convertToDelimitedString(runConfig.getVMArguments(), ' '));
			args.setEnvironmentVariable(ProfileLaunchUtil.getEnvironmentVariables(configuration));
			args.setAutoMonitoring(manager.getAutoMonitoring(configuration));
			args.setLocation(runConfig.getWorkingDirectory());
			
			String hostName = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
			port = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt(HyadesConstants.LOCALHOST_PORT));
			String projectName = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString(TraceConstants.TRACE_PROJECT_NAME));
			String monitorName = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString(TraceConstants.TRACE_MONITOR_NAME));
	
			args.setHostName(hostName);
			args.setPortNumber(port);
	
			if (configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false))
				args.setProfileFile(configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String)null));
	
			ArrayList filters = manager.getFilters(configuration);
			Vector options = manager.getOptions(configuration);
			monitor.worked(1);
			
			if (!PDCoreUtil.launchTrace(args, filters, options, projectName, monitorName, launch)) {
				monitor.setCanceled(true);
			}
			monitor.worked(1);
		}
		catch (CoreException e) {
			monitor.setCanceled(true);
			throw e;
		}
	}
}
