/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
* CONTEXT_ID opwp0000 for open process wizard page
*/

public class OpenProcessWizardPage  extends WizardPage
									implements ModifyListener
{
  private TraceProcessUI _processUI;
  private boolean _refresh=false;

  public OpenProcessWizardPage(String name)
  {
	super(name);
	setTitle(UIPlugin.getResourceString("OPENPROCESSWIZARDPAGE_PROCESS_PROPERTY"));
	setDescription(UIPlugin.getResourceString("OPENPROCESSWIZARDPAGE_PROCESS_DESC"));
  }
  public void createControl(Composite parent)
  {
	_processUI = new TraceProcessUI();
	Control content = _processUI.createControl(parent);

	_processUI.getLocationUI().setEnabled(false);		
	
	_processUI.getLaunchProcessUI().enable(false);
	
	_processUI.getProcessIdUI().setEnabled(false);
	_processUI.getNodeNameUI().setEnabled(false);
	
	initData();
	
	setControl(content);

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
	UIPlugin.getPluginId()+".opwp0000");
  }
  public boolean finish()
  {
	TRCProcessProxy process = ((OpenProcessWizard)getWizard()).getProcess();

	if(process == null)
	  return false;
	
	process.setClasspath(_processUI.getLaunchProcessUI().getClassPath());
	process.setName(_processUI.getLaunchProcessUI().getClassName());

 	if (_refresh)
	   	UIPlugin.getDefault().getViewer().getViewer().refresh();
	 
	return(true);
	
  }
/**
 * Insert the method's description here.
 * Creation date: (5/7/2001 12:30:07 PM)
 */
private void initData()
{	
	TRCProcessProxy process = ((OpenProcessWizard)getWizard()).getProcess();

	IResource sel = HyadesUtil.getSelectionFolder(((OpenProcessWizard)getWizard()).getViewer());
	if(sel != null)
	   _processUI.getLocationUI().setLocation(sel.getFullPath().toOSString());

	_processUI.getLocationUI().setMonitor(process.getNode().getMonitor().getName());
	
	String name = process.getName();
	if(name != null)
	{
		_processUI.getLaunchProcessUI().getClassUI().setText(name);
		if (process.getLaunchMode()!=1)
		{
			_processUI.getLaunchProcessUI().getClassUI().setEnabled(true);
			_refresh=true;
		}
	}
	_processUI.getProcessIdUI().setText(String.valueOf(process.getPid()));
	_processUI.getNodeNameUI().setText(process.getNode().getName());

	if(process.getClasspath() != null)
		_processUI.getLaunchProcessUI().getClassPathUI().setText(process.getClasspath());
}
/**
 * Sent when the text is modified.
 *
 * @param e an event containing information about the modify
 */
public void modifyText(ModifyEvent e)
{
	setPageComplete(!_processUI.getLaunchProcessUI().getClassUI().getText().trim().equals(""));
}
}
