/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.harness;

import java.util.ArrayList;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.harness.util.ISystemUtility;

/**
 * @author ejessee
 */
public class ExecutionHarnessDataProcessorFactory 
{
	private static ArrayList standAloneClassObjects = null;
	private static IConfigurationElement[] dpConfigElements=null;
	
	private boolean bStandAlone = false;
	
	
	public ExecutionHarnessDataProcessorFactory(boolean bStandAlone)
	{
		if(!bStandAlone &&dpConfigElements == null)
			loadDataProcessors();
		
		this.bStandAlone = bStandAlone;
	}
	
	
	/**
	 * loads dataprocessors if we are not running standalone
	 * @return
	 */
	private void loadDataProcessors()
	{
		
		dpConfigElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.hyades.execution.harness.Dataprocessor"); //$NON-NLS-1$
		
			
	}	

	/**
	 * called to set the ArrayList of dataProcessor classes
	 * this array list should contained non-instantiated class objects which implement the
	 * IExecutionHarnessDataProcessor interface
	 * This api should only be called in "standalone" mode.
	 * @param standAloneClassObjects
	 */
	public static void setStandAloneClassObjects(ArrayList standAloneClassObjects) 
	{		
		ExecutionHarnessDataProcessorFactory.standAloneClassObjects = standAloneClassObjects;
		
	}
	
	

	/**
	 * @return Returns the dataProcessors collection.  Each object in the collection is an instantiated but not
	 * initialized dataprocessor.
	 */
	public ArrayList getDataProcessors() 
	{
		ArrayList dataProcessors = new ArrayList();
		if(this.bStandAlone)
		{
			for(int i=0; i<standAloneClassObjects.size(); i++)
			{
				try 
				{
					dataProcessors.add(((Class)standAloneClassObjects.get(i)).newInstance());
				} 
				catch (InstantiationException e) {
					
					((ISystemUtility)ExecutionHarnessPlugin.getDefault()).logError(e);
				} 
				catch (IllegalAccessException e) {
					
					((ISystemUtility)ExecutionHarnessPlugin.getDefault()).logError(e);
				}
			}
		}
		
		else
		{
			for ( int i=0; i<dpConfigElements.length; i++)
			{
				try
				{
					IExecutionHarnessDataProcessor dataProcessor = (IExecutionHarnessDataProcessor)dpConfigElements[i].createExecutableExtension("class"); //$NON-NLS-1$
					dataProcessors.add(dataProcessor);
				}
				catch(CoreException e)
				{
					((ISystemUtility)ExecutionHarnessPlugin.getDefault()).logError(e);
				}
			}
		}
		
		return dataProcessors;
	}

}
