/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.CSVImportExportUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class DatapoolExportWizard extends Wizard implements IExportWizard {

	DatapoolExportSelectionPage datapoolSelectionPage = null;
	DatapoolExportCSVFileLocationPage csvFileLocationPage = null;
	
	public DatapoolExportWizard()
	{
		super();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench, org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) 
	{
		setWindowTitle(TestUIPlugin.getString("WIZ_EXP_DATAPOOL_TTL"));
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#createPageControls(Composite)
	 */
	public void createPageControls(Composite pageContainer)
	{
		super.createPageControls(pageContainer);		
	}

	
	public void addPages()
	{
		csvFileLocationPage = new DatapoolExportCSVFileLocationPage("csvFileSelection");
		csvFileLocationPage.setTitle(TestUIPlugin.getString("WIZ_EXP_DATAPOOL_CSV_PG_TTL"));
		csvFileLocationPage.setDescription(TestUIPlugin.getString("WIZ_EXP_DATAPOOL_CSV_PG_DSC"));
		addPage(csvFileLocationPage);
		
		datapoolSelectionPage = new DatapoolExportSelectionPage("datapoolSelection");
		datapoolSelectionPage.setTitle(TestUIPlugin.getString("WIZ_EXP_DATAPOOL_SEL_PG_TTL"));
		datapoolSelectionPage.setDescription(TestUIPlugin.getString("WIZ_EXP_DATAPOOL_SEL_PG_DSC"));
		addPage(datapoolSelectionPage);
	}

	public boolean canFinish()
	{
		return csvFileLocationPage.isPageComplete() && datapoolSelectionPage.isPageComplete();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish() 
	{
		IDatapool datapool = datapoolSelectionPage.getDatapool();
		String csvFileName = csvFileLocationPage.getCSVFileName();

		File file = new File(csvFileName);
		
		if (file.exists())
		{
			Object[] messageElements = {csvFileName,  TestUIPlugin.getString("WIZ_EXP_DATAPOOL_MSG_EXISTS")}; //$NON-NLS-1$
			String message = MessageFormat.format("{0} {1}", messageElements); //$NON-NLS-1$
			MessageDialog overwriteDialog = new MessageDialog(getShell(),
															  TestUIPlugin.getString("WIZ_EXP_DATAPOOL_TTL"), //$NON-NLS-1$
															  null,
															  message, 
															  MessageDialog.WARNING, 
															  new String[] {IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 
															  0);
			
			// user selected - "don't replace", return false
			if (overwriteDialog.open() != 0)
				return false;
		}
		
		boolean exportVariables = csvFileLocationPage.getExportVariables();
		boolean exportEqClsNames = csvFileLocationPage.getExportEquivalenceClassNames();
		boolean exportTags = csvFileLocationPage.getExportTags();
		String exportEncoding = csvFileLocationPage.getExportEncoding();
		CSVImportExportUtil.getInstance().exportCSV(datapool, csvFileName, exportVariables, exportEqClsNames, exportTags, exportEncoding);
		return true;
	}
}
