/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.configurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.util.DeploymentUtil;

/**
 * 
 * @author jcanches
 */
public class DeploymentLaunchConfigurationFacade extends AbstractLaunchConfigurationFacade {

	private final static String PROPERTY_DEPLOYMENT = PROPERTY_PREFIX + ".deployment"; //$NON-NLS-1$

	/**
	 * Retrieves the Deployment property of a Hyades Launch Configuration. This property defines
	 * which Deployment will be used to run the Launch Configuration's test.
	 * @deprecated
	 * @see DeploymentLaunchConfigurationFacade#getDeployment(ILaunchConfiguration, ResourceSet)
	 */
	public static TPFDeployment getDeployment(ILaunchConfiguration configuration) throws CoreException {
		return getDeployment(configuration, EMFUtil.getResourceSet());
	}
	
	/**
	 * Retrieves the Deployment property of a Hyades Launch Configuration. This property defines
	 * which Deployment will be used to run the Launch Configuration's test.
	 * @param configuration
	 * @param resourceSet The Resource Set that should contain the returned Deployment.
	 * @since 3.1
	 */
	public static TPFDeployment getDeployment(ILaunchConfiguration configuration, ResourceSet resourceSet) throws CoreException {
		EObject eObject = resolveEMFReference(configuration, PROPERTY_DEPLOYMENT, resourceSet);
		if (eObject != null && eObject instanceof TPFDeployment) {
			// added to make sure deployment contains a valid pair of location and artifact for this test suite
			// and automatically calculate CLASSPATH for this test
			// bugzilla# 58827. bjiang 4/21/2004
			TPFTest test = TestLaunchConfigurationFacade.getTest(configuration, resourceSet);
			TPFTestSuite testSuite = null;
			if (test instanceof TPFTestSuite)
				testSuite = (TPFTestSuite)test;
			else if (test instanceof TPFTestCase)
				testSuite = ((TPFTestCase)test).getTestSuite();
			
			if(testSuite != null)
				DeploymentUtil.associateTestAsset(testSuite, (TPFDeployment)eObject);
			
			return (TPFDeployment)eObject;
		}
		return null;
	}
	
	/**
	 * Define the Deployment property of a Hyades Launch Configuration. This property defines
	 * which Deployment will be used to run the Launch Configuration's test.
	 */	
	public static void setDeployment(ILaunchConfigurationWorkingCopy configuration, TPFDeployment deployment) {
		storeEMFReference(configuration, PROPERTY_DEPLOYMENT, deployment);
	}
	
}
