/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.datapool.impl;

import java.util.HashMap;

import org.eclipse.hyades.execution.runtime.datapool.*;

/**
 * @author ahoppe
 * @author psun
 *
 */
public class DatapoolIteratorImpl_Shared_ExtSequential
	extends DatapoolIteratorImpl_Private_Base
	implements IDatapoolIterator 
{
	
    private static DatapoolIteratorImpl_Shared_ExtSequential instance = null;
    private HashMap properties = null;
    
    private DatapoolIteratorImpl_Shared_ExtSequential()
    {
    }
 	
 	public static DatapoolIteratorImpl_Shared_ExtSequential getInstance()
 	{
 		synchronized(instance)
 		{
		if (instance == null)
			instance = new DatapoolIteratorImpl_Shared_ExtSequential();
 		}
		return instance;
 	}

	/**
	 * Initialize the iterator sequence from the specified datapool object.
	 * Depending on the implementation of this method the iterator may use
	 * sequential or random access order, share a cursor with other processes
	 * or use a repeating sequence to access the records.  The order of access
	 * is left to the individual iterator implementations.
	 * 
	 * @param	datapool	The datapool to iterate over.
	 * @param	equivalenceClassIndex	The zero-based index of the equivalence
	 *						class that should be iterated over.  If this value
	 *						is negative then all records in the datapool should be
	 *						will be available to the iterator.
	 */
	public void dpInitialize(IDatapool datapool, int equivalenceClassIndex)
	{
		synchronized(this) {
		    myDatapool = datapool;				
		    allEquivClasses = (equivalenceClassIndex < 0);
		    if(allEquivClasses)
		        currentEquivClassIndex = 0;
		    else
		        currentEquivClassIndex = equivalenceClassIndex;
		    currentRecordIndex = 0;
		    done = this.dpDone();
		}				
	}

	/**
	 * This method acts the same way as {@link #dpInitialize(IDatapool,int) dpInitialize with equivalence class specification}
	 * except that {@link IDatapool#getDefaultEquivalenceClassIndex() default} 
	 * equivalence class is used.
	 * 
	 * @param	datapool	The datapool to iterate over.
	 */
	public void dpInitialize(IDatapool datapool)
	{
		this.dpInitialize(datapool, datapool.getDefaultEquivalenceClassIndex());
	}

	/**
	 * The datapool being iterated over.  If the iterator has not been initialized
	 * then <code>null</code> is returned.
	 * 
	 * @return	The datapool being iterated over.
	 */
/*				public IDatapool getDatapool()
				{
					return myDatapool;
				}
*/	
	/**
	 * The record currently available from this iterator for the associated
	 * instance of the datapool.  This method will return the same value
	 * repeated until the iterator is incremented by a call to the
	 * {@link #dpNext() next method}.  A value of <code>null</code> is 
	 * returned when the iterator is out of values.
	 * 
	 * @return	The current record in the itertion sequence or <code>null</code>.
	 * 
	 * @see	#dpNext()
	 * @see #dpDone()
	 * @see #dpReset()
	 */
/*				public IDatapoolRecord dpCurrent()
				{
					if (this.dpDone())
					    return null;
					else
					    return myDatapool.getEquivalenceClass(currentEquivClassIndex)
					                                .getRecord(currentRecordIndex);
				}
*/	
	/**
	 * Returns <code>true</code> if the {@link #dpCurrent() current} iterator
	 * value is <code>null</code>.
	 * 
	 * @see	#dpCurrent()
	 * @see #dpNext()
	 * @see #dpReset()
	 */
	public boolean dpDone()
	{
		if (!allEquivClasses)
		    return (currentRecordIndex == 
		    myDatapool.getEquivalenceClass(currentEquivClassIndex).getRecordCount());
		else
		    return (
		      (currentEquivClassIndex == myDatapool.getEquivalenceClassCount())
		      && 
		      (currentRecordIndex == 0)
		    );
		    
	}

	/**
	 * Increments the iterator associated with an instance of the datapool.
	 * Calling this method after the iteration sequence has been exhausted has no
	 * effect.
	 * 
	 * @see	#dpCurrent()
	 * @see #dpDone()
	 * @see #dpReset()
	 */
	public void dpNext()
	{
		synchronized(this) {
	        if (!allEquivClasses)
	        {
	    	    if(currentRecordIndex < 
	    	    myDatapool.getEquivalenceClass(currentEquivClassIndex).getRecordCount())
	    	       currentRecordIndex++;				    	
	        }
	        else 
	        {
	    	    if (currentEquivClassIndex < myDatapool.getEquivalenceClassCount())
			        if(currentRecordIndex < 
		               myDatapool.getEquivalenceClass(currentEquivClassIndex).getRecordCount()-1)
		                currentRecordIndex++;
		            else
		            {
		        	    currentEquivClassIndex++;
		        	    currentRecordIndex = 0;	
		            }
	        }
	    }
	}

	/**
	 * Restart the iterator associated with an instance of the datapool.
	 * It does not matter if the iterator has been exhausted of entries or
	 * not, the iterator simply resets to the initial start state.
	 * 
	 * @see	#dpCurrent()
	 * @see #dpDone()
	 * @see #dpNext()
	 */
	public void dpReset()
	{
		synchronized(this) {
		    if(allEquivClasses)
		        this.dpInitialize(myDatapool, -1);
		    else
		        this.dpInitialize(myDatapool, currentEquivClassIndex);
	    }
	}

	/**
	 * Returns the <code>Object</code> associated with the specified property name.
	 * 
	 * @param	propertyName
	 * @return 	The <code>Object</code> assoicated with the specified property name.
	 */
	public Object getProperty(String propertyName) 
	{
		if(properties != null)
		{
			return properties.get(propertyName);
		}
		return null;
	}

	/**
	 * Sets the property with the specified name with a value captued in the <code>Object</code>.
	 * 
	 * @param 	propertyName
	 * @param	propertyValue
	 */
	public void setProperty(String propertyName, Object propertyValue) 
	{
		if(properties == null)
			properties = new HashMap();
		properties.put(propertyName, propertyValue);
	}
}
