/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TPF Timezone</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Timezones serve as a grouping mechanisms for test components within a test system. Each test component belongs at most to one timezone. Test components in the same timezone have the same perception of time, i.e. test components of the same timezone are considered to be time synchronized. The time zone of a test component can be accessed both in the model and in run-time.
 * 
 * Comparing time-critical events within the same timezone is allowed. Comparing time-critical events of different timezones is a matter of semantic variation point and should be decided by the tool vendor. By default, comparison between events in two different timezones is illegal.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFTimezone#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFTimezone#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFTimezone#getLocations <em>Locations</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFTimezone()
 * @model 
 * @generated
 */
public interface TPFTimezone extends EObject{
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String copyright = "";

    /**
     * Returns the value of the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Name</em>' attribute.
     * @see #setName(String)
     * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFTimezone_Name()
     * @model 
     * @generated
     */
	String getName();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFTimezone#getName <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Name</em>' attribute.
     * @see #getName()
     * @generated
     */
	void setName(String value);

    /**
     * Returns the value of the '<em><b>Description</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Description</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Description</em>' attribute.
     * @see #setDescription(String)
     * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFTimezone_Description()
     * @model 
     * @generated
     */
	String getDescription();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFTimezone#getDescription <em>Description</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Description</em>' attribute.
     * @see #getDescription()
     * @generated
     */
	void setDescription(String value);

    /**
     * Returns the value of the '<em><b>Locations</b></em>' reference list.
     * The list contents are of type {@link org.eclipse.hyades.models.common.configuration.CFGLocation}.
     * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getTimezone <em>Timezone</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Locations</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Locations</em>' reference list.
     * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFTimezone_Locations()
     * @see org.eclipse.hyades.models.common.configuration.CFGLocation#getTimezone
     * @model type="org.eclipse.hyades.models.common.configuration.CFGLocation" opposite="timezone"
     * @generated
     */
	EList getLocations();

} // TPFTimezone
