/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.statistical.ui.editor.internal;


import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.*;
import org.eclipse.hyades.statistical.ui.widgets.internal.*;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.custom.*;

import java.util.*;


public class AlertTablePanel extends Composite implements SelectionListener {
	
	Combo provider;
	Button tester;
	Label label;
	Group config_panel;
	HashMap actions_cache = new HashMap();	
	HashMap controls_cache = new HashMap();
	
	StackLayout layout_stack = new StackLayout();

	public AlertTablePanel(Composite parent, String description) {
		super(parent,SWT.SHADOW_ETCHED_IN);

		initGraphics(parent, description);
		initEventHandling();
	}
	
	public void setEnabled(boolean b) {
		super.setEnabled(b);
		provider.setEnabled(b);
		label.setEnabled(b);
		tester.setEnabled(b);
	}
	
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {
		Object o = e.getSource();
		if (o == provider) {
			updateSubPanel();
		} else if (o == tester) {
			try {
				AlertAction tmp = getConfiguredAction();
				tmp.setInformation("TEST ALERT",null,999.0,System.currentTimeMillis(),true);
				tmp.run();
			} catch (Throwable t) {
				MessageBox mbox = new MessageBox(getShell());
				mbox.setText(EditorPlugin.getString("ERROR_LABEL"));
				mbox.setMessage(EditorPlugin.getString("ERROR_LABEL")+t.getMessage());
				mbox.open();
			}
		}
	}

	private void updateSubPanel() {
		int i = provider.getSelectionIndex();
		StatConAlertActionProvider provider = AlertRegistry.getProviders()[i];

		AlertAction newaction = (AlertAction)actions_cache.get(provider);

//System.out.println("SHOWING CONTROL FOR PROVIDER "+provider.getName());			
		layout_stack.topControl = (Control)controls_cache.get(provider);

		config_panel.layout(true);
		config_panel.redraw();
	}
	
	private void initEventHandling() {
		provider.addSelectionListener(this);
		tester.addSelectionListener(this);
	}
	
	private void initGraphics(Composite main_panel, String description) {
		setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		setLayout(new GridLayout(3,false));
		label = new Label(this,0);
			label.setText(description);
			label.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.BEGINNING,GridData.CENTER));
		provider = new Combo(this,SWT.BORDER);
			provider.setItems(AlertRegistry.getProviderNames());
			provider.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.BEGINNING,GridData.CENTER));
		tester = new Button(this,0);
			tester.setText(EditorPlugin.getString("ALERT_TEST"));
			tester.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.END,GridData.CENTER));
		config_panel = new Group(this,SWT.SHADOW_ETCHED_IN);
		config_panel.setLayoutData(GData.getGridData(true,true,-1,-1,3,1,GridData.FILL,GridData.FILL));
		config_panel.setLayout(layout_stack);

		StatConAlertActionProvider[] providers = AlertRegistry.getProviders();
		for (int i = 0; i < providers.length; i++) {
			controls_cache.put(providers[i],providers[i].newAlertAction().getControl(config_panel));
		}
		/*		
		StatConAlertActionProvider[] providers = AlertRegistry.getProviders();
		for (int i = 0; i < providers.length; i++) {
			AlertAction tmp;
			
			if (providers[i].getName().equals(action.getProviderName())) {
				//current action
				tmp = action;
			} else {
				//new action
				tmp = providers[i].newAlertAction();
			}
			
			actions_cache.put(providers[i],tmp);

			controls_cache.put(providers[i],tmp.getControl(config_panel));
//			Label test = new Label(config_panel,0);
//			test.setText(providers[i].getName());
//			controls_cache.put(providers[i],test);
			
//			System.out.println("Added control for "+providers[i].getName()+" / "+tmp.getProviderName());
		}
*/		
//		layout_stack.topControl = (Control)controls_cache.get(AlertRegistry.getProvider(action.getProviderName()));
//		config_panel.layout(true);
//		config_panel.redraw();

//		provider.select(getProviderIndex(action.getProviderName()));
	}
	
	private int getProviderIndex(String name) {
		String[] provider_names = AlertRegistry.getProviderNames();
		for (int i = 0; i < provider_names.length; i++) {
			if (name.equals(provider_names[i])) {
				return i;
			}
		}
		return 0;
	}
	
	public void clearControls() {
		StatConAlertActionProvider[] providers = AlertRegistry.getProviders();
		for (int i = 0; i < providers.length; i++) {
			AlertActionControl control = (AlertActionControl)controls_cache.get(providers[i]);
			control.readFromAction(providers[i].newAlertAction());
		}
	}
	
	public void setConfiguredAction(AlertAction action) {
		
		clearControls();
		
		layout_stack.topControl = (Control)controls_cache.get(AlertRegistry.getProvider(action.getProviderName()));
		((AlertActionControl)layout_stack.topControl).readFromAction(action);
		
		config_panel.layout(true);
		config_panel.redraw();

		provider.select(getProviderIndex(action.getProviderName()));
	}
	
	public AlertAction getConfiguredAction() throws InvalidDataException {
		AlertActionControl control = (AlertActionControl)layout_stack.topControl;
		return control.writeToClonedAction();
	}
	
	public String getCurrentDescription() {
		AlertActionControl control = (AlertActionControl)layout_stack.topControl;
		return control.getDescription();
	}

}