/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.statistical.ui.*;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.*;
import org.eclipse.hyades.statistical.ui.widgets.internal.*;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;

import java.text.*;

import org.eclipse.hyades.statistical.ui.EditorPlugin;

public class GraphTableDialog extends Dialog implements SelectionListener {

	DecimalFormat df = new DecimalFormat("###########################################.########################################");
	
	String[] plotting_types = new String[]{
			EditorPlugin.getString("PLOTTING_TYPE_AVERAGE"),
			EditorPlugin.getString("PLOTTING_TYPE_MAX"),
			EditorPlugin.getString("PLOTTING_TYPE_MIN"),
			EditorPlugin.getString("PLOTTING_TYPE_SUM"),
			EditorPlugin.getString("PLOTTING_TYPE_COUNT"),
			EditorPlugin.getString("PLOTTING_TYPE_NEAREST"),
			EditorPlugin.getString("PLOTTING_TYPE_MAX_MIN"),
			EditorPlugin.getString("PLOTTING_TYPE_AVG_MAX_MIN"),
			EditorPlugin.getString("PLOTTING_TYPE_STDDEV"),
			EditorPlugin.getString("PLOTTING_TYPE_STDDEV_AVG"),
	};
	
	Image image;
	
	Graph graph;
	RGB rgb_black = new RGB(0,0,0);
	
	Shell shell;
	
	Composite main_panel;
	
	Label error_img;
	Label error_label;
	
	Group color_panel;
		RGB color = rgb_black;
		Label color_label;
		Button color_set;
	
//	Group slider_panel;
//		Label hslider_label;
//		Combo hslider_choice;
//		Label vslider_label;
//		Combo vslider_choice;
	
	Group plotting_panel;
		Combo plotting_choice;
		
	Group period_panel;
		Composite period_millis;
			Button period_millis_set;
			Text period_millis_value;
			Label period_millis_label;
		Composite period_ticks;
			Button period_ticks_set;
			Text period_ticks_value;
			Label period_ticks_label;
		Composite period_pixels;
			Button period_pixels_set;
			Text period_pixels_value;
			Label period_pixels_label;
//		Composite period_ignored;
//			Button period_ignored_set;
//			Label period_ignored_label;
	
	Group nodata_panel;
		Button nodata_nothing;
		Button nodata_drawzero;
		Button nodata_drawprevious;
	
	Group offset_panel;
		Composite xoffset_panel;
			Text xoffset_set;
			Label xoffset_label;
			Button xoffset_snap;
		Composite yoffset_panel;
			Text yoffset_set;
			Label yoffset_label;
		Composite multiplier_panel;
			Text multiplier_set;
			Label multiplier_label;
	
	Composite button_panel;
		Button button_ok;
		Button button_cancel;
		
	public GraphTableDialog(Shell shell) {
		super(shell);
	}
	
	public void setGraph(Graph graph) {
		this.graph = graph;
		readFromGraph();
	}
	
	private void redoColorImage() {
		Image tmpimage = image;
		
		PaletteData palettedat = new PaletteData(new RGB[]{color,color});
		ImageData imgdat = new ImageData(30,30,1,palettedat);			
		image = new Image(Display.getDefault(),imgdat);
		
		try {
			color_label.setImage(image);
			main_panel.redraw();
			color_label.redraw();
		} catch (NullPointerException e) {
			//this is ok
		} catch (Exception e) {
			EditorPlugin.DBG.warning("error setting color image",e);
		}
		
		if (tmpimage != null) tmpimage.dispose();
	}
	
	public Object open() {
		
		int WIDTH = 300;
		int HEIGHT = 300;
		
		Shell parent = getParent();
		shell = new Shell(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL | SWT.RESIZE);
		shell.setText(EditorPlugin.getString("CONFIGURE_GRAPH"));
		shell.setLayout(new FillLayout());
		shell.setBounds(0,0,WIDTH,HEIGHT);
		
		initGraphics();
		initEventHandling();

		shell.pack();

		readFromGraph();

		Rectangle r = parent.getBounds();
		Rectangle z = shell.getBounds();
		if (z.width < WIDTH) z.width = WIDTH;
		if (z.height < HEIGHT) z.height = HEIGHT;

		shell.setBounds( r.x + (r.width/2) - (z.width/2),
						 r.y + (r.height/2) - (z.height/2),
						 z.width,
						 z.height
						 );
		
		shell.open();
		Display display = parent.getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) display.sleep();
		}
		
		return graph;
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {
		Object o = e.getSource();
		if (o == button_ok) {
			try {
				writeToGraph();
				shell.dispose();
			} catch (Exception x) {
				error_label.setText(EditorPlugin.getString("ERROR_LABEL")+x.getMessage());
				error_img.setImage(EditorPlugin.img.getImage(ImageManager.IMG_ERROR));
				main_panel.layout(true);
				error_label.redraw();
				error_img.redraw();
			}
		} else if (o == button_cancel) {
			shell.dispose();
		} else if (o == color_set) {
			ColorDialog dialog = new ColorDialog(shell);
			dialog.setRGB(color);
			dialog.open();
			color = dialog.getRGB();	
			redoColorImage();
		} else if (o == xoffset_snap) {
			double tmax = graph.getGraphSource().getMax();
			double tnow = System.currentTimeMillis();
			xoffset_set.setText(df.format((long)(tnow-tmax)));
		}
	}

	
	private void initEventHandling() {
		button_ok.addSelectionListener(this);
		button_cancel.addSelectionListener(this);
		color_set.addSelectionListener(this);
		xoffset_snap.addSelectionListener(this);
	}
	
	private void initGraphics() {
		main_panel = new Composite(shell,0);
		main_panel.setLayout(new GridLayout(2,false));
		
		String DEF_TEXT = "               ";
		
		int groupHints = SWT.SHADOW_ETCHED_IN;
		
		error_img = new Label(main_panel,SWT.NONE);
		error_label = new Label(main_panel,SWT.NONE);
		error_label.setText("");
		
		color_panel = new Group(main_panel,groupHints);
		color_panel.setText(EditorPlugin.getString("GRAPH_COLOR_PANEL_TITLE"));
		color_panel.setLayoutData(GData.getGridData(true,false,-1,-1,2,1,GridData.FILL,GridData.FILL));
		color_panel.setLayout(new RowLayout(SWT.HORIZONTAL));
			color_label = new Label(color_panel,0);
			redoColorImage();
			color_label.setImage(image);
			color_set = new Button(color_panel,SWT.PUSH);
			color_set.setText(EditorPlugin.getString("SET_COLOR"));
/*
		slider_panel = new Group(main_panel,groupHints);
		slider_panel.setText(EditorPlugin.getString("GRAPH_SLIDER_PANEL_TITLE"));
		slider_panel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		slider_panel.setLayout(new GridLayout(2,false));
			hslider_label = new Label(slider_panel,0);
			hslider_choice = new Combo
			hslider_label.setText(EditorPlugin.getString("HORIZONTAL_SLIDER"));
			vslider_label = new Label(slider_panel,0);
			vslider_label.setText(EditorPlugin.getString("VERTICAL_SLIDER"));
*/
		plotting_panel = new Group(main_panel,groupHints);
		plotting_panel.setText(EditorPlugin.getString("GRAPH_PLOTTING_PANEL_TITLE"));
		plotting_panel.setLayoutData(GData.getGridData(true,false,-1,-1,2,1,GridData.FILL,GridData.FILL));
		plotting_panel.setLayout(new RowLayout(SWT.HORIZONTAL));
			plotting_choice = new Combo(plotting_panel,SWT.BORDER);
			plotting_choice.setItems(plotting_types);
			
		period_panel = new Group(main_panel,groupHints);
		period_panel.setText(EditorPlugin.getString("GRAPH_PERIOD_PANEL_TITLE"));
		period_panel.setLayoutData(GData.getGridData(true,false,-1,-1,2,1,GridData.FILL,GridData.FILL));
		period_panel.setLayout(new GridLayout(2,false));
		
			//
			period_millis_set = new Button(period_panel,SWT.RADIO);

			period_millis = new Composite(period_panel,SWT.NONE);
			period_millis.setLayout(new RowLayout(SWT.HORIZONTAL));
			
			period_millis_value = new Text(period_millis,SWT.BORDER);
			period_millis_value.setText(DEF_TEXT);
			period_millis_label = new Label(period_millis,0);
			period_millis_label.setText("  "+EditorPlugin.getString("AVG_MILLIS"));
		
			//
			period_ticks_set = new Button(period_panel,SWT.RADIO);

			period_ticks = new Composite(period_panel,SWT.NONE);
			period_ticks.setLayout(new RowLayout(SWT.HORIZONTAL));
			
			period_ticks_value = new Text(period_ticks,SWT.BORDER);
			period_ticks_value.setText(DEF_TEXT);
			period_ticks_label = new Label(period_ticks,0);
			period_ticks_label.setText("  "+EditorPlugin.getString("AVG_TICKS"));
			
			//
			period_pixels_set = new Button(period_panel,SWT.RADIO);
			
			period_pixels = new Composite(period_panel,SWT.NONE);
			period_pixels.setLayout(new RowLayout(SWT.HORIZONTAL));

			period_pixels_value = new Text(period_pixels,SWT.BORDER);
			period_pixels_value.setText(DEF_TEXT);
			period_pixels_label = new Label(period_pixels,0);
			period_pixels_label.setText("  "+EditorPlugin.getString("AVG_PIXELS"));

			//
//			period_ignored_set = new Button(period_panel,SWT.RADIO);
//			
//			period_ignored = new Composite(period_panel,SWT.NONE);
//			period_ignored.setLayout(new RowLayout(SWT.HORIZONTAL));
//
//			period_ignored_label = new Label(period_ignored,0);
//			period_ignored_label.setText(EditorPlugin.getString("AVG_IGNORED"));
			
		nodata_panel = new Group(main_panel,groupHints);
		nodata_panel.setText(EditorPlugin.getString("GRAPH_NODATA_PANEL_TITLE"));
		nodata_panel.setLayoutData(GData.getGridData(true,false,-1,-1,2,1,GridData.FILL,GridData.FILL));
		nodata_panel.setLayout(new GridLayout(1,false));
			nodata_drawzero = new Button(nodata_panel,SWT.RADIO);	
			nodata_drawzero.setText(EditorPlugin.getString("NODATA_DRAWZERO"));
			
			nodata_nothing = new Button(nodata_panel,SWT.RADIO);	
			nodata_nothing.setText(EditorPlugin.getString("NODATA_DONOTHING"));

			nodata_drawprevious = new Button(nodata_panel,SWT.RADIO);	
			nodata_drawprevious.setText(EditorPlugin.getString("NODATA_DRAWPREVIOUS"));
		
		offset_panel = new Group(main_panel,groupHints);
		offset_panel.setText(EditorPlugin.getString("GRAPH_OFFSET_PANEL_TITLE"));
		offset_panel.setLayoutData(GData.getGridData(true,false,-1,-1,2,1,GridData.FILL,GridData.FILL));
		offset_panel.setLayout(new GridLayout(1,false));
			xoffset_panel = new Composite(offset_panel,SWT.NONE);
			xoffset_panel.setLayout(new RowLayout(SWT.HORIZONTAL));
				xoffset_set = new Text(xoffset_panel,SWT.BORDER);
				xoffset_label = new Label(xoffset_panel,SWT.NONE);	
				xoffset_label.setText(EditorPlugin.getString("XOFFSET_LABEL"));
				xoffset_snap = new Button(xoffset_panel,SWT.PUSH);
				xoffset_snap.setText(EditorPlugin.getString("XOFFSET_SNAP"));
			yoffset_panel = new Composite(offset_panel,SWT.NONE);
			yoffset_panel.setLayout(new RowLayout(SWT.HORIZONTAL));
				yoffset_set = new Text(yoffset_panel,SWT.BORDER);
				yoffset_label = new Label(yoffset_panel,SWT.NONE);
				yoffset_label.setText(EditorPlugin.getString("YOFFSET_LABEL"));
			multiplier_panel = new Composite(offset_panel,SWT.NONE);
			multiplier_panel.setLayout(new RowLayout(SWT.HORIZONTAL));
				multiplier_set = new Text(multiplier_panel,SWT.BORDER);
				multiplier_label = new Label(multiplier_panel,SWT.NONE);
				multiplier_label.setText(EditorPlugin.getString("MULTIPLIER_LABEL"));

		button_panel = new Composite(main_panel,SWT.NONE);
		button_panel.setLayoutData(GData.getGridData(true,false,-1,-1,2,1,GridData.FILL,GridData.FILL));
		button_panel.setLayout(new GridLayout(1,true));
		
			Composite bptmp = new Composite(button_panel,0);
			bptmp.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.CENTER,GridData.CENTER));
			bptmp.setLayout(new GridLayout(2,true));
		
			button_ok = new Button(bptmp,SWT.PUSH);
			button_ok.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.FILL,GridData.CENTER));
			button_ok.setText(EditorPlugin.getString("OK"));
			
			button_cancel = new Button(bptmp,SWT.PUSH);
			button_cancel.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.FILL,GridData.CENTER));
			button_cancel.setText(EditorPlugin.getString("CANCEL"));

	}
	
	public Graph getGraph() {
		return graph;
	}
	
	private void readFromGraph() {
		try {
			
			//color
			if (graph != null) {
				color = graph.getForeground().getRGB();
			}
			redoColorImage();
			
			//slider
			//?
			
			//plotting
			int ptype = graph.getPlottingType();
			if (ptype == Graph.PLOTTING_TYPE_AVERAGE) {
				plotting_choice.select(0);
			} else if (ptype == Graph.PLOTTING_TYPE_MAX) {
				plotting_choice.select(1);
			} else if (ptype == Graph.PLOTTING_TYPE_MIN) {
				plotting_choice.select(2);
			} else if (ptype == Graph.PLOTTING_TYPE_SUM) {
				plotting_choice.select(3);
			} else if (ptype == Graph.PLOTTING_TYPE_COUNT) {
				plotting_choice.select(4);
			} else if (ptype == Graph.PLOTTING_TYPE_NEAREST) {
				plotting_choice.select(5);
			} else if (ptype == Graph.PLOTTING_TYPE_MIN_MAX) {
				plotting_choice.select(6);
			} else if (ptype == Graph.PLOTTING_TYPE_MIN_MAX_AVERAGE) {
				plotting_choice.select(7);
			} else if (ptype == Graph.PLOTTING_TYPE_STDDEV) {
				plotting_choice.select(8);
			} else if (ptype == Graph.PLOTTING_TYPE_STDDEV_AVERAGE) {
				plotting_choice.select(9);
			}
			
			//averaging
			period_millis_value.setText(df.format((long)graph.getPlottingPeriodValue()));
			period_pixels_value.setText(df.format((long)graph.getPlottingPeriodValue()));
			period_ticks_value.setText(df.format((long)graph.getPlottingPeriodValue()));
			
			int period_type = graph.getPlottingPeriodType();
			if (period_type == Graph.PERIOD_TYPE_MILLIS) {
				period_millis_set.setSelection(true);
			} else if (period_type == Graph.PERIOD_TYPE_PIXELS) {
				period_pixels_set.setSelection(true);
			} else if (period_type == Graph.PERIOD_TYPE_TICKS) {
				period_ticks_set.setSelection(true);
//			} else if (period_type == Graph.AVERAGING_TYPE_UNAVERAGED) {
//				period_ignored_set.setSelection(true);
			}
			
			//no data behaviour
			int nodata_type = graph.getNoDataBehaviour();
			if (nodata_type == Graph.NODATA_DO_NOTHING) {
				nodata_nothing.setSelection(true);
			} else if (nodata_type == Graph.NODATA_DRAW_PREVIOUS) {
				nodata_drawprevious.setSelection(true);
			} else if (nodata_type == Graph.NODATA_DRAW_ZERO) {
				nodata_drawzero.setSelection(true);
			}
			
			//offsets
			xoffset_set.setText(df.format((long)graph.getXOffset()));
			yoffset_set.setText(df.format((long)graph.getYOffset()));
			multiplier_set.setText(df.format(graph.getStaticScaling()));
		
		} catch (NullPointerException e) {
		} catch (SWTException e) {
		}
	}
	
	private void writeToGraph() throws InvalidDataException {
		try {
			
			//color
			graph.setForeground(new Color(Display.getDefault(),color));
			
			//slider
			//?
			
			//plotting
			int pchoice = plotting_choice.getSelectionIndex();
			int ptype = graph.getPlottingType();
			if (pchoice == 0) {
				ptype = Graph.PLOTTING_TYPE_AVERAGE;
			} else if (pchoice == 1) {
				ptype = Graph.PLOTTING_TYPE_MAX;
			} else if (pchoice == 2) {
				ptype = Graph.PLOTTING_TYPE_MIN;
			} else if (pchoice == 3) {
				ptype = Graph.PLOTTING_TYPE_SUM;
			} else if (pchoice == 4) {
				ptype = Graph.PLOTTING_TYPE_COUNT;
			} else if (pchoice == 5) {
				ptype = Graph.PLOTTING_TYPE_NEAREST;
			} else if (pchoice == 6) {
				ptype = Graph.PLOTTING_TYPE_MIN_MAX;
			} else if (pchoice == 7) {
				ptype = Graph.PLOTTING_TYPE_MIN_MAX_AVERAGE;
			} else if (pchoice == 8) {
				ptype = Graph.PLOTTING_TYPE_STDDEV;
			} else if (pchoice == 9) {
				ptype = Graph.PLOTTING_TYPE_STDDEV_AVERAGE;
			}
			graph.setPlottingType(ptype);
			
			//averaging
			try {
				if (period_millis_set.getSelection()) {
					graph.setPlottingPeriod(Graph.PERIOD_TYPE_MILLIS,Double.parseDouble(period_millis_value.getText()));
				} else if (period_pixels_set.getSelection()) {
					graph.setPlottingPeriod(Graph.PERIOD_TYPE_PIXELS,Double.parseDouble(period_pixels_value.getText()));
				} else if (period_ticks_set.getSelection()) {
					graph.setPlottingPeriod(Graph.PERIOD_TYPE_TICKS,Double.parseDouble(period_ticks_value.getText()));
//				} else if (period_ignored_set.getSelection()) {
//					graph.setAveraging(Graph.AVERAGING_TYPE_UNAVERAGED,1.0);
				}
			} catch (NumberFormatException e) {
				throw new InvalidDataException(EditorPlugin.getString("ERROR_BAD_PERIOD"));
			}
			
			//no data behaviour
			if (nodata_nothing.getSelection()) {
				graph.setNoDataBehaviour(Graph.NODATA_DO_NOTHING);
			} else if (nodata_drawprevious.getSelection()) {
				graph.setNoDataBehaviour(Graph.NODATA_DRAW_PREVIOUS);
			} else if (nodata_drawzero.getSelection()) {
				graph.setNoDataBehaviour(Graph.NODATA_DRAW_ZERO);
			}

			//offsets
			try {
				graph.setXOffset(Double.parseDouble(xoffset_set.getText()));
			} catch (NumberFormatException e) {
				throw new InvalidDataException(EditorPlugin.getString("ERROR_BAD_XOFFSET"));
			}
			try {
				graph.setYOffset(Double.parseDouble(yoffset_set.getText()));
			} catch (NumberFormatException e) {
				throw new InvalidDataException(EditorPlugin.getString("ERROR_BAD_YOFFSET"));
			}
			try {
				graph.setStaticScaling(Double.parseDouble(multiplier_set.getText()));
			} catch (NumberFormatException e) {
				throw new InvalidDataException(EditorPlugin.getString("ERROR_BAD_MULTIPLIER"));
			}
		
		} catch (NullPointerException e) {
		} catch (SWTException e) {
		}
	}
	
	class InvalidDataException extends Exception {
		public InvalidDataException(String s) {
			super(s);
		}
	}
}