/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.model.statistical.*;
import org.eclipse.emf.common.util.*;

/**
 * Could do with using this class in the LineGraph class and then adding caching to this class
 * 
 * When I have cached indexes, rather than using these as set returned values, I should just
 * still perform the search (in case the data has changed) but set the chop fulcrum to be the
 * cached index or something.
 */
public class ObservationSearcher {

/** If there are multiples of this timestamp, return the latest */
public static final int RETURN_LATEST_MULTIPLE = 0;
/** If there are multiples of this timestamp, return the earliest */
public static final int RETURN_EARLIEST_MULTIPLE = 1;
	
private static final boolean CACHE_INDEXES = false;	

EList times;
	
	public ObservationSearcher(SDDiscreteObservation obs) {
		this.times = obs.getCreationTime();
	}
	public ObservationSearcher(SDContiguousObservation obs) {
		this.times = obs.getCreationTime();
	}
	
	public int bchopGetIndex(double t, int multiple_pref) {

		int lower = 0;
		int higher = times.size()-1;

		double t1 = ((Number)times.get(lower)).doubleValue();
		double t2 = ((Number)times.get(higher)).doubleValue();

		if (t >= t2) {
			return times.size()-1;
		} else if (t <= t1) {
			return 0;
		} else {
			return bchopGetIndex(lower,higher,t,multiple_pref);
		}//end if
	}
	
	private int bchopGetIndex(int lower, int higher, double t, int multiple_pref) {
		
		while (true) {
			
			if (higher-lower < 10) {
//				if (true) {
				if (multiple_pref == RETURN_LATEST_MULTIPLE) {
					//return the latest timestamp possible (if there are multiples)
					for (int i = lower; i <= higher; i++) {
						Number T = (Number)times.get(i);
						//find the first value greater than this timestamp
						if (T.doubleValue() > t) {
							//return the index just before that timestamp
							i--;
							if (i < 0) return 0;
							if (i >= times.size()) return times.size()-1;
							
							return i;
						}
					}
					return higher;
				} else {
					//return the earliest timestamp possible (if there are multiples)
					for (int i = lower; i <= higher; i++) {
						Number T = (Number)times.get(i);
						//find the first value greater or equal to this timestamp
						if (T.doubleValue() >= t) {
							//return the index just before that timestamp
							if (T.doubleValue() > t) {
								i--;
							}
							if (i < 0) return 0;
							if (i >= times.size()) return times.size()-1;
							
							return i;
						}
					}
					return lower;
				}
			}
	
			double t1 = ((Number)times.get(lower)).doubleValue();
			double t2 = ((Number)times.get(higher)).doubleValue();
	
//weighted heuristic
			double chop = (t - t1) / (t2 - t1);
			chop = chop * (double)((higher-lower)-2);
			chop = chop + ((double)lower) + 1.0d;

//centre-chop heuristic
//			double chop = lower + ((higher-lower)/2);

//			EditorPlugin.DBG.info("loop "+lower+" "+higher+" "+chop);
			
			double chop_t = ((Number)times.get((int)chop)).doubleValue();
			if (chop_t == t) {
				return (int)chop;
			} else if (chop_t > t) {
				higher = (int)chop;
			} else {
				lower = (int)chop;
			}

		}

//replaced this recursion with a simple loop - faster and more efficient
//		return bchopGetIndex(lower,higher,t);				
	}	
}