/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.statistical.ui.*;
import org.eclipse.swt.widgets.*;

/**
 * This recursive StatCon operation generates the cbe log parts of the statcon configuration file 
 */
public class OpGenerateTreeConfig implements StatConTreeOp {
	public static OpGenerateTreeConfig INSTANCE = new OpGenerateTreeConfig();

	static ImageManager img = EditorPlugin.img;

	public static void launch(StatisticalModelGraphViewer statcon, TreeItem item, TreeItem root, StringBuffer xml, String element, int depth) {
		StatConOpState state = new StatConOpState(new State(depth,xml,element));
		statcon.applyStatConTreeOp( new OpGenerateTreeConfig(), state, item, root);
	}

	public StatConOpState preapply(StatConOpState state, StatisticalModelGraphViewer statcon, TreeItem current, TreeItem root, boolean parents_checked, boolean parents_enabled) {
		State mystate = (State)state.state;
		StringBuffer xml = mystate.xml;
		int depth = mystate.depth;
		String element = mystate.element;

		for (int i = 0; i < depth; i++) {
			xml.append("  ");
		}

		xml.append("<");
		xml.append(element);	
		xml.append(" name=\"").append(current.getText()).append("\"");
		xml.append(" ticked=\"").append(current.getChecked()).append("\"");
		xml.append(" expanded=\"").append(current.getExpanded()).append("\"");
		xml.append(">\n");
		
		return new StatConOpState(new State(depth+1,xml,element));
	}

	public void postapply(StatConOpState state, StatisticalModelGraphViewer statcon, TreeItem current, TreeItem root, boolean parents_checked, boolean parents_enabled) {
		State mystate = (State)state.state;
		StringBuffer xml = mystate.xml;
		int depth = mystate.depth;
		String element = mystate.element;

		for (int i = 0; i < depth; i++) {
			xml.append("  ");
		}

		xml.append("</");
		xml.append(element);	
		xml.append(">\n");
		
	}
	
	static class State {
		public State(int depth, StringBuffer xml, String elementname) {
			this.depth = depth;
			this.xml = xml;
			this.element = elementname;
		}
		int depth = 0;
		StringBuffer xml;
		String element;
	}

}