/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.monitoractions.internal.logfile;

import java.util.Properties;

import org.eclipse.hyades.statistical.ui.widgets.alert.internal.*;
import org.eclipse.hyades.statistical.ui.*;

public class LogFileActionProvider implements StatConAlertActionProvider {
	public static final String PREFS = "STATCON_ACTION_LOGFILE__";
	public static final String PATH = "path";
	
	public String getName() {
		return EditorPlugin.getString("ALERT_ACTION_NAME_LOGFILE");
	}
	public AlertAction newAlertAction() {
		return new LogFileAlertAction();
	}
	public AlertAction fromProperties(Properties props) {
		LogFileAlertAction a = new LogFileAlertAction();
		a.path = props.getProperty(PREFS+PATH);
		return a;
	}
	public void toProperties(Properties props, AlertAction action) {
		LogFileAlertAction a = (LogFileAlertAction)action;
		props.setProperty(PREFS+PATH,a.path);
	}
}

