/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.alert.internal;

import org.eclipse.swt.widgets.*;
import org.eclipse.hyades.statistical.ui.editor.internal.*;

public abstract class AlertActionControl extends Composite {
	
	public AlertActionControl(Composite c, int x) {
		super(c,x);
	}
	
	public abstract void readFromAction(AlertAction action);
	
	public abstract void writeToAction(AlertAction action) throws InvalidDataException;
	public abstract AlertAction writeToClonedAction() throws InvalidDataException;
	public abstract AlertAction writeToOriginalAction() throws InvalidDataException;
	public abstract String getDescription();
	
	public String toString() {
		return getDescription();
	}
}