package org.eclipse.hyades.logging.events.cbe;

import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryImpl;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Factory for <code>EventFactory</code> instances.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 */
final public class EventFactoryFactory {

    /**
     * <p>
     * Creates a simple <code>EventFactory</code> object.
     * </p>
     * 
     * @return               the created instance.
     */
    public static EventFactory createEventFactory() {
        return new EventFactoryImpl();
    }

    /**
     * <p>
     * Creates an <code>EventFactory</code> object associated with a
     * <code>ContentHandler</code>.
     * </p>
     * 
     * @param handler        handler to be associated with the factory.
     * 
     * @return               the created instance.
     */
	public static EventFactory createEventFactory(ContentHandler handler) {
        EventFactoryImpl result = new EventFactoryImpl();
        result.setContentHandler(handler);
        return result;
    }

    /*
     * Private methods.
     */

    /**
     * Private constructor to prevent instantiation of this class.
     */
    private EventFactoryFactory() {
    }
}
