package org.eclipse.hyades.logging.events.cbe.impl.tests;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Mock EMF Adapter for testing the notification mechanism in all CBE-EMF
 * classes.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1 
 */
public class MockEmfAdapter implements Adapter {

    /**
     * EMF Object to be notified about changes.
     */
    private Notifier target;

    /**
     * Last notification handled by this adapter.
     */
    private Notification lastNotification;

    /**
     * 
     */
    public MockEmfAdapter() {
        super();
    }

    /**
     * Constructor with a target.
     */
    public MockEmfAdapter(Notifier arg0) {
        super();
        target = arg0;
    }

    /* (non-Javadoc)
     * @see org.eclipse.emf.common.notify.Adapter#getTarget()
     */
    public Notifier getTarget() {
        return target;
    }

    /* (non-Javadoc)
     * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
     */
    public boolean isAdapterForType(Object arg0) {
        if (arg0 instanceof Notifier) {
            return true;
        }
        return false;
    }

    /* (non-Javadoc)
     * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
     */
    public void notifyChanged(Notification arg0) {
        lastNotification = arg0;
    }

    /* (non-Javadoc)
     * @see org.eclipse.emf.common.notify.Adapter#setTarget(org.eclipse.emf.common.notify.Notifier)
     */
    public void setTarget(Notifier arg0) {
        target = arg0;
    }

    public Notification getLastNotification() {
        return lastNotification;
    }

}
