package org.eclipse.hyades.logging.events.cbe.tests;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.EventException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 *
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 */
public class EventExceptionTest extends TestCase {
    /**
     * Constructor for EventExceptionTest.
     * @param arg0
     */
    public EventExceptionTest(String arg0) {
        super(arg0);
    }

    /*
     * Test for void EventException()
     */
    public void testEventException() {
        new EventException();
    }

    /*
     * Test for void EventException(String)
     */
    public void testEventExceptionString() {
        String msg = "test";
        EventException e = new EventException(msg);
        assertEquals(msg, e.getMessage());
    }

    /*
     * Test for void EventException(String, String)
     */
    public void testEventExceptionStringString() {
        
        EventException e = new EventException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_"));

        assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", null);
    }

    /*
     * Test for void EventException(String, String, Object[])
     */
    public void testEventExceptionStringStringObjectArray() {

        EventException e = new EventException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_", "a"));

        assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", new Object[] { "a" });
    }

    /*
     * Test for void EventException(String, String, Object[], Throwable)
     */
    public void testEventExceptionStringStringObjectArrayThrowable() {

        Exception linkedException = new Exception();

        EventException e = new EventException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_","a" ), linkedException);
        
        assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", new Object[] { "a" });
        
        assertEquals(linkedException, e.getCause());
    }

    /*
     * Package methods.
     */

    /**
     * Verifies whether the exception contains a message that matches the
     * resource key in the event resource bundle.
     */
    static void assertExceptionMsg(EventException e, String msgKey, Object[] params) {
        assertEquals(EventHelpers.getString(msgKey,params), e.getLocalizedMessage());
    }
}
