package org.eclipse.hyades.ui.sample.svg.generator;
/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

/**
 * Representation of a Data Range
 * 
 * @version 1.7
 */
public class DataRange {
    /**
     *  Location type constant: UNKNOWN
     */
    public static final int UNKNOWN = 0;

    /**
     *  Location type constant: BOTTOM
     */
    public static final int BOTTOM = 1;

    /**
     *  Location type constant: LEFT
     */
    public static final int LEFT = 2;
    
    /**
     *  Location type constant: TOP
     */
    public static final int TOP = 3;
    
    /**
     *  Location type constant: RIGHT
     */
    public static final int RIGHT = 4;
    
    
    /**
     *  Data range type constant: CONTINUUM
     */
    public static final int CONTINUUM=0;
    
    /**
     *  Data range type constant: CATEGORIZATION
     */
    public static final int CATEGORIZATION=1;
    


    private String id = null;
    private String label = null;
    private double minValue = 0.0;
    private double maxValue = 0.0;
    private int location = UNKNOWN;
    private int type = CONTINUUM;
    private SegmentMarker[] segmentMarkers= null;
    

    /**
     *  Constructor
     * @param locationString one of "S", "W", "N", "E" representing bottom, left, top, right side of the chart where this data range applies
     */        
    public DataRange(String locationString) {
        if (locationString != null) {
            int location = UNKNOWN;
            if (locationString.equals("S")) {
                location = BOTTOM;
            }
            else if (locationString.equals("W")) {
                location = LEFT;
            }
            else if (locationString.equals("N")) {
                location = TOP;
            }
            else if (locationString.equals("E")) {
                location = RIGHT;
            }
            setLocation(location);
        }
    }
    
    /**
     *  Getter for Type
     */
    public int getType() { return type; }
    /**
     *  Setter for Type
     */
    public void setType(int type) { 
        this.type = type; 
    }



    /**
     *  Getter for Location
     */
    public int getLocation() { return location; }
    /**
     *  Setter for Location
     */
    public void setLocation(int location) { this.location = location; }
    
    /**
     *  Getter for id
     */
    public String getId() { return id; }
    /**
     *  Setter for id
     */
    public void setId(String id) { this.id = id; }

    /**
     *  Getter for Label
     */
    public String getLabel() { return label; }
    /**
     *  Setter for Label
     */
    public void setLabel(String label) { this.label = label; }

    /**
     *  Getter for Segment Markers
     */
    public SegmentMarker[] getSegmentMarkers() { return segmentMarkers; }
    /**
     *  Setter for Segment Markers
     */
    public void setSegmentMarkers(SegmentMarker[] segmentMarkers) { 
    	this.segmentMarkers = segmentMarkers;
    	if (segmentMarkers.length <= 0) {
    		return;
    	}

        minValue = segmentMarkers[0].getValue();
        maxValue = minValue;
        for(int i=1; i < segmentMarkers.length; i++) {
        	double d = segmentMarkers[i].getValue();
        	if (d < minValue) { minValue = d; }
        	if (d > maxValue) { maxValue = d; }
        }
    }


    /**
     *  Returns the minimum value of the data in the data range derived from the segment markers it contains. 
     *  The result is only valid after the setSegmentMarkers() method has been called with a proper set of
     *  segment markers.
     */
    public double getMinValue() { return minValue; }

    /**
     *  Returns the maximum value of the data in the data range derived from the segment markers it contains. 
     *  The result is only valid after the setSegmentMarkers() method has been called with a proper set of
     *  segment markers.
     */
    public double getMaxValue() { return maxValue; }

	/**
	 *  Return the segment marker with the given value string
	 *  @param value the value to match
	 *  @return SegmentMarker the segment marker with the given value. Returns null if none found.
	 */
	public SegmentMarker findSegmentMarker(double value) {
		for(int i=0; i < segmentMarkers.length; i++) {
			if (segmentMarkers[i].getValue() == value) {
				return segmentMarkers[i];
			}
		}
		return null;
	}
}
