/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.linux.internal;

import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.utils.internal.SetVariableCommand;
import org.eclipse.hyades.perfmon.common.internal.*;

import org.eclipse.hyades.statistical.ui.editor.internal.*;
import org.eclipse.emf.common.util.URI;


public class LinuxModuleTrace extends CommonModuleTrace {

	String reg_host_name = null;
	
	public LinuxModuleTrace(StatConInterface statcon, String rac_host, URI smodelpath, URI monitor_uri) {
		super();
		
		//create the initial commands to pass to our agent
		SetVariableCommand[] reg_commands = new SetVariableCommand[] {
		};
		
		init(	statcon,
				rac_host,
				"LinuxAgent",
				LinuxConstants.AGENT_PREFIX,
				" ("+rac_host+")",
				PerfmonPlugin.getString("LINUX_AGENT"),
				reg_commands,
				smodelpath,
				monitor_uri
				);
		
		//
		// we can register any specialist actions here
		//
	}
}