/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.perfmon.utils.internal;

import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.perfmon.PerfmonPlugin;

import org.eclipse.hyades.statistical.ui.editor.internal.*;

import java.util.*;

public class AgentUpdater extends Thread implements StatisticalLoaderListener {
	public boolean die;
	TRCAgent agent;
	StatConInterface statcon;
	
	Object list_lock = new Object();
	ArrayList descriptor_updates = new ArrayList();
	Map descriptor_map = Collections.synchronizedMap(new HashMap(300,0.6f));
	ArrayList agent_updates = new ArrayList();
	
	public void shutdown() {
		die = true;
	}
	
	public AgentUpdater(StatConInterface statcon, TRCAgent trcagent, DCAgentGenericLoader loader) {
		this.agent = trcagent;
		this.statcon = statcon;
		setDaemon(true);
		loader.addLoaderListener(this);
		start();
		
		//update the whole agent at the beginning
		modelChanged(null);
	}
	public void modelChanged(SDDescriptor des) {
		SDDescriptor parent = des;
		synchronized(list_lock) {

			if (parent == null) {
				if (agent_updates.size() == 0) {
					agent_updates.add(agent);
				}
			} else {
				
				if (descriptor_map.get(parent) != null) {
					return;	
				}
				
				SDDescriptor tmp = parent.getParent();
				while (tmp != null) {
					if (descriptor_map.get(tmp) != null) {
						//its parent is there - no need to update it
						return;
					}
					tmp = tmp.getParent();
				}
				
				descriptor_updates.add(parent);
				descriptor_map.put(parent,parent);
			}

		}
	}
	
	private void collapse() {
		synchronized(list_lock) {
			
			if (agent_updates.size() > 0) {
				return;	
			}
			
			//lots of changes - might as well update the whole tree
			if (descriptor_updates.size() > 350) {
				agent_updates.add(agent);
				return;
			}

			for (int i = 0; i < descriptor_updates.size(); i++) {
				SDDescriptor descriptor = (SDDescriptor)descriptor_updates.get(i);

				SDDescriptor tmp = descriptor.getParent();
				while (tmp != null) {
					if (descriptor_map.get(tmp) != null) {
						//its parent is there - no need to update it
						descriptor_updates.remove(i--);
						descriptor_map.remove(tmp);
						break;
					}
					tmp = tmp.getParent();
				}
			}	

		}
	}
	
	public void run() {
		while (!die) {
			try {
				Thread.sleep(300);	
			} catch (Exception e) {
			}

			synchronized(list_lock) {

				collapse();

				//if we are updating the agent, dont bother with its models
				if (agent_updates.size() > 0) {
					statcon.getGraphWindow().getDisplay().syncExec(new ListUpdate(agent_updates));

				//update bits of the agent's models
				} else if (descriptor_updates.size() > 0) {
					statcon.getGraphWindow().getDisplay().syncExec(new ListUpdate(descriptor_updates));
				}
				descriptor_updates = new ArrayList();
				descriptor_map = new HashMap();
				agent_updates = new ArrayList();
				
			}	
		}	
	}	
	
	
	class ListUpdate extends Thread {
		ArrayList items;
		public ListUpdate(ArrayList items) {
			this.items = items;
		}
		public void run() {
			try {
				for (int i = 0; i < items.size(); i++) {
					Object o = items.get(i);
					if (o instanceof SDDescriptor) {
						statcon.updateModel((SDDescriptor)o);
					} else if (o instanceof TRCAgent) {
						statcon.updateAgent((TRCAgent)o);
						//we exit here because updating the agent updates everything
						return;
					}
				}
				
			} catch (Throwable t) {
				PerfmonPlugin.DBG.warning("couldnt update perfmon agent "+t);	
			}	
		}	
	}
	
}

