/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.utils.internal;

import java.io.IOException;
import java.util.List;

import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.perfmon.ImageManager;

import org.eclipse.hyades.statistical.ui.editor.internal.*;
import org.eclipse.hyades.perfmon.*;

import org.eclipse.swt.graphics.*;

public class StatConImageApplier {
	
	public static Image getStandardTracingImage() {
		return PerfmonPlugin.img.getImage(ImageManager.IMG_PERFMON_START);
	}
	public static Image getStandardStoppedImage() {
		return PerfmonPlugin.img.getImage(ImageManager.IMG_PERFMON_STOP);
	}
	
	public static void apply(StatConInterface statcon, SDDescriptor descriptor, Image image) throws IOException {
		statcon.setDescriptorImage(descriptor,image);
	}
	public static void applyUp(StatConInterface statcon, SDDescriptor descriptor, Image image) throws IOException {
		SDDescriptor parent = descriptor.getParent();
		if (parent != null) {
			apply(statcon,parent,image);
			applyUp(statcon,parent,image);					
		}	
	}
	public static void applyDown(StatConInterface statcon, SDDescriptor descriptor, Image image) throws IOException {
		apply(statcon,descriptor,image);
		List children = descriptor.getChildren();
		for (int i = 0; i < children.size(); i++) {
			applyDown(statcon,(SDDescriptor)children.get(i),image);
		}
	}
	public static void applyBoth(StatConInterface statcon, SDDescriptor descriptor, Image image) throws IOException {
		applyUp(statcon,descriptor,image);
		applyDown(statcon,descriptor,image);
	}
}