/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.execution.core;

import org.eclipse.core.runtime.IProgressMonitor;

/**
 * A subinterface of executor that adds progress support through overloading the
 * superinterface's launch and kill methods. Concrete class should implement
 * this interface instead of the base executor interface if progress tracking
 * and the ability to cancel a launch or kill of an executor is desired.
 * 
 * @author Scott E. Schneider
 */
public interface IExecutorWithProgressMonitorSupport
	extends IExecutor {

	/**
	 * Launch using the given progress monitor, this progress monitor will be
	 * used for progress reports as work units are complete and for polling the
	 * cancel status of the monitor.
	 * 
	 * @param progressMonitor
	 */
	public void launch(IProgressMonitor progressMonitor);

	/**
	 * Kill using the given progress monitor, this progress monitor will be used
	 * for progress reports as work units are complete and for polling the
	 * cancel status of the monitor.
	 * 
	 * @param progressMonitor
	 */
	public void kill(IProgressMonitor progressMonitor);

}