/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions.widgets;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDGraphNodeSupporter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

/**
 * Here are the controls that allows to create or update a find or filter Criteria.
 */
public class TabContents extends Composite {
	
	private class GraphNodeTypeListener implements SelectionListener {
		/**
		 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
		 */
		public void widgetDefaultSelected(SelectionEvent e) {
			// Nothing to do
		}
		/**
		 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
		 */
		public void widgetSelected(SelectionEvent e) {
			updateOkButton();
		}

	}
	
	private class ExpressionListener implements ModifyListener {
		/**
		 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
		 */
		public void modifyText(ModifyEvent e) {
			//System.err.println("modifyText: "+e.getSource());
			updateOkButton();
		}
	}
	
	GraphNodeTypeListener graphNodeTypeListener = null;
	ExpressionListener expressionListener = null;
	
	Button lifelineButton = null;
	Button stopButton = null;
	Button synMessageButton = null;
	Button synMessageReturnButton = null;
	Button asynMessageButton = null;
	Button asynMessageReturnButton = null;
	
	Combo searchText = null;
	Group kindSelection = null;
	Button caseSensitive = null;
	
	Label result = null;
	
	Button parentOkButton = null;
	
	/**
	 * Creates the dialog contents
	 * @param parent the parent widget
	 * @param provider the provider which handle the action
	 * @param okButton of the dialog (to be enabled/disabled)
	 * @param expressionList list of strings already searched for
	 */
	/**
	 */
	public TabContents(Composite parent, ISDGraphNodeSupporter provider, Button okButton, String[] expressionList)
	{
		super(parent,SWT.NONE);
		setOkButton(okButton);
		setLayout( new GridLayout());
		
		graphNodeTypeListener = new GraphNodeTypeListener();
		expressionListener = new ExpressionListener();
		
		//Inform the user how to fill the string to search
		Label searchTitle = new Label(this,SWT.LEFT);
		searchTitle.setText(SDViewerPlugin.getResourceString("FIND_FILTER_INPUT_HELP")); //$NON-NLS-1$
		Composite searchPart = new Composite(this,SWT.NONE);
		GridData searchPartData =new GridData(GridData.HORIZONTAL_ALIGN_FILL|
		GridData.VERTICAL_ALIGN_FILL);
		GridLayout searchPartLayout = new GridLayout();
		searchPartLayout.numColumns = 2;
		searchPart.setLayout(searchPartLayout);
		searchPart.setLayoutData(searchPartData);
		
		//Create the user string input area
		searchText = new Combo(searchPart,SWT.DROP_DOWN);
		GridData comboData = new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL|GridData.GRAB_VERTICAL|
											GridData.VERTICAL_ALIGN_FILL);
		/*GridData tabLayoutData2 = new GridData(GridData.HORIZONTAL_ALIGN_FILL|
													GridData.VERTICAL_ALIGN_FILL);*/
		searchText.setLayoutData(comboData);
		if (expressionList != null) {
			for (int i = 0; i < expressionList.length; i++) {
				searchText.add(expressionList[i]);
			}
		}
		searchText.addModifyListener(expressionListener);
		
		//Create the case sensitive check button
		caseSensitive=new Button(searchPart,SWT.CHECK);
		caseSensitive.setText(SDViewerPlugin.getResourceString("FIND_FILTER_CASE_SENSITIVE")); //$NON-NLS-1$
			
		//Create the group for searched graph node kind selection										
		kindSelection = new Group(this,SWT.SHADOW_NONE);
		kindSelection.setText(SDViewerPlugin.getResourceString("FIND_FILTER_GROUP_NAME")); //$NON-NLS-1$
//		kindSelection.setLayoutData(tabLayoutData2);
		GridLayout kindSelectionLayout = new GridLayout();
		kindSelectionLayout.numColumns = 2;
		kindSelection.setLayout(kindSelectionLayout);
		GridData kindSelectionData = new GridData(GridData.HORIZONTAL_ALIGN_FILL|GridData.GRAB_HORIZONTAL|
										GridData.VERTICAL_ALIGN_FILL);
		kindSelection.setLayoutData(kindSelectionData);
		
		//Create the lifeline check button
		lifelineButton=new Button(kindSelection,SWT.CHECK);
		lifelineButton.setText(SDViewerPlugin.getResourceString("FIND_FILTER_LIFELINE")); //$NON-NLS-1$
		//enablement depends on search provider supported searchable graph node kind
		if (provider != null && provider.isLifelineSupported())
			lifelineButton.setEnabled(true);
		else lifelineButton.setEnabled(false);
		lifelineButton.addSelectionListener(graphNodeTypeListener);
	
		//Create the stop check button
		stopButton=new Button(kindSelection,SWT.CHECK);
		stopButton.setText(SDViewerPlugin.getResourceString("FIND_FILTER_STOP")); //$NON-NLS-1$
		//enablement depends on search provider supported searchable graph node kind
		if (provider != null && provider.isStopSupported())
			stopButton.setEnabled(true);
		else stopButton.setEnabled(false);
		stopButton.addSelectionListener(graphNodeTypeListener);
		
		//Create the synchronous message check button
		synMessageButton=new Button(kindSelection,SWT.CHECK);
		synMessageButton.setText(SDViewerPlugin.getResourceString("FIND_FILTER_SYNC_MESS")); //$NON-NLS-1$
		//enablement depends on search provider supported searchable graph node kind
		if (provider != null && provider.isSyncMessageSupported())
			synMessageButton.setEnabled(true);
		else synMessageButton.setEnabled(false);
		synMessageButton.addSelectionListener(graphNodeTypeListener);
		
		//Create the synchronous message return check button
		synMessageReturnButton=new Button(kindSelection,SWT.CHECK);
		synMessageReturnButton.setText(SDViewerPlugin.getResourceString("FIND_FILTER_SYNC_MESS_RET")); //$NON-NLS-1$
		//enablement depends on search provider supported searchable graph node kind
		if (provider != null && provider.isSyncMessageReturnSupported())
			synMessageReturnButton.setEnabled(true);
		else synMessageReturnButton.setEnabled(false);
		synMessageReturnButton.addSelectionListener(graphNodeTypeListener);
		
		//Create the asynchronous message check button
		asynMessageButton=new Button(kindSelection,SWT.CHECK);
		asynMessageButton.setText(SDViewerPlugin.getResourceString("FIND_FILTER_ASYNC_MESS")); //$NON-NLS-1$
		//enablement depends on search provider supported searchable graph node kind
		if (provider != null && provider.isAsyncMessageSupported())
			asynMessageButton.setEnabled(true);
		else asynMessageButton.setEnabled(false);
		asynMessageButton.addSelectionListener(graphNodeTypeListener);
		
		//Create the asynchronous message return check button
		asynMessageReturnButton=new Button(kindSelection,SWT.CHECK);
		asynMessageReturnButton.setText(SDViewerPlugin.getResourceString("FIND_FILTER_ASYNC_MESS_RET")); //$NON-NLS-1$
		//enablement depends on search provider supported searchable graph node kind
		if (provider != null && provider.isAsyncMessageReturnSupported())
			asynMessageReturnButton.setEnabled(true);
		else asynMessageReturnButton.setEnabled(false);
		asynMessageReturnButton.addSelectionListener(graphNodeTypeListener);

		result = new Label(this,SWT.LEFT);
		result.setText(SDViewerPlugin.getResourceString("SEARCH_NOTHING_FOUND")); //$NON-NLS-1$
		result.setVisible(false);
	}
	
	/**
	 * @param t
	 */
	public void setResult(boolean found) {
		result.setVisible(!found);
	}
	
	/**
	 * 
	 */
	public void updateOkButton() {
		if (parentOkButton == null) {
			return;
		}
		boolean enabled = (searchText.getText() != null && !searchText.getText().equals("")) && //$NON-NLS-1$
						  (lifelineButton.getSelection() ||
						   stopButton.getSelection() ||
						   synMessageButton.getSelection() ||
						   synMessageReturnButton.getSelection() ||
						   asynMessageButton.getSelection() ||
						   asynMessageReturnButton.getSelection());
		parentOkButton.setEnabled(enabled);
	}

	/**
	 * @param okButton
	 * @todo Generated comment
	 */
	public void setOkButton(Button okButton) {
		parentOkButton = okButton;
	}

	/**
	 * Returns the asynchronous message check button state
	 * @return true if check, false otherwise
	 */
	public boolean getAsynMessageButtonSelection() {
		return asynMessageButton.getSelection();
	}

	/**
	 * Returns the asynchronous message return check button state
	 * @return true if check, false otherwise
	 */
	public boolean getAsynMessageReturnButtonSelection() {
		return asynMessageReturnButton.getSelection();
	}

	/**
	 * Returns the case sensitive check button state
	 * @return true if check, false otherwise
	 */
	public boolean getCaseSensitiveSelection() {
		return caseSensitive.getSelection();
	}

	/**
	 * Returns the lifeline check button state
	 * @return true if check, false otherwise
	 */
	public boolean getLifelineButtonSelection() {
		return lifelineButton.getSelection();
	}

	/**
	 * Returns the user input string
	 * @return the string to search for
	 */
	public String getSearchText() {
		return searchText.getText();
	}

	/**
	 * Returns the stop check button state
	 * @return true if check, false otherwise
	 */
	public boolean getStopButtonSelection() {
		return stopButton.getSelection();
	}

	/**
	 * Returns the synchronous message check button state
	 * @return true if check, false otherwise
	 */
	public boolean getSynMessageButtonSelection() {
		return synMessageButton.getSelection();
	}

	/**
	 * Returns the synchronous message return check button state
	 * @return true if check, false otherwise
	 */
	public boolean getSynMessageReturnButtonSelection() {
		return synMessageReturnButton.getSelection();
	}

	/**
	 * Set the asynchronous message check button state
	 */
	public void setAsynMessageButtonSelection(boolean state) {
		asynMessageButton.setSelection(state);
	}

	/**
	 * Set the asynchronous message return check button state
	 */
	public void setAsynMessageReturnButtonSelection(boolean state) {
		asynMessageReturnButton.setSelection(state);
	}

	/**
	 * Set the case sensitive check button state
	 */
	public void setCaseSensitiveSelection(boolean state) {
		caseSensitive.setSelection(state);
	}

	/**
	 * Set the lifeline check button state
	 */
	public void setLifelineButtonSelection(boolean state) {
		lifelineButton.setSelection(state);
	}

	/**
	 * Set the user input string
	 */
	public void setSearchText(String text) {
		searchText.setText(text);
	}

	/**
	 * Set the stop check button state
	 */
	public void setStopButtonSelection(boolean state) {
		stopButton.setSelection(state);
	}

	/**
	 * Set the synchronous message check button state
	 */
	public void setSynMessageButtonSelection(boolean state) {
		synMessageButton.setSelection(state);
	}

	/**
	 * Set the synchronous message return check button state
	 */
	public void setSynMessageReturnButtonSelection(boolean state) {
		synMessageReturnButton.setSelection(state);
	}
	
}
