/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.execution.runtime.datapool;

/**
 * Each {@link IDatapoolCell cell} in a {@link IDatapoolRecord record} has a 
 * unique variable association.  Logically a variable is the equivalent of a 
 * column in a datapool display.  Associated with each variable is a
 * {@link IDatapoolSuggestedType suggested type} that may be used by a datapool
 * editor to improve display and editing of individual cells.  The role may also
 * be used by an editor to control the type of data allowed in a particular
 * column in the display.
 * 
 * @see	IDatapool
 */
public interface IDatapoolVariable extends INamedElement
{
	
	/**
	 * The {@link IDatapoolSuggestedType suggested type} of the data associated
	 * with this variable.  As implied by the name there is no enforcement of
	 * the type of data in any cell of the datapool.  However, an editor could 
	 * take advantage of the type information to improve display and editing of
	 * cells within the display.
	 * 
	 * @return	The {@link IDatapoolSuggestedType suggested type} associated with
	 *			this variable.
	 */
	public IDatapoolSuggestedType getSuggestedType();
	
	/**
	 */
	public static final int ROLE_UNSPECIFIED = 0;
	/**
	 */
	public static final int ROLE_INPUT_DATA = 1;
	/**
	 */
	public static final int ROLE_OUTPUT_DATA = 2;
	/**
	 */
	public static final int ROLE_INPUT_OUTPUT_DATA = 3; // INPUT+OUTPUT
	/**
	 */
	public static final int ROLE_VERIFICATION_DATA = 4;
	
	/**
	 * Accesor for the role associated with a variable.  The role may be
	 * used by an editor to control the type of data that may be applied to 
	 * an individual cell with a datapool.
	 * 
	 * @return The role associated with a variable.
	 * 
	 * @see	#ROLE_UNSPECIFIED
	 * @see	#ROLE_INPUT_DATA
	 * @see	#ROLE_OUTPUT_DATA
	 * @see	#ROLE_INPUT_OUTPUT_DATA
	 * @see	#ROLE_VERIFICATION_DATA
	 */
	public int getRoleAsInt();
	
}
