/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.Stack;

import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.uml2sd.trace.loaders.*;


/**
 * Thread call stack information is kept up to date here during Trace Interaction build.
 */
public class TraceCallStack {
	
	private final BaseTraceInteractions interactions;
	
	private TRCThread eThread;
	private Stack callStack;
	
	/**
	 * @param interactions
	 * @param eThread
	 */
	public TraceCallStack(BaseTraceInteractions interactions_, TRCThread eThread) {
		setEThread(eThread);
		interactions = interactions_;
		callStack = new Stack();
	}
	
	/**
	 * @param eThread
	 */
	public void setEThread(TRCThread eThread) {
		this.eThread = eThread;
	}
	
	/**
	 * @return
	 */
	public TRCThread getEThread() {
		return eThread;
	}
	
	/**
	 * @param methodInvocation
	 */
	public void pushCall(TraceSyncMessage syncMessage, TRCFullMethodInvocation methodInvocation) {
		callStack.push(new TraceMessageAndCallAssociation(syncMessage, methodInvocation));
		interactions.sortTraceThreadList(this);
	}
	
	/**
	 * @return
	 */
	public TraceMessageAndCallAssociation popCall() {
		if (callStack.size() == 0) {
			return null;
		}
		TraceMessageAndCallAssociation ret = (TraceMessageAndCallAssociation)callStack.pop();
		this.interactions.sortTraceThreadList(this);
		return ret;
	}
	
	/**
	 * @return
	 */
	public TraceMessageAndCallAssociation getCurrentCall() {
		if (callStack.size() > 0) {
			return (TraceMessageAndCallAssociation)callStack.lastElement();
		}
		return null;
	}
	
	/**
	 * @return
	 */
	public double getCurrentExitTime() {
		if (callStack.size() > 0) {
			double ret = TraceInteractionUtils.getAbsoluteExitTime(getCurrentCall().getMethodInvocation());
			if (ret > 0.0) {
				return ret;
			} else {
				return Double.MAX_VALUE / 10;
			}
		}
		return Double.MAX_VALUE;
	}

	/**
	 * @return
	 */
	public long getCurrentTicket() {
		if (callStack.size() > 0) {
			return getCurrentCall().getMethodInvocation().getTicket();
		}
		return Long.MAX_VALUE;
	}
}