/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;

import java.util.Iterator;


/**
 * @author slavescu
 *
 */
public class XMLruntimeShutdownLoader extends TraceXMLFragmentLoader {
    //~ Methods ------------------------------------------------------------------------------------

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext(org.eclipse.hyades.loaders.util.HierarchyContext)
     */
    public void addYourselfInContext() {
        TRCProcess p = getProcess();

        p.setStopTime(createDeltaTime());

        for (Iterator iter = p.getThreads().iterator(); iter.hasNext();) {
            TRCThread thread = (TRCThread) iter.next();

            if (thread.getStopTime() == 0) {
                thread.setStopTime(createDeltaTime());
            }
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
     */
    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
    }
}
