/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.loaders.trace.ISnapshot;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.impl.AbstractTRCProcessImpl;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCClassLoader;
import org.eclipse.hyades.models.trace.TRCCollectionBoundary;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCInputOutputContainer;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Process</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getPid <em>Pid</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getStartTime <em>Start Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getStopTime <em>Stop Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getLastEventTime <em>Last Event Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getInitFinishedTime <em>Init Finished Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getBaseTime <em>Base Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getCumulativeTime <em>Cumulative Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getCalls <em>Calls</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getInheritedCalls <em>Inherited Calls</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getInheritedBaseTime <em>Inherited Base Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getInheritedCumulativeTime <em>Inherited Cumulative Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getTotalSize <em>Total Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getTotalInstances <em>Total Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getCollectedSize <em>Collected Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getCollectedInstances <em>Collected Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getReferencePointerSize <em>Reference Pointer Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getThreadStates <em>Thread States</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getThreads <em>Threads</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getPackages <em>Packages</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getClassClass <em>Class Class</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getCollectionBoundaryPoints <em>Collection Boundary Points</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getClassLoaders <em>Class Loaders</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getSourceInfos <em>Source Infos</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getObjects <em>Objects</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getHeapDumps <em>Heap Dumps</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getInvocations <em>Invocations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCProcessImpl#getInputOutputContainer <em>Input Output Container</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCProcessImpl extends AbstractTRCProcessImpl implements TRCProcess {
	private TRCProcessSnapshot _currentSnapshot;
	private TRCProcessSnapshot _previousSnapshot;
	/**
	 *
	 */
	public int computeDelta(IDelta delta) {
		TRCProcessSnapshot delta1 = (TRCProcessSnapshot) delta;
	
		if ((_currentSnapshot == null) || (_previousSnapshot == null)) {
			delta1.baseTime = 0;
			delta1.calls = 0;
			delta1.collectedInstances = 0;
			delta1.collectedSize = 0;
			delta1.cumulativeTime = 0;
			delta1.inheritedBaseTime = 0;
			delta1.inheritedCalls = 0;
			delta1.inheritedCumulativeTime = 0;
			delta1.totalInstances = 0;
			delta1.totalSize = 0;
	
			return -1;
		}
	
		delta1.baseTime = _currentSnapshot.baseTime - _previousSnapshot.baseTime;
		delta1.calls = _currentSnapshot.calls - _previousSnapshot.calls;
		delta1.collectedInstances =
			_currentSnapshot.collectedInstances
				- _previousSnapshot.collectedInstances;
		delta1.collectedSize =
			_currentSnapshot.collectedSize - _previousSnapshot.collectedSize;
		delta1.cumulativeTime =
			_currentSnapshot.cumulativeTime - _previousSnapshot.cumulativeTime;
		delta1.inheritedBaseTime =
			_currentSnapshot.inheritedBaseTime
				- _previousSnapshot.inheritedBaseTime;
		delta1.inheritedCalls =
			_currentSnapshot.inheritedCalls - _previousSnapshot.inheritedCalls;
		delta1.inheritedCumulativeTime =
			_currentSnapshot.inheritedCumulativeTime
				- _previousSnapshot.inheritedCumulativeTime;
		delta1.totalInstances =
			_currentSnapshot.totalInstances - _previousSnapshot.totalInstances;
		delta1.totalSize =
			_currentSnapshot.totalSize - _previousSnapshot.totalSize;
	
		return 1;
	}
	public int computeDelta(IDelta delta, int featureID) {
		TRCProcessSnapshot delta1 = (TRCProcessSnapshot) delta;
	
		if ((_currentSnapshot == null) || (_previousSnapshot == null)) {
			switch (featureID) {
				case TracePackage.TRC_PROCESS__BASE_TIME :
					delta1.baseTime = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__CUMULATIVE_TIME :
					delta1.cumulativeTime = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__CALLS :
					delta1.calls = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__INHERITED_CALLS :
					delta1.inheritedCalls = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__INHERITED_BASE_TIME :
					delta1.inheritedBaseTime = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__INHERITED_CUMULATIVE_TIME :
					delta1.inheritedCumulativeTime = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__TOTAL_SIZE :
					delta1.totalSize = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__TOTAL_INSTANCES :
					delta1.totalInstances = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__COLLECTED_SIZE :
					delta1.collectedSize = 0;
	
					break;
	
				case TracePackage.TRC_PROCESS__COLLECTED_INSTANCES :
					delta1.collectedInstances = 0;
	
					break;
			}
	
			return -1;
		}
	
		switch (featureID) {
			case TracePackage.TRC_PROCESS__BASE_TIME :
				delta1.baseTime =
					_currentSnapshot.baseTime - _previousSnapshot.baseTime;
	
				break;
	
			case TracePackage.TRC_PROCESS__CUMULATIVE_TIME :
				delta1.cumulativeTime =
					_currentSnapshot.cumulativeTime
						- _previousSnapshot.cumulativeTime;
	
				break;
	
			case TracePackage.TRC_PROCESS__CALLS :
				delta1.calls = _currentSnapshot.calls - _previousSnapshot.calls;
	
				break;
	
			case TracePackage.TRC_PROCESS__INHERITED_CALLS :
				delta1.inheritedCalls =
					_currentSnapshot.inheritedCalls
						- _previousSnapshot.inheritedCalls;
	
				break;
	
			case TracePackage.TRC_PROCESS__INHERITED_BASE_TIME :
				delta1.inheritedBaseTime =
					_currentSnapshot.inheritedBaseTime
						- _previousSnapshot.inheritedBaseTime;
	
				break;
	
			case TracePackage.TRC_PROCESS__INHERITED_CUMULATIVE_TIME :
				delta1.inheritedCumulativeTime =
					_currentSnapshot.inheritedCumulativeTime
						- _previousSnapshot.inheritedCumulativeTime;
	
				break;
	
			case TracePackage.TRC_PROCESS__TOTAL_SIZE :
				delta1.totalSize =
					_currentSnapshot.totalSize - _previousSnapshot.totalSize;
	
				break;
	
			case TracePackage.TRC_PROCESS__TOTAL_INSTANCES :
				delta1.totalInstances =
					_currentSnapshot.totalInstances
						- _previousSnapshot.totalInstances;
	
				break;
	
			case TracePackage.TRC_PROCESS__COLLECTED_SIZE :
				delta1.collectedSize =
					_currentSnapshot.collectedSize
						- _previousSnapshot.collectedSize;
	
				break;
	
			case TracePackage.TRC_PROCESS__COLLECTED_INSTANCES :
				delta1.collectedInstances =
					_currentSnapshot.collectedInstances
						- _previousSnapshot.collectedInstances;
	
				break;
		}
	
		return 1;
	}
	/**
	 *
	 */
	public void removeSnapshot() {
		_currentSnapshot = null;
		_previousSnapshot = null;
	}
	/**
	 *
	 */
	public ISnapshot retrieveSnapshot() {
		if(_currentSnapshot==null)
		{
			takeSnapshot();
		}
		return _currentSnapshot;
	}
	/**
	 *
	 */
	public void takeSnapshot() {
		TRCProcessSnapshot temp = _previousSnapshot;
	
		_previousSnapshot = _currentSnapshot;
		_currentSnapshot = temp;
	
		if (_currentSnapshot == null) {
			_currentSnapshot = new TRCProcessSnapshot();
		}
	
		_currentSnapshot.baseTime = baseTime;
		_currentSnapshot.calls = calls;
		_currentSnapshot.collectedInstances = collectedInstances;
		_currentSnapshot.collectedSize = collectedSize;
		_currentSnapshot.cumulativeTime = cumulativeTime;
		_currentSnapshot.inheritedBaseTime = inheritedBaseTime;
		_currentSnapshot.inheritedCalls = inheritedCalls;
		_currentSnapshot.inheritedCumulativeTime = inheritedCumulativeTime;
		_currentSnapshot.totalInstances = totalInstances;
		_currentSnapshot.totalSize = totalSize;
	}
	/**
	 * @author slavescu
	 */
	public static class TRCProcessSnapshot implements IDelta,ISnapshot {
		protected double baseTime = BASE_TIME_EDEFAULT;
		protected int calls = CALLS_EDEFAULT;
		protected int collectedInstances = COLLECTED_INSTANCES_EDEFAULT;
		protected int collectedSize = COLLECTED_SIZE_EDEFAULT;
		protected double cumulativeTime = CUMULATIVE_TIME_EDEFAULT;
		protected double inheritedBaseTime = INHERITED_BASE_TIME_EDEFAULT;
		protected int inheritedCalls = INHERITED_CALLS_EDEFAULT;
		protected double inheritedCumulativeTime = INHERITED_CUMULATIVE_TIME_EDEFAULT;
		protected int totalInstances = TOTAL_INSTANCES_EDEFAULT;
		protected int totalSize = TOTAL_SIZE_EDEFAULT;
	
	
		public Object get(int featureID) {
			switch (featureID) {
				case TracePackage.TRC_PROCESS__BASE_TIME:
					return new Double(getBaseTime());
				case TracePackage.TRC_PROCESS__CUMULATIVE_TIME:
					return new Double(getCumulativeTime());
				case TracePackage.TRC_PROCESS__CALLS:
					return new Integer(getCalls());
				case TracePackage.TRC_PROCESS__INHERITED_CALLS:
					return new Integer(getInheritedCalls());
				case TracePackage.TRC_PROCESS__INHERITED_BASE_TIME:
					return new Double(getInheritedBaseTime());
				case TracePackage.TRC_PROCESS__INHERITED_CUMULATIVE_TIME:
					return new Double(getInheritedCumulativeTime());
				case TracePackage.TRC_PROCESS__TOTAL_SIZE:
					return new Integer(getTotalSize());
				case TracePackage.TRC_PROCESS__TOTAL_INSTANCES:
					return new Integer(getTotalInstances());
				case TracePackage.TRC_PROCESS__COLLECTED_SIZE:
					return new Integer(getCollectedSize());
				case TracePackage.TRC_PROCESS__COLLECTED_INSTANCES:
					return new Integer(getCollectedInstances());
			}
			return null;
		}
	
		public double getBaseTime() {
			return baseTime;
		}
	
		public int getCalls() {
			return calls;
		}
	
		public int getCollectedInstances() {
			return collectedInstances;
		}
	
		public int getCollectedSize() {
			return collectedSize;
		}
	
		public double getCumulativeTime() {
			return cumulativeTime;
		}
	
		public double getInheritedBaseTime() {
			return inheritedBaseTime;
		}
	
		public int getInheritedCalls() {
			return inheritedCalls;
		}
	
		public int getTotalInstances() {
			return totalInstances;
		}
	
		public int getTotalSize() {
			return totalSize;
		}
	
		public double getInheritedCumulativeTime() {
			return inheritedCumulativeTime;
		}
	
	}
	/**
	 * The default value of the '{@link #getPid() <em>Pid</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPid()
	 * @generated
	 * @ordered
	 */
	protected static final int PID_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPid() <em>Pid</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPid()
	 * @generated
	 * @ordered
	 */
	protected int pid = PID_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartTime()
	 * @generated
	 * @ordered
	 */
	protected static final double START_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartTime()
	 * @generated
	 * @ordered
	 */
	protected double startTime = START_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getStopTime() <em>Stop Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopTime()
	 * @generated
	 * @ordered
	 */
	protected static final double STOP_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getStopTime() <em>Stop Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopTime()
	 * @generated
	 * @ordered
	 */
	protected double stopTime = STOP_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getLastEventTime() <em>Last Event Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastEventTime()
	 * @generated
	 * @ordered
	 */
	protected static final double LAST_EVENT_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getLastEventTime() <em>Last Event Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastEventTime()
	 * @generated
	 * @ordered
	 */
	protected double lastEventTime = LAST_EVENT_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getInitFinishedTime() <em>Init Finished Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInitFinishedTime()
	 * @generated
	 * @ordered
	 */
	protected static final double INIT_FINISHED_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getInitFinishedTime() <em>Init Finished Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInitFinishedTime()
	 * @generated
	 * @ordered
	 */
	protected double initFinishedTime = INIT_FINISHED_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getBaseTime() <em>Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBaseTime()
	 * @generated
	 * @ordered
	 */
	protected static final double BASE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getBaseTime() <em>Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBaseTime()
	 * @generated
	 * @ordered
	 */
	protected double baseTime = BASE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCumulativeTime() <em>Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected static final double CUMULATIVE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getCumulativeTime() <em>Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected double cumulativeTime = CUMULATIVE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCalls() <em>Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCalls()
	 * @generated
	 * @ordered
	 */
	protected static final int CALLS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCalls() <em>Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCalls()
	 * @generated
	 * @ordered
	 */
	protected int calls = CALLS_EDEFAULT;

	/**
	 * The default value of the '{@link #getInheritedCalls() <em>Inherited Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedCalls()
	 * @generated
	 * @ordered
	 */
	protected static final int INHERITED_CALLS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getInheritedCalls() <em>Inherited Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedCalls()
	 * @generated
	 * @ordered
	 */
	protected int inheritedCalls = INHERITED_CALLS_EDEFAULT;

	/**
	 * The default value of the '{@link #getInheritedBaseTime() <em>Inherited Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedBaseTime()
	 * @generated
	 * @ordered
	 */
	protected static final double INHERITED_BASE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getInheritedBaseTime() <em>Inherited Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedBaseTime()
	 * @generated
	 * @ordered
	 */
	protected double inheritedBaseTime = INHERITED_BASE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getInheritedCumulativeTime() <em>Inherited Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected static final double INHERITED_CUMULATIVE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getInheritedCumulativeTime() <em>Inherited Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected double inheritedCumulativeTime = INHERITED_CUMULATIVE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalSize() <em>Total Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalSize()
	 * @generated
	 * @ordered
	 */
	protected static final int TOTAL_SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTotalSize() <em>Total Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalSize()
	 * @generated
	 * @ordered
	 */
	protected int totalSize = TOTAL_SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalInstances() <em>Total Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalInstances()
	 * @generated
	 * @ordered
	 */
	protected static final int TOTAL_INSTANCES_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTotalInstances() <em>Total Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalInstances()
	 * @generated
	 * @ordered
	 */
	protected int totalInstances = TOTAL_INSTANCES_EDEFAULT;

	/**
	 * The default value of the '{@link #getCollectedSize() <em>Collected Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectedSize()
	 * @generated
	 * @ordered
	 */
	protected static final int COLLECTED_SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCollectedSize() <em>Collected Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectedSize()
	 * @generated
	 * @ordered
	 */
	protected int collectedSize = COLLECTED_SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getCollectedInstances() <em>Collected Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectedInstances()
	 * @generated
	 * @ordered
	 */
	protected static final int COLLECTED_INSTANCES_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCollectedInstances() <em>Collected Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectedInstances()
	 * @generated
	 * @ordered
	 */
	protected int collectedInstances = COLLECTED_INSTANCES_EDEFAULT;

	/**
	 * The default value of the '{@link #getReferencePointerSize() <em>Reference Pointer Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReferencePointerSize()
	 * @generated
	 * @ordered
	 */
	protected static final short REFERENCE_POINTER_SIZE_EDEFAULT = 4;

	/**
	 * The cached value of the '{@link #getReferencePointerSize() <em>Reference Pointer Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReferencePointerSize()
	 * @generated
	 * @ordered
	 */
	protected short referencePointerSize = REFERENCE_POINTER_SIZE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getThreadStates() <em>Thread States</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThreadStates()
	 * @generated
	 * @ordered
	 */
	protected EList threadStates = null;

	/**
	 * The cached value of the '{@link #getThreads() <em>Threads</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThreads()
	 * @generated
	 * @ordered
	 */
	protected EList threads = null;

	/**
	 * The cached value of the '{@link #getPackages() <em>Packages</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPackages()
	 * @generated
	 * @ordered
	 */
	protected EList packages = null;

	/**
	 * The cached value of the '{@link #getClassClass() <em>Class Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClassClass()
	 * @generated
	 * @ordered
	 */
	protected TRCClass classClass = null;

	/**
	 * The cached value of the '{@link #getCollectionBoundaryPoints() <em>Collection Boundary Points</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectionBoundaryPoints()
	 * @generated
	 * @ordered
	 */
	protected EList collectionBoundaryPoints = null;

	/**
	 * The cached value of the '{@link #getClassLoaders() <em>Class Loaders</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClassLoaders()
	 * @generated
	 * @ordered
	 */
	protected EList classLoaders = null;

	/**
	 * The cached value of the '{@link #getSourceInfos() <em>Source Infos</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceInfos()
	 * @generated
	 * @ordered
	 */
	protected EList sourceInfos = null;

	/**
	 * The cached value of the '{@link #getObjects() <em>Objects</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getObjects()
	 * @generated
	 * @ordered
	 */
	protected EList objects = null;

	/**
	 * The cached value of the '{@link #getHeapDumps() <em>Heap Dumps</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHeapDumps()
	 * @generated
	 * @ordered
	 */
	protected EList heapDumps = null;

	/**
	 * The cached value of the '{@link #getInvocations() <em>Invocations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInvocations()
	 * @generated
	 * @ordered
	 */
	protected EList invocations = null;

	/**
	 * The cached value of the '{@link #getInputOutputContainer() <em>Input Output Container</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInputOutputContainer()
	 * @generated
	 * @ordered
	 */
	protected TRCInputOutputContainer inputOutputContainer = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCProcessImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCProcess();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getPid() {
		return pid;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPid(int newPid) {
		int oldPid = pid;
		pid = newPid;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__PID, oldPid, pid));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getStartTime() {
		return startTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartTime(double newStartTime) {
		double oldStartTime = startTime;
		startTime = newStartTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__START_TIME, oldStartTime, startTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getStopTime() {
		return stopTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStopTime(double newStopTime) {
		double oldStopTime = stopTime;
		stopTime = newStopTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__STOP_TIME, oldStopTime, stopTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getLastEventTime() {
		return lastEventTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLastEventTime(double newLastEventTime) {
		double oldLastEventTime = lastEventTime;
		lastEventTime = newLastEventTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__LAST_EVENT_TIME, oldLastEventTime, lastEventTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getInitFinishedTime() {
		return initFinishedTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInitFinishedTime(double newInitFinishedTime) {
		double oldInitFinishedTime = initFinishedTime;
		initFinishedTime = newInitFinishedTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__INIT_FINISHED_TIME, oldInitFinishedTime, initFinishedTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getBaseTime() {
		return baseTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBaseTime(double newBaseTime) {
		double oldBaseTime = baseTime;
		baseTime = newBaseTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__BASE_TIME, oldBaseTime, baseTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getCumulativeTime() {
		return cumulativeTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCumulativeTime(double newCumulativeTime) {
		double oldCumulativeTime = cumulativeTime;
		cumulativeTime = newCumulativeTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__CUMULATIVE_TIME, oldCumulativeTime, cumulativeTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCalls() {
		return calls;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCalls(int newCalls) {
		int oldCalls = calls;
		calls = newCalls;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__CALLS, oldCalls, calls));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getInheritedCalls() {
		return inheritedCalls;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInheritedCalls(int newInheritedCalls) {
		int oldInheritedCalls = inheritedCalls;
		inheritedCalls = newInheritedCalls;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__INHERITED_CALLS, oldInheritedCalls, inheritedCalls));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getInheritedBaseTime() {
		return inheritedBaseTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInheritedBaseTime(double newInheritedBaseTime) {
		double oldInheritedBaseTime = inheritedBaseTime;
		inheritedBaseTime = newInheritedBaseTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__INHERITED_BASE_TIME, oldInheritedBaseTime, inheritedBaseTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getInheritedCumulativeTime() {
		return inheritedCumulativeTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInheritedCumulativeTime(double newInheritedCumulativeTime) {
		double oldInheritedCumulativeTime = inheritedCumulativeTime;
		inheritedCumulativeTime = newInheritedCumulativeTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__INHERITED_CUMULATIVE_TIME, oldInheritedCumulativeTime, inheritedCumulativeTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getTotalSize() {
		return totalSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTotalSize(int newTotalSize) {
		int oldTotalSize = totalSize;
		totalSize = newTotalSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__TOTAL_SIZE, oldTotalSize, totalSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getTotalInstances() {
		return totalInstances;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTotalInstances(int newTotalInstances) {
		int oldTotalInstances = totalInstances;
		totalInstances = newTotalInstances;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__TOTAL_INSTANCES, oldTotalInstances, totalInstances));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCollectedSize() {
		return collectedSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCollectedSize(int newCollectedSize) {
		int oldCollectedSize = collectedSize;
		collectedSize = newCollectedSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__COLLECTED_SIZE, oldCollectedSize, collectedSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCollectedInstances() {
		return collectedInstances;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCollectedInstances(int newCollectedInstances) {
		int oldCollectedInstances = collectedInstances;
		collectedInstances = newCollectedInstances;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__COLLECTED_INSTANCES, oldCollectedInstances, collectedInstances));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public short getReferencePointerSize() {
		return referencePointerSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReferencePointerSize(short newReferencePointerSize) {
		short oldReferencePointerSize = referencePointerSize;
		referencePointerSize = newReferencePointerSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__REFERENCE_POINTER_SIZE, oldReferencePointerSize, referencePointerSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getThreadStates() {
		if (threadStates == null) {
			threadStates = new EDataTypeUniqueEList(String.class, this, TracePackage.TRC_PROCESS__THREAD_STATES);
		}
		return threadStates;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getThreads() {
		if (threads == null) {
			threads = new EObjectContainmentWithInverseEList(TRCThread.class, this, TracePackage.TRC_PROCESS__THREADS, TracePackage.TRC_THREAD__PROCESS);
		}
		return threads;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getPackages() {
		if (packages == null) {
			packages = new EObjectContainmentWithInverseEList(TRCPackage.class, this, TracePackage.TRC_PROCESS__PACKAGES, TracePackage.TRC_PACKAGE__PROCESS);
		}
		return packages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClass getClassClass() {
		if (classClass != null && classClass.eIsProxy()) {
			TRCClass oldClassClass = classClass;
			classClass = (TRCClass)eResolveProxy((InternalEObject)classClass);
			if (classClass != oldClassClass) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_PROCESS__CLASS_CLASS, oldClassClass, classClass));
			}
		}
		return classClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClass basicGetClassClass() {
		return classClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setClassClass(TRCClass newClassClass) {
		TRCClass oldClassClass = classClass;
		classClass = newClassClass;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__CLASS_CLASS, oldClassClass, classClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getCollectionBoundaryPoints() {
		if (collectionBoundaryPoints == null) {
			collectionBoundaryPoints = new EObjectContainmentWithInverseEList(TRCCollectionBoundary.class, this, TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS, TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS);
		}
		return collectionBoundaryPoints;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getClassLoaders() {
		if (classLoaders == null) {
			classLoaders = new EObjectContainmentWithInverseEList(TRCClassLoader.class, this, TracePackage.TRC_PROCESS__CLASS_LOADERS, TracePackage.TRC_CLASS_LOADER__PROCESS);
		}
		return classLoaders;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSourceInfos() {
		if (sourceInfos == null) {
			sourceInfos = new EObjectContainmentEList(TRCSourceInfo.class, this, TracePackage.TRC_PROCESS__SOURCE_INFOS);
		}
		return sourceInfos;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getObjects() {
		if (objects == null) {
			objects = new EObjectContainmentWithInverseEList(TRCObject.class, this, TracePackage.TRC_PROCESS__OBJECTS, TracePackage.TRC_OBJECT__PROCESS);
		}
		return objects;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getHeapDumps() {
		if (heapDumps == null) {
			heapDumps = new EObjectContainmentWithInverseEList(TRCHeapDump.class, this, TracePackage.TRC_PROCESS__HEAP_DUMPS, TracePackage.TRC_HEAP_DUMP__PROCESS);
		}
		return heapDumps;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getInvocations() {
		if (invocations == null) {
			invocations = new EObjectContainmentWithInverseEList(TRCMethodInvocation.class, this, TracePackage.TRC_PROCESS__INVOCATIONS, TracePackage.TRC_METHOD_INVOCATION__PROCESS);
		}
		return invocations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCInputOutputContainer getInputOutputContainer() {
		if (inputOutputContainer != null && inputOutputContainer.eIsProxy()) {
			TRCInputOutputContainer oldInputOutputContainer = inputOutputContainer;
			inputOutputContainer = (TRCInputOutputContainer)eResolveProxy((InternalEObject)inputOutputContainer);
			if (inputOutputContainer != oldInputOutputContainer) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER, oldInputOutputContainer, inputOutputContainer));
			}
		}
		return inputOutputContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCInputOutputContainer basicGetInputOutputContainer() {
		return inputOutputContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInputOutputContainer(TRCInputOutputContainer newInputOutputContainer, NotificationChain msgs) {
		TRCInputOutputContainer oldInputOutputContainer = inputOutputContainer;
		inputOutputContainer = newInputOutputContainer;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER, oldInputOutputContainer, newInputOutputContainer);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInputOutputContainer(TRCInputOutputContainer newInputOutputContainer) {
		if (newInputOutputContainer != inputOutputContainer) {
			NotificationChain msgs = null;
			if (inputOutputContainer != null)
				msgs = ((InternalEObject)inputOutputContainer).eInverseRemove(this, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__PROCESS, TRCInputOutputContainer.class, msgs);
			if (newInputOutputContainer != null)
				msgs = ((InternalEObject)newInputOutputContainer).eInverseAdd(this, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__PROCESS, TRCInputOutputContainer.class, msgs);
			msgs = basicSetInputOutputContainer(newInputOutputContainer, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER, newInputOutputContainer, newInputOutputContainer));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_PROCESS__AGENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_PROCESS__AGENT, msgs);
				case TracePackage.TRC_PROCESS__THREADS:
					return ((InternalEList)getThreads()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_PROCESS__PACKAGES:
					return ((InternalEList)getPackages()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS:
					return ((InternalEList)getCollectionBoundaryPoints()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_PROCESS__CLASS_LOADERS:
					return ((InternalEList)getClassLoaders()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_PROCESS__OBJECTS:
					return ((InternalEList)getObjects()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_PROCESS__HEAP_DUMPS:
					return ((InternalEList)getHeapDumps()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_PROCESS__INVOCATIONS:
					return ((InternalEList)getInvocations()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER:
					if (inputOutputContainer != null)
						msgs = ((InternalEObject)inputOutputContainer).eInverseRemove(this, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__PROCESS, TRCInputOutputContainer.class, msgs);
					return basicSetInputOutputContainer((TRCInputOutputContainer)otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_PROCESS__AGENT:
					return eBasicSetContainer(null, TracePackage.TRC_PROCESS__AGENT, msgs);
				case TracePackage.TRC_PROCESS__THREADS:
					return ((InternalEList)getThreads()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_PROCESS__PACKAGES:
					return ((InternalEList)getPackages()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS:
					return ((InternalEList)getCollectionBoundaryPoints()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_PROCESS__CLASS_LOADERS:
					return ((InternalEList)getClassLoaders()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_PROCESS__SOURCE_INFOS:
					return ((InternalEList)getSourceInfos()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_PROCESS__OBJECTS:
					return ((InternalEList)getObjects()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_PROCESS__HEAP_DUMPS:
					return ((InternalEList)getHeapDumps()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_PROCESS__INVOCATIONS:
					return ((InternalEList)getInvocations()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER:
					return basicSetInputOutputContainer(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_PROCESS__AGENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, HierarchyPackage.TRC_AGENT__PROCESS, TRCAgent.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_PROCESS__AGENT:
				return getAgent();
			case TracePackage.TRC_PROCESS__PID:
				return new Integer(getPid());
			case TracePackage.TRC_PROCESS__NAME:
				return getName();
			case TracePackage.TRC_PROCESS__ID:
				return getId();
			case TracePackage.TRC_PROCESS__START_TIME:
				return new Double(getStartTime());
			case TracePackage.TRC_PROCESS__STOP_TIME:
				return new Double(getStopTime());
			case TracePackage.TRC_PROCESS__LAST_EVENT_TIME:
				return new Double(getLastEventTime());
			case TracePackage.TRC_PROCESS__INIT_FINISHED_TIME:
				return new Double(getInitFinishedTime());
			case TracePackage.TRC_PROCESS__BASE_TIME:
				return new Double(getBaseTime());
			case TracePackage.TRC_PROCESS__CUMULATIVE_TIME:
				return new Double(getCumulativeTime());
			case TracePackage.TRC_PROCESS__CALLS:
				return new Integer(getCalls());
			case TracePackage.TRC_PROCESS__INHERITED_CALLS:
				return new Integer(getInheritedCalls());
			case TracePackage.TRC_PROCESS__INHERITED_BASE_TIME:
				return new Double(getInheritedBaseTime());
			case TracePackage.TRC_PROCESS__INHERITED_CUMULATIVE_TIME:
				return new Double(getInheritedCumulativeTime());
			case TracePackage.TRC_PROCESS__TOTAL_SIZE:
				return new Integer(getTotalSize());
			case TracePackage.TRC_PROCESS__TOTAL_INSTANCES:
				return new Integer(getTotalInstances());
			case TracePackage.TRC_PROCESS__COLLECTED_SIZE:
				return new Integer(getCollectedSize());
			case TracePackage.TRC_PROCESS__COLLECTED_INSTANCES:
				return new Integer(getCollectedInstances());
			case TracePackage.TRC_PROCESS__REFERENCE_POINTER_SIZE:
				return new Short(getReferencePointerSize());
			case TracePackage.TRC_PROCESS__THREAD_STATES:
				return getThreadStates();
			case TracePackage.TRC_PROCESS__THREADS:
				return getThreads();
			case TracePackage.TRC_PROCESS__PACKAGES:
				return getPackages();
			case TracePackage.TRC_PROCESS__CLASS_CLASS:
				if (resolve) return getClassClass();
				return basicGetClassClass();
			case TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS:
				return getCollectionBoundaryPoints();
			case TracePackage.TRC_PROCESS__CLASS_LOADERS:
				return getClassLoaders();
			case TracePackage.TRC_PROCESS__SOURCE_INFOS:
				return getSourceInfos();
			case TracePackage.TRC_PROCESS__OBJECTS:
				return getObjects();
			case TracePackage.TRC_PROCESS__HEAP_DUMPS:
				return getHeapDumps();
			case TracePackage.TRC_PROCESS__INVOCATIONS:
				return getInvocations();
			case TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER:
				if (resolve) return getInputOutputContainer();
				return basicGetInputOutputContainer();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_PROCESS__AGENT:
				setAgent((TRCAgent)newValue);
				return;
			case TracePackage.TRC_PROCESS__PID:
				setPid(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_PROCESS__NAME:
				setName((String)newValue);
				return;
			case TracePackage.TRC_PROCESS__ID:
				setId((String)newValue);
				return;
			case TracePackage.TRC_PROCESS__START_TIME:
				setStartTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_PROCESS__STOP_TIME:
				setStopTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_PROCESS__LAST_EVENT_TIME:
				setLastEventTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_PROCESS__INIT_FINISHED_TIME:
				setInitFinishedTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_PROCESS__BASE_TIME:
				setBaseTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_PROCESS__CUMULATIVE_TIME:
				setCumulativeTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_PROCESS__CALLS:
				setCalls(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_PROCESS__INHERITED_CALLS:
				setInheritedCalls(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_PROCESS__INHERITED_BASE_TIME:
				setInheritedBaseTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_PROCESS__INHERITED_CUMULATIVE_TIME:
				setInheritedCumulativeTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_PROCESS__TOTAL_SIZE:
				setTotalSize(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_PROCESS__TOTAL_INSTANCES:
				setTotalInstances(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_PROCESS__COLLECTED_SIZE:
				setCollectedSize(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_PROCESS__COLLECTED_INSTANCES:
				setCollectedInstances(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_PROCESS__REFERENCE_POINTER_SIZE:
				setReferencePointerSize(((Short)newValue).shortValue());
				return;
			case TracePackage.TRC_PROCESS__THREAD_STATES:
				getThreadStates().clear();
				getThreadStates().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_PROCESS__THREADS:
				getThreads().clear();
				getThreads().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_PROCESS__PACKAGES:
				getPackages().clear();
				getPackages().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_PROCESS__CLASS_CLASS:
				setClassClass((TRCClass)newValue);
				return;
			case TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS:
				getCollectionBoundaryPoints().clear();
				getCollectionBoundaryPoints().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_PROCESS__CLASS_LOADERS:
				getClassLoaders().clear();
				getClassLoaders().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_PROCESS__SOURCE_INFOS:
				getSourceInfos().clear();
				getSourceInfos().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_PROCESS__OBJECTS:
				getObjects().clear();
				getObjects().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_PROCESS__HEAP_DUMPS:
				getHeapDumps().clear();
				getHeapDumps().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_PROCESS__INVOCATIONS:
				getInvocations().clear();
				getInvocations().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER:
				setInputOutputContainer((TRCInputOutputContainer)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_PROCESS__AGENT:
				setAgent((TRCAgent)null);
				return;
			case TracePackage.TRC_PROCESS__PID:
				setPid(PID_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__NAME:
				setName(NAME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__ID:
				setId(ID_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__START_TIME:
				setStartTime(START_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__STOP_TIME:
				setStopTime(STOP_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__LAST_EVENT_TIME:
				setLastEventTime(LAST_EVENT_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__INIT_FINISHED_TIME:
				setInitFinishedTime(INIT_FINISHED_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__BASE_TIME:
				setBaseTime(BASE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__CUMULATIVE_TIME:
				setCumulativeTime(CUMULATIVE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__CALLS:
				setCalls(CALLS_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__INHERITED_CALLS:
				setInheritedCalls(INHERITED_CALLS_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__INHERITED_BASE_TIME:
				setInheritedBaseTime(INHERITED_BASE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__INHERITED_CUMULATIVE_TIME:
				setInheritedCumulativeTime(INHERITED_CUMULATIVE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__TOTAL_SIZE:
				setTotalSize(TOTAL_SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__TOTAL_INSTANCES:
				setTotalInstances(TOTAL_INSTANCES_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__COLLECTED_SIZE:
				setCollectedSize(COLLECTED_SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__COLLECTED_INSTANCES:
				setCollectedInstances(COLLECTED_INSTANCES_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__REFERENCE_POINTER_SIZE:
				setReferencePointerSize(REFERENCE_POINTER_SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_PROCESS__THREAD_STATES:
				getThreadStates().clear();
				return;
			case TracePackage.TRC_PROCESS__THREADS:
				getThreads().clear();
				return;
			case TracePackage.TRC_PROCESS__PACKAGES:
				getPackages().clear();
				return;
			case TracePackage.TRC_PROCESS__CLASS_CLASS:
				setClassClass((TRCClass)null);
				return;
			case TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS:
				getCollectionBoundaryPoints().clear();
				return;
			case TracePackage.TRC_PROCESS__CLASS_LOADERS:
				getClassLoaders().clear();
				return;
			case TracePackage.TRC_PROCESS__SOURCE_INFOS:
				getSourceInfos().clear();
				return;
			case TracePackage.TRC_PROCESS__OBJECTS:
				getObjects().clear();
				return;
			case TracePackage.TRC_PROCESS__HEAP_DUMPS:
				getHeapDumps().clear();
				return;
			case TracePackage.TRC_PROCESS__INVOCATIONS:
				getInvocations().clear();
				return;
			case TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER:
				setInputOutputContainer((TRCInputOutputContainer)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_PROCESS__AGENT:
				return getAgent() != null;
			case TracePackage.TRC_PROCESS__PID:
				return pid != PID_EDEFAULT;
			case TracePackage.TRC_PROCESS__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case TracePackage.TRC_PROCESS__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case TracePackage.TRC_PROCESS__START_TIME:
				return startTime != START_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__STOP_TIME:
				return stopTime != STOP_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__LAST_EVENT_TIME:
				return lastEventTime != LAST_EVENT_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__INIT_FINISHED_TIME:
				return initFinishedTime != INIT_FINISHED_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__BASE_TIME:
				return baseTime != BASE_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__CUMULATIVE_TIME:
				return cumulativeTime != CUMULATIVE_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__CALLS:
				return calls != CALLS_EDEFAULT;
			case TracePackage.TRC_PROCESS__INHERITED_CALLS:
				return inheritedCalls != INHERITED_CALLS_EDEFAULT;
			case TracePackage.TRC_PROCESS__INHERITED_BASE_TIME:
				return inheritedBaseTime != INHERITED_BASE_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__INHERITED_CUMULATIVE_TIME:
				return inheritedCumulativeTime != INHERITED_CUMULATIVE_TIME_EDEFAULT;
			case TracePackage.TRC_PROCESS__TOTAL_SIZE:
				return totalSize != TOTAL_SIZE_EDEFAULT;
			case TracePackage.TRC_PROCESS__TOTAL_INSTANCES:
				return totalInstances != TOTAL_INSTANCES_EDEFAULT;
			case TracePackage.TRC_PROCESS__COLLECTED_SIZE:
				return collectedSize != COLLECTED_SIZE_EDEFAULT;
			case TracePackage.TRC_PROCESS__COLLECTED_INSTANCES:
				return collectedInstances != COLLECTED_INSTANCES_EDEFAULT;
			case TracePackage.TRC_PROCESS__REFERENCE_POINTER_SIZE:
				return referencePointerSize != REFERENCE_POINTER_SIZE_EDEFAULT;
			case TracePackage.TRC_PROCESS__THREAD_STATES:
				return threadStates != null && !threadStates.isEmpty();
			case TracePackage.TRC_PROCESS__THREADS:
				return threads != null && !threads.isEmpty();
			case TracePackage.TRC_PROCESS__PACKAGES:
				return packages != null && !packages.isEmpty();
			case TracePackage.TRC_PROCESS__CLASS_CLASS:
				return classClass != null;
			case TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS:
				return collectionBoundaryPoints != null && !collectionBoundaryPoints.isEmpty();
			case TracePackage.TRC_PROCESS__CLASS_LOADERS:
				return classLoaders != null && !classLoaders.isEmpty();
			case TracePackage.TRC_PROCESS__SOURCE_INFOS:
				return sourceInfos != null && !sourceInfos.isEmpty();
			case TracePackage.TRC_PROCESS__OBJECTS:
				return objects != null && !objects.isEmpty();
			case TracePackage.TRC_PROCESS__HEAP_DUMPS:
				return heapDumps != null && !heapDumps.isEmpty();
			case TracePackage.TRC_PROCESS__INVOCATIONS:
				return invocations != null && !invocations.isEmpty();
			case TracePackage.TRC_PROCESS__INPUT_OUTPUT_CONTAINER:
				return inputOutputContainer != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (pid: ");
		result.append(pid);
		result.append(", name: ");
		result.append(name);
		result.append(", id: ");
		result.append(id);
		result.append(", startTime: ");
		result.append(startTime);
		result.append(", stopTime: ");
		result.append(stopTime);
		result.append(", lastEventTime: ");
		result.append(lastEventTime);
		result.append(", initFinishedTime: ");
		result.append(initFinishedTime);
		result.append(", baseTime: ");
		result.append(baseTime);
		result.append(", cumulativeTime: ");
		result.append(cumulativeTime);
		result.append(", calls: ");
		result.append(calls);
		result.append(", inheritedCalls: ");
		result.append(inheritedCalls);
		result.append(", inheritedBaseTime: ");
		result.append(inheritedBaseTime);
		result.append(", inheritedCumulativeTime: ");
		result.append(inheritedCumulativeTime);
		result.append(", totalSize: ");
		result.append(totalSize);
		result.append(", totalInstances: ");
		result.append(totalInstances);
		result.append(", collectedSize: ");
		result.append(collectedSize);
		result.append(", collectedInstances: ");
		result.append(collectedInstances);
		result.append(", referencePointerSize: ");
		result.append(referencePointerSize);
		result.append(", threadStates: ");
		result.append(threadStates);
		result.append(')');
		return result.toString();
	}

} //TRCProcessImpl
