/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.util;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * This class migrates a pre 1.3 outputter configuration to a 1.3 
 * outputter configuration.
 * 
 */
public class OutputterMigrator implements IComponentMigrator {
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.logging.adapter.util.IComponentMigrator#migrate(org.w3c.dom.Element)
	 */
	public Element migrate(Element oldOutputterConfiguration)
		throws AdapterMigrationException {
			boolean migrated = false;
			Element newOutputterConfiguration = null;
			Document doc;
			try {
				doc = oldOutputterConfiguration.getOwnerDocument();

				newOutputterConfiguration = (Element)oldOutputterConfiguration.cloneNode(false);
				
				// Remove the type attribute		
				if (newOutputterConfiguration.hasAttribute(Messages.getString("HyadesGAtypeAttributeName"))) {
					newOutputterConfiguration.removeAttribute(Messages.getString("HyadesGAtypeAttributeName"));
					migrated = true;
				}
							
				Element outputterNode;
				Element outputterProperty;
			
				String propertyValue;
				String propertyName;
				
				// Get the outputter children (should only be one outputter type instance)
				NodeList outputterNodes = oldOutputterConfiguration.getChildNodes();
				for (int k = 0; k < outputterNodes.getLength(); k++) {
					if (outputterNodes.item(k).getNodeType() == Node.ELEMENT_NODE) {
						outputterNode = (Element) outputterNodes.item(k);
						// Process the outputter type instance attributes
						if (outputterNode.getTagName().equals(Messages.getString("HyadesGASingleFileOutputterTypeTagName")) ||
							outputterNode.getTagName().equals(Messages.getString("HyadesGALogOutputterTypeTagName"))) {

							// Get the outputter type attributes and convert them to properties
							NamedNodeMap outputterTypeAttributeList = outputterNode.getAttributes();
							int outputterTypeAttributeCount = outputterTypeAttributeList.getLength();
							String converter;
				
							for(int j = 0; j < outputterTypeAttributeCount; ++j)
							{
								Node outputterTypeAttribute = outputterTypeAttributeList.item(j);
								propertyName = outputterTypeAttribute.getNodeName();
								propertyValue = outputterTypeAttribute.getNodeValue();
							
								outputterProperty = doc.createElement(Messages.getString("HyadesGAPropertyElementTagName"));
								outputterProperty.setAttribute(Messages.getString("HyadesGAPropertyValueAttributeName"), propertyValue);
								outputterProperty.setAttribute(Messages.getString("HyadesGAPropertyNameAttributeName"), propertyName);
								newOutputterConfiguration.appendChild(outputterProperty);

							}
							if (outputterTypeAttributeCount > 0)
								migrated = true;
						}
					}
				}			
			}
			catch (Exception e) {
				throw new AdapterMigrationException("bad error", e);
			}
			if (!migrated)
				newOutputterConfiguration = null;
				
			return newOutputterConfiguration;
	}

}
