/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Feb 3, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.sd.logc.internal.loader;


import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFilterProvider;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFindProvider;
import org.eclipse.hyades.log.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.log.ui.internal.util.FiltersDialog;
import org.eclipse.hyades.log.ui.internal.util.LogFilterCriteria;
import org.eclipse.hyades.log.ui.internal.util.LogFindCriteria;
import org.eclipse.hyades.log.ui.internal.util.LogRecordSearch;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.LogUtil;
import org.eclipse.hyades.log.ui.internal.util.RecordFilterSearchUtil;
import org.eclipse.hyades.log.ui.internal.util.SearchRecordDialog;
import org.eclipse.hyades.log.ui.internal.util.SortElement;
import org.eclipse.hyades.logc.LogCorrelatorPlugin;
import org.eclipse.hyades.logc.internal.util.CorrelationHelper;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.cbe.util.LogQueryBuilder;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.models.hierarchy.impl.CorrelationEntryImpl;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.IFilterElement;
import org.eclipse.hyades.models.hierarchy.util.ILogFilterCriteria;
import org.eclipse.hyades.models.hierarchy.util.ISortElement;
import org.eclipse.hyades.sd.logc.SDLogcConstants;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.SDLogcPluginImages;
import org.eclipse.hyades.sd.logc.internal.preferences.ILogInteractionsPreferenceListener;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogAsyncMessage;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogAsyncReturnMessage;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogGraphNode;
import org.eclipse.hyades.sd.logc.internal.uml2sd.SourceOutOfPageMessage;
import org.eclipse.hyades.sd.logc.internal.uml2sd.TargetOutOfPageMessage;
import org.eclipse.hyades.sd.logc.internal.util.ContextIds;
import org.eclipse.hyades.sd.logc.internal.util.LogCorrelationSelectionDialog;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class LogInteractions 
	implements IUml2SDLoader, ISelectionListener, ISelectionChangedListener, IViewSelectionChangedListener,
			   ISDAdvancedPagingProvider, ILogInteractionsPreferenceListener,
			   IExtendedFilterProvider, IExtendedFindProvider,
			   ILogFilterProvider, ILogFindProvider, IProfileEventListener, IJobChangeListener{
	
	public class LogInteractionsFrame extends Frame{
		
			/* (non-Javadoc)
		 * @see org.eclipse.hyades.uml2sd.ui.core.Frame#getMaxEventOccurrence()
		 */
		public int getMaxEventOccurrence() {			
			return super.getMaxEventOccurrence();
		}
		

		/* (non-Javadoc)
		 * @see org.eclipse.hyades.uml2sd.ui.core.Frame#getLifelines()
		 */
		public List getLifelines() {
			// TODO Auto-generated method stub
			return super.getLifelines();
		}
		
	}
	
	public class TraceLifeline extends Lifeline {
		public EObject model;
		public int start, end;
	}
		
	protected class LogRecordComparator implements Comparator{

		public int compare(Object o1, Object o2){	
			if(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)o1)>CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)o2)){
				return 1;
			}else if(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)o1)==CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)o2)){ 
				if(((CBECommonBaseEvent)o1).getSequenceNumber()>((CBECommonBaseEvent)o2).getSequenceNumber()){
					return 1;
				}else if(((CBECommonBaseEvent)o1).getSequenceNumber()==((CBECommonBaseEvent)o2).getSequenceNumber()){
					return 0;
				}else
					return -1;
			}
			else{
				return -1;
			}
		}
		
		public int compareByTime(Object o1, Object o2){	
			if(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)o1)>CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)o2)){
				return 1;
			}else if(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)o1)==CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)o2)){ 
				return 0;
			}else{
				return -1;
			}
		}		
		
	
	}
	protected CorrelationContainerProxy correlationContainerProxy;
	protected EObject inputObject;
	protected Map graphNodes = new HashMap();

	protected Map lifelinesMap = new HashMap();	
	protected List eventsList = new ArrayList();
	protected Map eventsMap =  new HashMap();
	protected Map currentPageEvents = new HashMap();
	protected List agentsList = new ArrayList();
	protected SDView view;
	private Map sourceOutOfPageMessages;
	private Map targetOutOfPageMessages;
	private Map dummyMessages;
	private IConfigurationElement correlationType; 
	private LogRecordComparator comparator;
	private CBECommonBaseEvent currentSelection;
	private CBECommonBaseEvent thisSelection;
	private SearchRecordDialog dialog;
	private LogFilterCriteria criteria = null;
	private boolean isInputXMI = true;
	private SimpleSearchQuery query = null;
	private QueryResult outBoundCorrelations = null;
	private QueryResult inboundCorrelations = null;
	private final int TIME_CONVERSION_FACTOR = 1000000;

	/**
	 * Paging related attributes
	 */
	private int currentPageIndex = 0;
	private int nrOfPages = 0;
	private int PAGE_SIZE = 0;
	private int MAX_NR_OF_RECORDS = 99999; //don't change this value, it is limited in the UI.
	private int totalSize = 0;
	
	final private int NODE_SIZE = 24; //in pixel
	/**
	 * Find and Filter related attributes
	 */
	private IFilterElement[] filterTableElements = null;	
	private RecordFilterSearchUtil recordFilterSearch = null;
	private boolean displayOnlyCorrelations = true;
	
	private Object[] pageCache;

	private LogRecordSearch logRecordSearch = null;

	protected List expandedList = new ArrayList();
	
	/**
	 * The frame containing the current page
	 */
	protected LogInteractionsFrame frame;
	protected static LifelineCategories[] traceCategories;
	protected static IImage image; 
	public static final int CATEGORY_LOGS = 0;
	private boolean debug = false;
	static{		
		traceCategories = new LifelineCategories[1];
		traceCategories[CATEGORY_LOGS] = new LifelineCategories();
		traceCategories[CATEGORY_LOGS].setName(""); 
		image = SDLogcPluginImages.getImage(SDLogcPluginImages.IMG_LOG);
		traceCategories[CATEGORY_LOGS].setImage(image); 
	}

	public LogInteractions() {
		UIPlugin.getDefault().addSelectionListener(this);
		UIPlugin.getDefault().addViewSelectionChangedListener(this);
		UIPlugin.getDefault().addProfileEventListener(this);
		CorrelationHelper.getInstance().addJobChangeListener(this);
		recordFilterSearch = new RecordFilterSearchUtil();		
	}

	/**
	 * Implementation of IUml2SDLoader
	 */
	public void setViewer(SDView view) {
		this.view = view;
		view.setSDPagingProvider(this);
		
		view.setExtendedFilterProvider(this);
		view.setExtendedFindProvider(this);
		view.getSDWidget().getSelectionProvider().addSelectionChangedListener(this);
		
		view.getSite().setSelectionProvider(view.getSDWidget().getSelectionProvider());

		WorkbenchHelp.setHelp(this.view.getSDWidget(),ContextIds.INTERACTION_VIEW);
	}
	public void aboutToBeReplaced() {
		UIPlugin.getDefault().removeSelectionListener(this);
		UIPlugin.getDefault().removeViewSelectionChangedListener(this);
		UIPlugin.getDefault().removeProfileEventListener(this);
		CorrelationHelper.getInstance().removeJobChangeListener(this);
		if (view != null) {
			view.getSDWidget().getSelectionProvider().removeSelectionChangedListener(this);
		}
		clearDiagramCaches();		
		recordFilterSearch=null;
	}
	
	public void generateLogInteractions(final EObject eObject, final boolean displayDialog){		
		view.setFrame(parseModel(eObject, displayDialog, false));
		disableMessageActions();
	}
	
	public void generateLogInteractions(final EObject eObject, final IConfigurationElement config){
		setCorrelationType(config);
		view.setFrame(parseModel(CorrelationHelper.getInstance().createCorrelationContainer(correlationType, eObject,correlationType.getAttribute("name")), false,false));
		disableMessageActions();
	}
	
	public LogInteractionsFrame parseModel(final EObject eObject, final boolean displayDialog, final boolean refresh){
		
		inputObject = eObject; 	
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		displayOnlyCorrelations = store.getString(LogUIConstants.PD_FILTER_SHOW_CORRELATION_ONLY).equals("1");
		
		correlationContainerProxy = null;
		clearDiagramCaches();

		BusyIndicator.showWhile(Display.getDefault(),new Runnable(){
			public void run(){	
				loadCorrelations(displayDialog);
				createPartition();
				frame = createPage(refresh);

			}
		});

		return frame;
 
	}
	
	public LogInteractionsFrame parseModel(EObject eObject) {
		
		return parseModel(eObject, false, false);		
	}
	
	protected void refresh(){
		if (inputObject!=null ) {
			view.setFrame(parseModel(inputObject, false, true));
		}
		else {
			view.setFrame(new Frame());
		}
		
	}
	protected List getFilteredEventsXMI(List input){
		if (input==null) return new ArrayList(0);
		
		List filteredList = new ArrayList();
		for (int i = 0; i < input.size(); i++) {
			Object entry = input.get(i);
			if (isFilterApplied((EObject)entry))
				filteredList.add(entry);
		}		
		Collections.sort(filteredList, getComparator());
		return filteredList;
	}
	
	/**
	 * @param event for checking if current filter applied.
	 * @return true if event match the filter, false when not matched.
	 * 
	 * if there is no filter, return true always.
	 */
	private boolean isFilterApplied(EObject event){
		if (filterTableElements==null || filterTableElements.length ==0) return true;
		return recordFilterSearch.isAdvFilterApply(event, filterTableElements);
	}
	
	protected void clearTemporaryCaches(){		
		
		graphNodes.clear();		
		//targetEvents.clear();
		//temp.clear();
		lifelinesMap.clear();
		currentPageEvents.clear();
		
		if(sourceOutOfPageMessages!=null)	
			sourceOutOfPageMessages.clear();		
		if(targetOutOfPageMessages!=null)
			targetOutOfPageMessages.clear();
		if(dummyMessages!=null){
			dummyMessages.clear();
		}
	}
	
	protected void clearDiagramCaches(){
		clearTemporaryCaches();			
		agentsList.clear();
		eventsMap.clear();
		if(eventsList!=null){	
			eventsList.clear();
			eventsList = null;
			eventsList = new ArrayList(0);
		}
		if(pageCache!=null){
			for (int i = 0; i < pageCache.length; i++) {
				pageCache[i] = null;
			}
			pageCache = null;
		}
		expandedList.clear();
	}

	protected void loadCorrelations(boolean displayDialog){
		
		
		if(inputObject instanceof CorrelationContainerProxy)
		{
			correlationContainerProxy = (CorrelationContainerProxy)inputObject;

		}else{
			if(displayDialog)	{
				showCorrelationDialog();
			}			
		}

		loadAgents();
		setInputType();

		if(isInputXMI()){
			loadEventsXMI();
			eventsList = getFilteredEventsXMI(eventsList);
		}
		else{			
			loadEventsSQL();
			//eventsList = getFilteredEventsSQL();	
		}
			
	}
	
	private void loadAgents(){
		if(correlationContainerProxy!=null){
			agentsList.addAll(((CorrelationContainerProxy)correlationContainerProxy).getCorrelatedAgents()); 
		}else{
			agentsList.addAll(HyadesUtil.getLogAgents(inputObject));
		}		
	}
	
	/**
	 * @return
	 */
	private List getFilteredEventsSQL() {
		
		query = (SimpleSearchQuery)LogQueryBuilder.createQuery(agentsList, getFilterCriteria());
		QueryResult queryResult = LogQueryBuilder.executeQuery(query, HierarchyResourceSetImpl.getInstance());
		if(queryResult==null)
		{
			return new ArrayList(0);
		}
		ResultEntry resultEntry =(ResultEntry)queryResult.getResultEntries().get(0);  
		return resultEntry.getObjects();
		
	}

	/**
	 * 
	 */
	protected void loadEventsSQL() {
		for (Iterator iter = agentsList.iterator(); iter.hasNext();) {
			TRCAgentProxy element = (TRCAgentProxy) iter.next();
			element.getAgent();
		}

		if(!displayOnlyCorrelations){
			eventsList=getFilteredEventsSQL();
		}else{
			loadEventsFromCorrelationsSQL();
		}
	}

	/**
	 * 
	 */
	protected void loadEventsFromCorrelationsSQL() {
		
		if(correlationContainerProxy==null){
			eventsList = new ArrayList(0);
			return;
		}
		try{
			CorrelationContainer correlationContainer = (CorrelationContainer)correlationContainerProxy.eGet(HierarchyPackage.eINSTANCE.getCorrelationContainerProxy_CorrelationContainer(),false);
			if(correlationContainer==null)
				return;
			URI correlationContainerURI = EcoreUtil.getURI(correlationContainer);
			
			query = (SimpleSearchQuery)LogQueryBuilder.createCorrelatedEventsQuery(agentsList);
			((TimeBasedCorrelationQuery)query).setCorrelationContainerURI(correlationContainerURI.toString());		
			query = (SimpleSearchQuery)LogQueryBuilder.getMergedQuery(query, getFilterCriteria());
			QueryResult queryResult = LogQueryBuilder.executeQuery(query, HierarchyResourceSetImpl.getInstance());		
			if(queryResult!=null){
				ResultEntry resultEntry =(ResultEntry)queryResult.getResultEntries().get(0); 
				eventsList=resultEntry.getObjects();
			}
		}catch(Exception e){
			//if not in debug mode fail silently and return an empty list
			if(debug)	
				e.printStackTrace();
			eventsList = new ArrayList(0);
		}
		
	}


	/**
	 * 
	 */
	private void addEventsSQL() {
		// TODO Auto-generated method stub
		
	}

	/**
	 * 
	 */
	private void setInputType() {
		
		int s = agentsList.size();
		TRCAgentProxy proxy = null;
		TRCAgent agent = null;
		for(int i=0;i<s;i++){
			proxy = (TRCAgentProxy)agentsList.get(i);
			agent = (TRCAgent)proxy.eGet(HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
			if(agent==null){
				continue;
			}
			if(EcoreUtil.getURI(agent).path().endsWith("xmi"))
			{				
				isInputXMI = true;
				return;
			}			
		}
		if(correlationContainerProxy!=null &&
			correlationContainerProxy.getCorrelationEngine().getName().equals(LogCorrelatorPlugin.getResourceString("CORR_NAME"))){
			isInputXMI = false;
			return;
		}
		isInputXMI = true;		
	}
	
	public boolean isInputXMI(){
		return isInputXMI;
	}

	protected void loadEventsXMI(){
	
		if(!displayOnlyCorrelations){
			for (Iterator iter = agentsList.iterator(); iter.hasNext();) {
				TRCAgentProxy trcAgentProxy = (TRCAgentProxy) iter.next();
				if (trcAgentProxy != null && !trcAgentProxy.eIsProxy())
				{		
					addEvents(trcAgentProxy);
				}
			}
		}else{
			loadEventsFromCorrelationsXMI();
		}
	}
	
	protected void loadEventsFromCorrelationsXMI(){

		if (correlationContainerProxy==null || correlationContainerProxy.getCorrelationContainer()==null) return;
		EMap correlations  = correlationContainerProxy.getCorrelationContainer().getCorrelations();
		CorrelationEntryImpl element;		
		List targetList;		
		synchronized(correlations){
			for (Iterator iter = correlations.iterator(); iter.hasNext();) {
				element = (CorrelationEntryImpl) iter.next();
				eventsMap.put(element.getKey(),"");
				targetList = (List)element.getValue();
				if(targetList!=null && targetList.size()>0){
					int s = targetList.size();
					for(int i=0;i<s;i++){
						eventsMap.put(targetList.get(i),"");
					}
				}
			}
		}
		if(!eventsMap.isEmpty())	
			eventsList.addAll(eventsMap.keySet());
		eventsMap.clear();
	}
	
	protected Comparator getComparator(){
		if(comparator==null){
			comparator = new LogRecordComparator();
		}
		return comparator;
	}
	
	protected void generateDiagram(final boolean refresh){
		
		BusyIndicator.showWhile(Display.getCurrent(), new Runnable(){
			public void run(){
				generateGraphNodes();
				if(isInputXMI()){						
					generateGraphConnectionsXMI();
				}else{
					generateGraphConnectionsSQL(refresh);
				}
			}

		});		
		//TODO move selection listeners to the sd view and remove them on dispose
	}
	
	private void generateGraphConnectionsSQL(final boolean refresh) {
	
		if(correlationContainerProxy==null)
			return;
						
		CorrelationContainer correlationContainer = (CorrelationContainer)correlationContainerProxy.eGet(HierarchyPackage.eINSTANCE.getCorrelationContainerProxy_CorrelationContainer(),false);
		if(correlationContainer==null)
			return;
		
		URI correlationContainerURI = EcoreUtil.getURI(correlationContainer);

		// get outbound correlations
		try{
			if(outBoundCorrelations==null || refresh){	
				Query outBoundCorrelationsQuery = LogQueryBuilder.createOutboundCorrelationQuery(agentsList, getFilterCriteria());
				((TimeBasedCorrelationQuery)outBoundCorrelationsQuery).setCorrelationContainerURI(correlationContainerURI.toString());
				outBoundCorrelations = LogQueryBuilder.executeQuery(outBoundCorrelationsQuery, HierarchyResourceSetImpl.getInstance());
			}
		}catch(Exception e){
			if(debug)
				e.printStackTrace();
		}
		

		ResultEntry resultEntry = null;
		List keysList = null;;		
		List valuesList = null;;
		CBECommonBaseEvent source = null;
		CBECommonBaseEvent target = null;
		List currentPageList = getCurrentPageEventsList();
		int s = currentPageList.size();
		int index = -1;

		if(outBoundCorrelations!=null){
			
		
			resultEntry =(ResultEntry)outBoundCorrelations.getResultEntries().get(0);
			keysList = resultEntry.getObjects();
			resultEntry =(ResultEntry)outBoundCorrelations.getResultEntries().get(1);
			valuesList = resultEntry.getObjects();
	
			//look for the first event in the current page contained in the correlation keys list
			for(int i=0;i<s;i++){			
				source = (CBECommonBaseEvent)currentPageList.get(i);			
				index = keysList.indexOf(source);
				if(index<0){
					continue;
				}else{
					break;
				}
			}
			//create messages that have the source in the current page
			if(debug){
				System.out.println("Index outbound = "+index);
				System.out.println("keysList size = "+keysList.size());
				System.out.println("keysList size = "+valuesList.size());
			}
			int i = 0;
			try{
				
				if(index>-1){
					s = keysList.size();
					for(i=index;i<s;i++){			
						source = (CBECommonBaseEvent)keysList.get(i);			
						target = (CBECommonBaseEvent)valuesList.get(i);
						if(currentPageEvents.get(source)==null){
							break;
						}
						if(currentPageEvents.get(target)!=null){
							if (inExpandedList(source) && source!=thisSelection && target!=thisSelection) {
								createDummyMessage(source);
							} else {
								createAsyncMessage(source, target);
							}		
						}else{
							if(!inExpandedList(source) || (source==thisSelection)){
								createTargetOutOfPageMessage(source, target);
							}else{
								createDummyMessage(source);
							}				
						}
					}
				}
			}
			catch(Exception e){
				if(debug){	
					e.printStackTrace();
					System.out.println("outbound i = "+i);
				}
			}
		}
		//get inbound correlations
		try{
			if(inboundCorrelations==null || refresh){
				Query inBoundCorrelationsQuery = LogQueryBuilder.createInboundCorrelationQuery(agentsList, getFilterCriteria());
				((TimeBasedCorrelationQuery)inBoundCorrelationsQuery).setCorrelationContainerURI(correlationContainerURI.toString());
				inboundCorrelations = LogQueryBuilder.executeQuery(inBoundCorrelationsQuery, HierarchyResourceSetImpl.getInstance());
			}
		}catch(Exception e){
			if(debug)
				e.printStackTrace();
		}
		
		if(inboundCorrelations==null)
			return;
		
		resultEntry =(ResultEntry)inboundCorrelations.getResultEntries().get(0);
		valuesList = resultEntry.getObjects();
		resultEntry =(ResultEntry)inboundCorrelations.getResultEntries().get(1);
		keysList = resultEntry.getObjects();
		
		source = null;
		target = null;
		index = -1;
		s = currentPageList.size();
		
		//look for the first event in the current page contained in the correlation values list
		for(int i=0;i<s;i++){			
			target = (CBECommonBaseEvent)currentPageList.get(i);			
			index = valuesList.indexOf(target);
			if(index<0){
				continue;
			}else{
				break;
			}
		}
		
		if(debug){
			System.out.println("Index inbound = "+index);
			System.out.println("keysList size = "+keysList.size());
			System.out.println("valuesList size = "+valuesList.size());
		}

		int i = 0;
		try{
			if(index>-1){
				s = valuesList.size();
				for(i=index;i<s;i++){			
					source = (CBECommonBaseEvent)keysList.get(i);			
					target = (CBECommonBaseEvent)valuesList.get(i);
					if(currentPageEvents.get(target)==null){
						break;			
					}
					if(currentPageEvents.get(source)==null){
						createSourceOutOfPageMessage(source, target);
					}
				}
			}
		}catch(Exception e){
			if(debug){
				e.printStackTrace();
				System.out.println("inbound i = "+i);
			}
		}
	}
	
	protected void generateGraphNodes(){
		
		EObject key = null;
		CBECommonBaseEvent element = null;
		
		TraceLifeline lifeline = null;
		LogGraphNode node = null;
		LogGraphNode previousNode = null;
	
		int k = getMaxCurrentPageRangeIndex();
		int startPageIndex = currentPageIndex*PAGE_SIZE;
		int endPageIndex = currentPageIndex*PAGE_SIZE + k;
				
		for (int i=startPageIndex; i<endPageIndex; i++) {
			
			key = (EObject)eventsList.get(i);
			if(!(key instanceof CBECommonBaseEvent)){
				continue;
			}
			element = (CBECommonBaseEvent)key ;
			lifeline = (TraceLifeline)lifelinesMap.get(getLifelinesMapKey(element));
			if(graphNodes.get(element)==null){				
				node = createLogGraphNode(lifeline,element, previousNode);
				cacheLogGraphNode(node,element);
				previousNode = node;
			}			
		}
	}
	
	protected Object getLifelinesMapKey(CBECommonBaseEvent element){
		return element.getAgent().getAgentProxy();
	}
	
	protected void cacheLogGraphNode(LogGraphNode node,CBECommonBaseEvent element){
		
		if(correlationContainerProxy==null){
			return;
		}
		
		//CBECommonBaseEvent element = (CBECommonBaseEvent)node.getElement();		
		graphNodes.put(element, node);
	}
	
	protected void generateGraphConnectionsXMI(){

		if(correlationContainerProxy==null){
			return;
		}
		CBECommonBaseEvent source = null;
		List targetList = null;

		CorrelationEntryImpl entry = null;
		Object key = null;
 
		if (correlationContainerProxy==null || correlationContainerProxy.getCorrelationContainer()==null) return;
		EMap correlations  = correlationContainerProxy.getCorrelationContainer().getCorrelations();
		
		CBECommonBaseEvent target;		
		synchronized(correlations){
			for (Iterator iter = correlations.iterator(); iter.hasNext();) {
				entry = (CorrelationEntryImpl) iter.next();
				key = entry.getKey();
				
				if(!(key instanceof CBECommonBaseEvent)){
					continue;
				}
				source = (CBECommonBaseEvent)key;
				if (!isFilterApplied(source)) continue;
				targetList = (List)entry.getValue();
				if(targetList==null)
					continue;
				int s = targetList.size();
				for(int i = 0;i < s;i++){
					target = (CBECommonBaseEvent)targetList.get(i);
					if (!isFilterApplied(target)) continue;
					if(currentPageEvents.get(source)==null){	
						if(currentPageEvents.get(target)!=null){
								createSourceOutOfPageMessage(source, target);											
						}
					}else {
						if(currentPageEvents.get(target)!=null){
							if (inExpandedList(source) && source!=thisSelection && target!=thisSelection) {
								createDummyMessage(source);
							} else {
								createAsyncMessage(source, target);
							}		
						}else{
							if(!inExpandedList(source) || (source==thisSelection)){
								createTargetOutOfPageMessage(source, target);
							}else{
								createDummyMessage(source);
							}				
						}
					}
				}
			}
		}
	}

	private LogAsyncReturnMessage createDummyMessage(CBECommonBaseEvent source){
		
		LogGraphNode sourceNode = (LogGraphNode)graphNodes.get(source);
				
		LogAsyncReturnMessage message = getDummyMessage(source); 
 
		if(message!=null)
			return message;
				
		if(isInputXMI)	
			message = new LogAsyncReturnMessage(LogUIConstants.XMI);
		else
			message = new LogAsyncReturnMessage(LogUIConstants.SQL);
		
		message.setStartLifeline((TraceLifeline)lifelinesMap.get(getLifelinesMapKey(source)));
		message.setSource(source);
		message.setStartOccurrence(((LogGraphNode)graphNodes.get(source)).getStartOccurrence());
		frame.addMessage(message);
		dummyMessages.put(source,message);
		return message;
		
	}
	
	private SourceOutOfPageMessage createSourceOutOfPageMessage(CBECommonBaseEvent source, CBECommonBaseEvent target){
		
		SourceOutOfPageMessage message = getSourceMessage(target);
		List sources = null;
			
		if(message==null){				
			sources = new ArrayList();
			sources.add(source);
			message = new SourceOutOfPageMessage();
				
			message.setEndLifeline((TraceLifeline)lifelinesMap.get(getLifelinesMapKey(target)));
			LogGraphNode targetNode = (LogGraphNode)graphNodes.get(target);
			message.setEndOccurrence(targetNode.getEndOccurrence());
			((SourceOutOfPageMessage)message).setSource(sources);
			
			sourceOutOfPageMessages.put(target,message);			
				 
		}else{
			sources = ((SourceOutOfPageMessage)message).getSource();
			sources.add(source);
		}
				
		frame.addMessage(message);
		return message;

	}
	
	protected LogInteractionsFrame createPage(boolean refresh){
		
		
		if(currentPageIndex>pageCache.length-1 || refresh){
			frame = new LogInteractionsFrame();
		}else{		
			LogInteractionsFrame currentFrame = (LogInteractionsFrame)pageCache[currentPageIndex];
		
			if(currentFrame!=null){
				frame = currentFrame;
				cacheGraphNodes();
				cacheCurrentPageEvents();
				return frame;
			}else{
				frame = new LogInteractionsFrame();
			}
		}
		frame.setLifelineCategories(traceCategories);
		frame.forceEventOccurrenceSpacing(NODE_SIZE);
		clearTemporaryCaches();
		
		generateLifelines();
		cacheCurrentPageEvents();
		frame.setName(getFrameTitle());		
		generateDiagram(false);
		
		pageCache[currentPageIndex] = frame;
		
		return frame;
	}
	
	private void cacheCurrentPageEvents() {
		currentPageEvents.clear();
		int k = getMaxCurrentPageRangeIndex();
		
		int startPageIndex = currentPageIndex*PAGE_SIZE;
		int endPageIndex = currentPageIndex*PAGE_SIZE + k;
		
		if(endPageIndex>eventsList.size()){			
			currentPageIndex = 0;
			k = getMaxCurrentPageRangeIndex();			
			startPageIndex = 0;
			endPageIndex = k;
		}
		EObject element;
		for (int i=startPageIndex;i<endPageIndex;i++) {
			
			element = (EObject)eventsList.get(i);
			if(!(element instanceof CBECommonBaseEvent)){
				continue;
			}
			currentPageEvents.put(element,"");			
		}
	}
	
	
	protected String getFrameTitle(){
		return SDLogcPlugin.getString("STR_MENU_LOR")+ ":      " + getFrameName();
	}
	
	protected void generateLifelines(){
		for (Iterator iter = getLifelineArtifactsList().iterator(); iter.hasNext();) {
			TRCAgentProxy trcAgentProxy = (TRCAgentProxy) iter.next();
			TraceLifeline lifeLine = new TraceLifeline();
			lifeLine.setName(trcAgentProxy.getName());
			lifeLine.setCategory(CATEGORY_LOGS);
			lifelinesMap.put(trcAgentProxy, lifeLine);
			frame.addLifeLine(lifeLine);			
		}
	
	}
	
	protected List getLifelineArtifactsList(){
		return agentsList;
	}

	private int getMaxCurrentPageRangeIndex(){
		
		int r = totalSize%PAGE_SIZE;
		if(totalSize==0){
			return 0;
		}
		if(currentPageIndex+1<nrOfPages){
			return PAGE_SIZE;
		}else if(r==0){
			return PAGE_SIZE;
		}else{
			return r; 	
		}
	}
	
	protected LogGraphNode createLogGraphNode(TraceLifeline lifeline, CBECommonBaseEvent object, LogGraphNode previousNode){

		LogGraphNode node = null;
		if(previousNode!=null){
			if(((LogRecordComparator)(getComparator())).compareByTime(object,previousNode.getElement())==1){
			// different timestamp from previous
				node = new LogGraphNode(object);
				lifeline.setCurrentEventOccurrence(frame.getMaxEventOccurrence());
				node.setStartOccurrence(lifeline.getNewEventOccurrence());
				node.setEndOccurrence(lifeline.getNewEventOccurrence());
				node.setName(object.getMsg());
				lifeline.addExecution(node);	
				
				node.setStartTime(CBEUtils.computeAdjustedCreationTime(object)/TIME_CONVERSION_FACTOR);
				node.setEndTime(CBEUtils.computeAdjustedCreationTime(object)/TIME_CONVERSION_FACTOR);			

			}else{			
			// same timestamp as previous
				if((TraceLifeline)lifelinesMap.get(getLifelinesMapKey((CBECommonBaseEvent)previousNode.getElement()))==lifeline){
					// same lifeline  as previous
					if(!inExpandedList(object)){	
						// graph node, collapsed				
						previousNode.addElement(object);										
						node = previousNode;
						
						node.setName(TString.change(SDLogcPlugin.getString("STR_EXPAND_NODE"),"%1",""+node.getElements().size()));
						
						node.setEndTime(CBEUtils.computeAdjustedCreationTime(object)/TIME_CONVERSION_FACTOR);			
			
					}else{ 
						// graph node, expanded
						node = new LogGraphNode(object);
						node.setStartOccurrence(previousNode.getEndOccurrence()); //no space in between the previous node
						lifeline.setCurrentEventOccurrence(previousNode.getEndOccurrence());
						node.setEndOccurrence(lifeline.getNewEventOccurrence());
						node.setExpanded(true);
						node.setName(object.getMsg());
						lifeline.addExecution(node);
						
						LogGraphNode parentNode = getParentNode(object);
						parentNode.addElement(object);
						parentNode.setExpanded(true);
						parentNode.setBackgroundColor();
						
						node.setStartTime(CBEUtils.computeAdjustedCreationTime(object)/TIME_CONVERSION_FACTOR);
						node.setEndTime(CBEUtils.computeAdjustedCreationTime(object)/TIME_CONVERSION_FACTOR);			
					}
						

				}else{
					// different lifeline as previous
					List executions = lifeline.getExecutions();
					if (executions.size()>0) {
						LogGraphNode lastGraphNode = (LogGraphNode)executions.get(executions.size()-1);
						if (lastGraphNode!=null){
							if (((LogRecordComparator)(getComparator())).compareByTime(object,lastGraphNode.getElement())==1) {
								node = new LogGraphNode(object);
								node.setStartOccurrence(previousNode.getStartOccurrence());
								node.setEndOccurrence(previousNode.getEndOccurrence());
								node.setName(object.getMsg());
								lifeline.addExecution(node);		
								
								node.setStartTime(CBEUtils.computeAdjustedCreationTime(object)/TIME_CONVERSION_FACTOR);
								node.setEndTime(CBEUtils.computeAdjustedCreationTime(object)/TIME_CONVERSION_FACTOR);			
						
							}
							else {
								if(!inExpandedList(object)){
									// graph node, collapsed
									lastGraphNode.addElement(object);
									node = lastGraphNode;
									node.setName(TString.change(SDLogcPlugin.getString("STR_EXPAND_NODE"),"%1",""+node.getElements().size()));
									
									node.setEndTime(CBEUtils.computeAdjustedCreationTime(object)/TIME_CONVERSION_FACTOR);			

								}else{
									// graph node, expanded
									node = new LogGraphNode(object);
									node.setStartOccurrence(lastGraphNode.getEndOccurrence()); //no space in between the previous node
									lifeline.setCurrentEventOccurrence(lastGraphNode.getEndOccurrence());
									node.setEndOccurrence(lifeline.getNewEventOccurrence());
									node.setName(object.getMsg());
									node.setExpanded(true);
									lifeline.addExecution(node);

									LogGraphNode parentNode = getParentNode(object);
									parentNode.addElement(object);
									parentNode.setExpanded(true);
									parentNode.setBackgroundColor();
									
									node.setStartTime(CBEUtils.computeAdjustedCreationTime(object)/TIME_CONVERSION_FACTOR);
									node.setEndTime(CBEUtils.computeAdjustedCreationTime(object)/TIME_CONVERSION_FACTOR);												
								}
							}
						}
					}
					else {
						node = new LogGraphNode(object);
						node.setStartOccurrence(previousNode.getStartOccurrence());
						node.setEndOccurrence(previousNode.getEndOccurrence());
						node.setName(object.getMsg());
						lifeline.addExecution(node);
						
						node.setStartTime(CBEUtils.computeAdjustedCreationTime(object)/TIME_CONVERSION_FACTOR);
						node.setEndTime(CBEUtils.computeAdjustedCreationTime(object)/TIME_CONVERSION_FACTOR);			

					}
				}			
			}
		}else{
			// first element in the list
			node = new LogGraphNode(object);
			node.setStartOccurrence(lifeline.getNewEventOccurrence());
			node.setEndOccurrence(lifeline.getNewEventOccurrence());
			node.setName(object.getMsg());
			lifeline.addExecution(node);
			
			node.setStartTime(CBEUtils.computeAdjustedCreationTime(object)/TIME_CONVERSION_FACTOR);
			node.setEndTime(CBEUtils.computeAdjustedCreationTime(object)/TIME_CONVERSION_FACTOR);			

		}

		node.setBackgroundColor();
		
		return node;

	}
	
		
	private AsyncMessage createAsyncMessage(CBECommonBaseEvent source, CBECommonBaseEvent target){
		
		TraceLifeline sourceLifeline = (TraceLifeline)lifelinesMap.get(getLifelinesMapKey(source));
		TraceLifeline targetLifeline = (TraceLifeline)lifelinesMap.get(getLifelinesMapKey(target));

		LogGraphNode sourceNode = (LogGraphNode)graphNodes.get(source);
		LogGraphNode targetNode = (LogGraphNode)graphNodes.get(target);
		
		LogAsyncMessage message = null;
		
		if(isInputXMI){
			message = new LogAsyncMessage(LogUIConstants.XMI);
		}else{
			message = new LogAsyncMessage(LogUIConstants.SQL);
		}
		
		message.setStartLifeline(sourceLifeline);		
		message.setEndLifeline(targetLifeline);
		message.setStartOccurrence(sourceNode.getStartOccurrence());
		message.setEndOccurrence(targetNode.getStartOccurrence());
		message.setSourceNode(sourceNode);
		message.setTargetNode(targetNode);
		frame.addMessage(message);
		return message;
	}

	private TargetOutOfPageMessage createTargetOutOfPageMessage(CBECommonBaseEvent source, CBECommonBaseEvent target){
	
		TraceLifeline sourceLifeline = (TraceLifeline)lifelinesMap.get(getLifelinesMapKey(source));
		LogGraphNode sourceNode = (LogGraphNode)graphNodes.get(source);
		List targets = null;
		
		TargetOutOfPageMessage message = getTargetMessage(source);		
		if(message==null){				
			targets = new ArrayList();
			targets.add(target);
			message = new TargetOutOfPageMessage();
			
			message.setStartLifeline(sourceLifeline);
			message.setStartOccurrence(sourceNode.getEndOccurrence());
			
			((TargetOutOfPageMessage)message).setTarget(targets);
			targetOutOfPageMessages.put(source,message);
			frame.addMessage(message);			
			 
		}else{
			targets = ((TargetOutOfPageMessage)message).getTarget();
			targets.add(target);
		}
		
		return message;
	}
	
	protected void addEvents(TRCAgentProxy trcAgentProxy){

		eventsList.addAll(trcAgentProxy.getAgent().getDefaultEvents());
	}
	
	protected void cacheGraphNodes() {
		graphNodes.clear(); //clean up before creating a new one;
		
		TraceLifeline lifeline = null;
		for(int i=0; i<frame.getLifelines().size(); i++) {
			lifeline = (TraceLifeline)frame.getLifelines().get(i);
			for(int k=0; k<lifeline.getExecutions().size();k++){
				LogGraphNode graphNode = (LogGraphNode)lifeline.getExecutions().get(k);
				if (graphNode!=null) {
					if(graphNode.hasElements()){
					//check the children
						for (int j=0;j<graphNode.getElements().size();j++) {
							graphNodes.put(graphNode.getElements().get(j), graphNode);
						}
					} else // single node
						graphNodes.put(graphNode.getElement(), graphNode);						
				}
			}
		}
	}
	
	protected LogGraphNode getGraphNodeFromArtifact(CBECommonBaseEvent artifact){

		LogGraphNode graphNode=null;
		LogGraphNode source=null;
		source = (LogGraphNode)graphNodes.get(artifact);
		return source;
	}

	/**
	 * Implementation of ISelectionListener
	 */
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {

		if( part instanceof INavigator) {
			if (!((INavigator)part).isLinkingEnabled()) {
				return;
			}
		}
		
		if (view != null &&
			view.getSDWidget() != null &&
			!view.getSDWidget().isDisposed()) {			
			EObject sel = HyadesUtil.getMofObject();			
			if(sel!=null && sel!=inputObject) {	
				view.setFrame(parseModel(sel));
				disableMessageActions();
				Object viewSel = UIPlugin.getDefault().getSelectionModel(HyadesUtil.getMofObject()).getFirstElement();
				if (viewSel!=null && viewSel instanceof CBECommonBaseEvent)
					setSelection((CBECommonBaseEvent)viewSel);
				
			}
			else if (sel==null) {
				inputObject = sel;
				view.setFrame(new Frame());
			}
		}
	}

	/**
	 * Implementation of ISelectionChangedListener
	 */
	public void selectionChanged(SelectionChangedEvent e) {
		if (e.getSelection() == null ||
			(((IStructuredSelection)e.getSelection()).size() == 0)) {
			return;
		}
		Object sel = ((IStructuredSelection)e.getSelection()).getFirstElement();
		if(sel instanceof LogGraphNode){
			if ( view.getSDWidget().getViewControl().isFocusControl()) {
				//only update selection if the selection was made in the log interactions view, otherwise it is
				//an event from the log view, and should have been updated.
				CBECommonBaseEvent lastSelection = currentSelection;
				thisSelection = (CBECommonBaseEvent)((LogGraphNode)sel).getElement();
				if (thisSelection!=lastSelection
						&& (inExpandedList(thisSelection) || inExpandedList(lastSelection) )) {
					revealGraphConnections(thisSelection);					
					return;
				
				}
				currentSelection =(CBECommonBaseEvent)((LogGraphNode)sel).getElement();
				LogUtil.notifyViewSelectionChanged(this,currentSelection);
			}
			
			
		}
			
	}

	public boolean isDisplayingOnlyCorrelations(){
		return displayOnlyCorrelations;
	}
	/**
	 * Implementation of ISDGraphNodeSupporter
	 */
	public boolean isLifelineSupported() {
		return true;
	}
	public boolean isSyncMessageSupported() {
		return true;
	}
	public boolean isSyncMessageReturnSupported() {
		return true;
	}
	public boolean isAsyncMessageSupported() {
		return true;
	}
	public boolean isAsyncMessageReturnSupported() {
		return false;
	}
	public boolean isStopSupported() {
		return false;
	}
	
	/**
	 * implementation of ISDPagingProvider
	 */
	public boolean hasNextPage() {
		return currentPageIndex+1<nrOfPages;
	}
	
	public boolean hasPrevPage() {
		return 	currentPageIndex>0;
	}
	
	public void nextPage() {
		if(currentPageIndex+1<nrOfPages){
			++currentPageIndex;
			view.setFrame(createPage(false));
			disableMessageActions();
		}		
	}
	
	public void prevPage() {
		if(currentPageIndex>0){
			--currentPageIndex;
			view.setFrame(createPage(false));
			disableMessageActions();
		}			
	}
	
	protected void createPartition(){
		
	 	totalSize = eventsList.size();
		
		PAGE_SIZE = (int)SDLogcPlugin.getDefault().getPreferenceStore().getLong(SDLogcConstants.PAGE_SIZE);
		nrOfPages = totalSize%PAGE_SIZE > 0 ? totalSize/PAGE_SIZE + 1:totalSize/PAGE_SIZE;		
		if(nrOfPages==0){	
			pageCache = new Object[1];
		}else{
			pageCache = new Object[nrOfPages];
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader#getTitleString()
	 */
	public String getTitleString() {

		String title = SDLogcPlugin.getString("STR_VIEW_TITLE")+ ": " + SDLogcPlugin.getString("STR_MENU_LOR");
		if(correlationContainerProxy!=null){
			title = title +" <"+correlationContainerProxy.getCorrelationEngine().getName()+"> ";
		}
		return  title;
	
	}


	/* (non-Javadoc)
	 * @see org.eclipse.hyades.trace.ui.IViewSelectionChangedListener#handleViewSelectionChangedEvent(org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent)
	 */
	public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
		Object  source = event.getSource();
		if(source!=this){	
			Object sel = UIPlugin.getDefault().getSelectionModel(HyadesUtil.getMofObject()).getFirstElement();
			if (sel instanceof CBECommonBaseEvent)
				setSelection((CBECommonBaseEvent)sel);
		}
	}

	private void showCorrelationDialog() {
		
		LogCorrelationSelectionDialog logCorrelationSelectionDialog = new LogCorrelationSelectionDialog(null, CorrelationHelper.getInstance().getCorrelationExtensions());
		logCorrelationSelectionDialog.open();

		if (logCorrelationSelectionDialog.getReturnCode() == Window.OK) {

			setCorrelationType(logCorrelationSelectionDialog.getSelectedCorrelation());
			correlationContainerProxy = CorrelationHelper.getInstance().createCorrelationContainer(correlationType, inputObject, correlationType.getAttribute("name"));
			inputObject = correlationContainerProxy;
			LogUtil.selectInLogNavigator(correlationContainerProxy);
			
		}

	}

	public void setSelection(CBECommonBaseEvent sel){

		if(view==null)
			return;
		
		view.getSDWidget().clearSelection();
		if(eventsList!=null){
			int i = eventsList.indexOf(sel);
			int pageIndex=0;
			if(i>-1){			
				pageIndex = i/PAGE_SIZE;	
			}
			goToPage(pageIndex);
			LogGraphNode node = getGraphNodeFromArtifact(sel);
			
			CBECommonBaseEvent lastSelection = currentSelection;
			thisSelection = sel;
			if (thisSelection!=lastSelection
					&& (inExpandedList(thisSelection) || inExpandedList(lastSelection) )) {
				revealGraphConnections(thisSelection);					
			}
			else 
			{
				currentSelection = sel; //update before select in view
				view.setFrameAndEnsureVisible(this.frame,node);
				disableMessageActions();
				view.getSDWidget().addSelection(node);
			}
		}
				
	}
	
	private void goToPage(int page){
		
		currentPageIndex = page;		
		view.setFrame(createPage(false));
		disableMessageActions();
		view.updateCoolBar();
	}
	
	/**
	 * @return
	 */
	public IConfigurationElement getCorrelationType() {
		return correlationType;
	}

	/**
	 * @param element
	 */
	public void setCorrelationType(IConfigurationElement element) {
		correlationType = element;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFilterProvider#getFilterAction()
	 */
	public Action getFilterAction() {
		String STR_FILTER_RECORD =	SDLogcPlugin.getString("STR_FILTER_RECORD");
			Action advfilter = new Action(STR_FILTER_RECORD) {
				public void run() {
						filter();
				}
			};
			advfilter.setText(STR_FILTER_RECORD);
			advfilter.setDescription(STR_FILTER_RECORD);
			advfilter.setToolTipText(STR_FILTER_RECORD);
		return advfilter;	
	}

	public void filter() {
		FiltersDialog dialog = new FiltersDialog(
										view.getViewSite().getShell(),
										SDLogcPlugin.getString("STR_ST_FILTER_SETTINGS"),
										null,
										this,
										true);
		dialog.open();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFindProvider#getFindAction()
	 */
	public Action getFindAction() {
		String STR_FIND_RECORD = SDLogcPlugin.getString("STR_FIND_RECORD");
		Action searchRecord = new Action(STR_FIND_RECORD) {
			public void run() {
				find();
			}
		};
		searchRecord.setText(STR_FIND_RECORD);
		searchRecord.setDescription(STR_FIND_RECORD);
		searchRecord.setToolTipText(STR_FIND_RECORD);
		return searchRecord;
	}

	public void find() {
		dialog =	new SearchRecordDialog(
											view.getViewSite().getShell(),
											SDLogcPlugin.getString("STR_ST_FIND_SETTINGS"),
											null,
											this);
		initializeRecordSearchEngine();
		dialog.open();

	}
	

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.log.ui.internal.actions.provider.ILogFilterProvider#filterRecord(org.eclipse.hyades.log.ui.internal.actions.provider.LogFilterCriteria)
	 */
	public boolean filterRecord(ILogFilterCriteria criteria) {
		filterTableElements = criteria.getFilters();
		Map options = criteria.getFilterOptions();
		if(options!=null && options.get(ILogFilterCriteria.OPTION_ONLY_CORRELATED)!=null)
			displayOnlyCorrelations = options.get(ILogFilterCriteria.OPTION_ONLY_CORRELATED).equals("1")?true:false;
		generateLogInteractions(inputObject,false);
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.log.ui.internal.actions.provider.ILogFindProvider#findRecord(org.eclipse.hyades.log.ui.internal.actions.provider.LogFindCriteria)
	 */
	public boolean findRecord(LogFindCriteria criteria) {

		//Object sel = getRecordSearchEngine().search(criteria.getFilters(),criteria.isForwardDirection()?1:-1,currentSelection);
		Object sel = null;
		LogRecordSearch searchUtil = getRecordSearchEngine();
		if(isInputXMI){
			searchUtil.initStartNode(currentSelection, LogUIConstants.XMI);
			sel = searchUtil.search(criteria.getFilters(),criteria.isForwardDirection()?1:-1,currentSelection);
		}else{
			sel = searchUtil.search(query, criteria);
		}
		selectFindRecord(sel);
		return true;
	}
	
	public ILogFilterCriteria getFilterCriteria(){
		int s = 0;
		if(criteria==null){
			criteria = new LogFilterCriteria();
		}
		
		if(filterTableElements!=null)
		{
			s = filterTableElements.length;
			criteria.setFilters(filterTableElements);
			criteria.setSortColumns(new ISortElement[]{new SortElement(CBEPackage.eINSTANCE.getCBECommonBaseEvent_CreationTime().getName(), true), 
					new SortElement(CBEPackage.eINSTANCE.getCBECommonBaseEvent_SequenceNumber().getName(), true)});
		}
		else{
			criteria.setFilters(new IFilterElement[0]);
			criteria.setSortColumns(new ISortElement[]{new SortElement(CBEPackage.eINSTANCE.getCBECommonBaseEvent_CreationTime().getName(), true),
					new SortElement(CBEPackage.eINSTANCE.getCBECommonBaseEvent_SequenceNumber().getName(), true)});
		}
		return criteria;
	}
	
	
	public LogRecordSearch getRecordSearchEngine(){
		if(logRecordSearch==null){
			logRecordSearch = new LogRecordSearch();
		}
		return logRecordSearch;	 
	}

	private void initializeRecordSearchEngine(){
		
		Object start = getStartNode();
		
		if(logRecordSearch==null)
			logRecordSearch = new LogRecordSearch();
		
		if(isInputXMI)
			logRecordSearch.initialize(eventsList, start, LogUIConstants.XMI);
		else{ 
			logRecordSearch.initialize(eventsList, start, LogUIConstants.SQL);
		}
	}
	
	private Object getStartNode() {
		return currentSelection;
	}
	
	private void selectFindRecord(Object sel){
		if(sel==null){
			
			dialog.updateMessage(SDLogcPlugin.getString("STR_STRING_NOT_FOUND"));
			return;
		}
		setSelection((CBECommonBaseEvent)sel);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.log.ui.internal.actions.provider.ILogFindProvider#storeFindOptions(org.eclipse.hyades.log.ui.internal.actions.provider.LogFindCriteria)
	 */
	public boolean storeFindOptions(LogFindCriteria criteria) {
		FilterTableElement.saveFilters(criteria.getFilters(),SDLogcConstants.UML2SD_EXTEND_FIND_OPTIONS,SDLogcPlugin.getDefault().getPreferenceStore());
		SDLogcPlugin.getDefault().getPreferenceStore().setValue(SDLogcConstants.UML2SD_FIND_DIRECTION_OPTIONS, criteria.isForwardDirection()?"1":"-1");
		return true;
	}	/* (non-Javadoc)
	 * @see org.eclipse.hyades.log.ui.internal.actions.provider.ILogFindProvider#loadFindPreferenceString()
	 */
	public String loadFindPreferenceString() {
		IPreferenceStore store = SDLogcPlugin.getDefault().getPreferenceStore();
		return store.getString(SDLogcConstants.UML2SD_EXTEND_FIND_OPTIONS);
	}	/* (non-Javadoc)
	 * @see org.eclipse.hyades.log.ui.internal.actions.provider.ILogFindProvider#loadFindDirection()
	 */
	public boolean loadFindDirection() {
		return SDLogcPlugin.getDefault().getPreferenceStore().getString(SDLogcConstants.UML2SD_FIND_DIRECTION_OPTIONS).equals("1");
	}	/**
	 * @return
	 */
	private SourceOutOfPageMessage getSourceMessage(CBECommonBaseEvent event) {
		if(sourceOutOfPageMessages==null){
			sourceOutOfPageMessages = new HashMap();
		}
		return (SourceOutOfPageMessage)sourceOutOfPageMessages.get(event);
	}

	/**
	 * @return
	 */
	private TargetOutOfPageMessage getTargetMessage(CBECommonBaseEvent event) {
		if(targetOutOfPageMessages==null){
			targetOutOfPageMessages = new HashMap();
		}		
		return (TargetOutOfPageMessage)targetOutOfPageMessages.get(event);
	}
	
	private LogAsyncReturnMessage getDummyMessage(CBECommonBaseEvent event){
		if(dummyMessages==null){
			dummyMessages = new HashMap();
		}		
		return (LogAsyncReturnMessage)dummyMessages.get(event);

	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.trace.ui.IProfileEventListener#handleProfileEvent(org.eclipse.hyades.trace.ui.ProfileEvent)
	 */
	public void handleProfileEvent(ProfileEvent event) {
		if ((event.getType() == ProfileEvent.REFRESH_VIEWS || event.getType() == ProfileEvent.UPDATE_MODEL) && event.getSource() instanceof EObject) {
			refresh();
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#currentPage()
	 */
	public int currentPage() {
		if(nrOfPages==0)
			return -1;
		
		return currentPageIndex;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#itemsText()
	 */
	public String itemsText() {
		
		return SDLogcPlugin.getString("STR_ITEMS");
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#itemsTotalCount()
	 */
	public int itemsTotalCount() {
		
		return eventsList.size();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#maxItemsByPageCount()
	 */
	public int maxItemsByPageCount() {
		
		return PAGE_SIZE;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#noItemsText()
	 */
	public String noItemsText() {
				
		return SDLogcPlugin.getString("STR_ITEMS");
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#oneItemText()
	 */
	public String oneItemText() {
		
		return SDLogcPlugin.getString("STR_ITEM");
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#pagesCount()
	 */
	public int pagesCount() {
		
		return nrOfPages;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#pageSettingsChanged(int, int)
	 */
	public void pageSettingsChanged(int maxItemsByPage_, int pageNumber_) {
		
		if(0<=pageNumber_ && pageNumber_<nrOfPages){
			goToPage(pageNumber_);
		}
		if(maxItemsByPage_>MAX_NR_OF_RECORDS){
			maxItemsByPage_ = MAX_NR_OF_RECORDS;		
		}
		if(PAGE_SIZE!=maxItemsByPage_){	
			SDLogcPlugin.getDefault().getPreferenceStore().setValue(SDLogcConstants.PAGE_SIZE, maxItemsByPage_);
			PAGE_SIZE = maxItemsByPage_;
		}

		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider#pageNumberChanged(int)
	 */
	public void pageNumberChanged(int pageNumber_) {
		goToPage(pageNumber_);
		
	}

	public CorrelationContainerProxy getCorrelationContainerProxy() {
		return correlationContainerProxy;
	}

	public String getFrameName() {

		return MessageFormat.format(SDLogcPlugin.getString("STR_PAGE_INFO"),  new String[] {String.valueOf(currentPage()+1), String.valueOf(nrOfPages)});		
		
	}

	public void applyPreferences() {
		view.setFrame(parseModel(inputObject));
		disableMessageActions();
	}
	
	public void preserveSelection(CBECommonBaseEvent selection){
		
		if(selection==null)
			return;
		view.getSDWidget().clearSelection();
		LogGraphNode selNode = (LogGraphNode)this.graphNodes.get(selection);
		if(selNode!=null){
			currentSelection = selection;
			view.setFrameAndEnsureVisible(this.frame,selNode);
			disableMessageActions();
			view.getSDWidget().addSelection(selNode);	
		}
		
	}
	
	
	public void collapseLogGraphNode(List graphNodes){		
		LogGraphNode node = null;
		for (int i=0;i<graphNodes.size();i++) {
			node = (LogGraphNode) graphNodes.get(i);
			removeFromExpandedList(node);
		}

		node = (LogGraphNode)graphNodes.get(0);
		CBECommonBaseEvent sel = (CBECommonBaseEvent)node.getElement();
		pageCache[currentPageIndex] = null;
		view.setFrame(createPage(false));
		disableMessageActions();
		preserveSelection(sel);
	}

	public void expandLogGraphNode(List graphNodes){		
		LogGraphNode node = null;
		int s = graphNodes.size();
		for (int i=0;i<s;i++) {
			node = (LogGraphNode) graphNodes.get(i);
			addToExpandedList(node);
		}
		
		node = (LogGraphNode)graphNodes.get(0);
		CBECommonBaseEvent sel = (CBECommonBaseEvent)node.getElement();
		pageCache[currentPageIndex] = null;
		view.setFrame(createPage(false));
		disableMessageActions();
		preserveSelection(sel);

	}
	
	public LogGraphNode getParentNode(CBECommonBaseEvent event) {
		TraceLifeline eventLifeLine = (TraceLifeline)lifelinesMap.get(getLifelinesMapKey(event));
		for (int i=0;i<expandedList.size();i++) {
			CBECommonBaseEvent parent = (CBECommonBaseEvent)expandedList.get(i);
			if (currentPageEvents.get(parent)==null) continue; //make sure the parent is in the same page
			if (((LogRecordComparator)(getComparator())).compareByTime(event,parent)==0 &&
					eventLifeLine ==(TraceLifeline)lifelinesMap.get(getLifelinesMapKey(parent)) ) {
				return (LogGraphNode)graphNodes.get(parent);
			}
		}
		return null;
	}
	
	public boolean inExpandedList(CBECommonBaseEvent event) {
		if (event==null) return false;
		return (getParentNode(event)!=null);
	}
	
	public void addToExpandedList(LogGraphNode node) {
		expandedList.add(node.getElement());
	}
	
	public void removeFromExpandedList(LogGraphNode node) {
		if(node.hasElements())
			expandedList.remove(node.getElement());
		else{	
			CBECommonBaseEvent parent = (CBECommonBaseEvent)getParentNode((CBECommonBaseEvent)node.getElement()).getElement();
			if(parent!=null)	
				expandedList.remove(parent);
		}
	}
	
	public QueryResult getCorrelations(){
		return outBoundCorrelations;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.jobs.IJobChangeListener#aboutToRun(org.eclipse.core.runtime.jobs.IJobChangeEvent)
	 */
	public void aboutToRun(IJobChangeEvent event) {
		// TODO Auto-generated method stub

	}
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.jobs.IJobChangeListener#awake(org.eclipse.core.runtime.jobs.IJobChangeEvent)
	 */
	public void awake(IJobChangeEvent event) {
		// TODO Auto-generated method stub

	}
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.jobs.IJobChangeListener#done(org.eclipse.core.runtime.jobs.IJobChangeEvent)
	 */
	public void done(IJobChangeEvent event) {
		if(event.getJob() instanceof CorrelationHelper.CorrelationJob && ((CorrelationHelper.CorrelationJob)event.getJob()).getContainer()==inputObject){
			Display.getDefault().asyncExec(new Runnable()
				{
					public void run()
					{
						refresh();						
						CBECommonBaseEvent sel = (CBECommonBaseEvent)UIPlugin.getDefault().getSelectionModel(inputObject).getFirstElement();
						if(sel!=null){
								setSelection(sel);
						}
					}
				});
		}
		
	}
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.jobs.IJobChangeListener#running(org.eclipse.core.runtime.jobs.IJobChangeEvent)
	 */
	public void running(IJobChangeEvent event) {
		// TODO Auto-generated method stub

	}
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.jobs.IJobChangeListener#scheduled(org.eclipse.core.runtime.jobs.IJobChangeEvent)
	 */
	public void scheduled(IJobChangeEvent event) {
		// TODO Auto-generated method stub

	}
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.jobs.IJobChangeListener#sleeping(org.eclipse.core.runtime.jobs.IJobChangeEvent)
	 */
	public void sleeping(IJobChangeEvent event) {
		// TODO Auto-generated method stub

	}
	
	private void revealGraphConnections(CBECommonBaseEvent selection){
		
		pageCache[currentPageIndex] = null;
		view.setFrame(createPage(false));
		disableMessageActions();
		preserveSelection(selection);		
	}
	
	private void disableMessageActions() {
		view.setEnableCommand("org.eclipse.hyades.uml2sd.ui.actions.GoToCalled",false);
		view.setEnableCommand("org.eclipse.hyades.uml2sd.ui.actions.GoToCaller",false);
		view.setEnableAction("org.eclipse.hyades.uml2sd.ui.actions.ShowStatTable",false);
	}

	private List getCurrentPageEventsList(){
		int k = getMaxCurrentPageRangeIndex();
		
		int startPageIndex = currentPageIndex*PAGE_SIZE;
		int endPageIndex = currentPageIndex*PAGE_SIZE + k;
		
		if(endPageIndex>eventsList.size()){
			k = getMaxCurrentPageRangeIndex();			
			startPageIndex = 0;
			endPageIndex = k;
		}
		return eventsList.subList(startPageIndex, endPageIndex);
	}
	
}


