/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Correlation Engine</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The id should uniquely identify the engine.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.CorrelationEngine#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.CorrelationEngine#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.CorrelationEngine#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.CorrelationEngine#getCorrelationContainerProxy <em>Correlation Container Proxy</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationEngine()
 * @model 
 * @generated
 */
public interface CorrelationEngine extends EObject{
	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Engines are typed with this attribute. Examples of types are 
	 * "Correlation based on URI", "root"
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see #setType(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationEngine_Type()
	 * @model 
	 * @generated
	 */
	String getType();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.CorrelationEngine#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see #getType()
	 * @generated
	 */
	void setType(String value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Each engine has a name. This is not ensured to be unique. The name is intended to be human readable.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationEngine_Name()
	 * @model 
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.CorrelationEngine#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The id of an engine is something that uniquely identifes the engine from all other engines installed.
	 * The uniqueness is managed outside the model and is the responsibility of the engine provider.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationEngine_Id()
	 * @model 
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.CorrelationEngine#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Correlation Container Proxy</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy#getCorrelationEngine <em>Correlation Engine</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Correlation Container Proxy</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Correlation Container Proxy</em>' container reference.
	 * @see #setCorrelationContainerProxy(CorrelationContainerProxy)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationEngine_CorrelationContainerProxy()
	 * @see org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy#getCorrelationEngine
	 * @model opposite="correlationEngine"
	 * @generated
	 */
	CorrelationContainerProxy getCorrelationContainerProxy();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.CorrelationEngine#getCorrelationContainerProxy <em>Correlation Container Proxy</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Correlation Container Proxy</em>' container reference.
	 * @see #getCorrelationContainerProxy()
	 * @generated
	 */
	void setCorrelationContainerProxy(CorrelationContainerProxy value);

} // CorrelationEngine
