/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.editors;

import org.eclipse.hyades.models.internal.sdb.*;
import org.eclipse.hyades.sdb.internal.*;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.graphics.*;

public class DBLabelProvider extends LabelProvider
{

/**
 * Returns the image to display for the passed resource element.
 * NOTE: The resource label provider caches its images, so don't
 * dispose them!
 */
public Image getImage(Object element)
{
	if(element instanceof SDBRuntime)
	  return SDbPluginImages.getImage(SDbPluginImages.IMG_SYMPTOM_DB);
	  
	if(element instanceof SDBSymptom)
	  return SDbPluginImages.getImage(SDbPluginImages.IMG_SYMPTOM_DESC);
  	
	if(element instanceof SDBSolution)
	  return SDbPluginImages.getImage(SDbPluginImages.IMG_SYMPTOM_SOL);
	
	if(element instanceof SDBDirective)
	  return SDbPluginImages.getImage(SDbPluginImages.IMG_SYMPTOM_DIRECTIVE);
	  
	
	return null;
}
/* (non-Javadoc)
 * Method declared on ILabelProvider.
 */
public String getText(Object element)
{
	String name = SDbPlugin.getResourceString("STR_DEFAULT_NAME_LABEL");
	
	if(element instanceof SDBRuntime)
	  name = ((SDBRuntime)element).getName();
	else if(element instanceof SDBSymptom)
	{
	  name = ((SDBSymptom)element).getDescription();
	  name = TString.replaceTabsWithWhiteSpace(truncateString(name));
	}
	else if(element instanceof SDBSolution)
	{		
	  name = ((SDBSolution)element).getDescription();
	  name = TString.replaceTabsWithWhiteSpace(truncateString(name));
	}
	else if(element instanceof SDBDirective)
	{
	  name = ((SDBDirective)element).getDescription();
	  name = TString.replaceTabsWithWhiteSpace(truncateString(name));
	}
	  
	return name;
}

private String truncateString(String name){

	int idx = name.indexOf("\r\n", 0);
	if(idx != -1)
		name = name.substring(0, idx);
	else{
	 idx = name.indexOf("\n");
	 if(idx != -1)
	 	name = name.substring(0, idx);
	}
	 
		  	
	return name;
}

}
