/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.editors;

import org.eclipse.emf.ecore.*;
import org.eclipse.hyades.models.internal.sdb.*;
import org.eclipse.hyades.sdb.internal.util.*;
import org.eclipse.swt.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class DetailsContent extends Composite {

	StackLayout detailsLayout;
	Composite details;
	DBDetails dbDetails;
	SymptomDetails symptoms;
	SolutionDetails solutions;
	DirectiveDetails directives;
	Composite composite;
	RASWidgetFactory factory;
	SymptomDBEditor editor;

	/**
	 * Constructor for DetailsContent.
	 */
	public DetailsContent(RASWidgetFactory factory, Composite composite, int style) {
		super(composite, style);
		this.composite = composite;
		this.factory = factory;		
	}
	
	public Composite createContent(){
		
		detailsLayout = new StackLayout();
	    this.setLayout(detailsLayout);
	    GridData detailsGrid = new GridData(GridData.FILL_BOTH);
	    detailsGrid.horizontalIndent = 10;
	    this.setLayoutData(detailsGrid);
	    dbDetails = new DBDetails(factory, this, SWT.NONE);
	    symptoms = new SymptomDetails(factory, this, SWT.NONE);
	    solutions = new SolutionDetails(factory, this, SWT.NONE);
	    directives = new DirectiveDetails(factory, this, SWT.NONE);
        hideDetails();
        return details;				
	}

  public void init(SymptomDBEditor editor){
     this.editor = editor;
	 dbDetails.init(editor);
	 symptoms.init(editor);
	 solutions.init(editor);
	 directives.init(editor);
  }
   
   public void showDetailsFor(EObject data){

   		if(data instanceof SDBRuntime)
   			showDetail(dbDetails, data);   		
   		if(data instanceof SDBSymptom)
   			showDetail(symptoms, data);
   		else if(data instanceof SDBSolution)	
   			showDetail(solutions, data);
   		else if (data instanceof SDBDirective)
   			showDetail(directives,data);

   };
   
   public void setFocusFor(Object object){
   		
   		if(object instanceof SDBRuntime)
   			 dbDetails.setFocusToTextBox();
   		if(object instanceof SDBSymptom)
   			 symptoms.setFocusToTextBox();
   		else if(object instanceof SDBSolution)	
   			solutions.setFocusToTextBox();
   		else if (object instanceof SDBDirective)
   			directives.setFocusToTextBox();
   }
   
   public void setFocusFor(Object object, int startIndex, int endIndex){
	
	if(object instanceof SDBRuntime)
		 dbDetails.setFocusToTextBox(startIndex, endIndex);
	else if(object instanceof SDBSymptom)
		 symptoms.setFocusToTextBox(startIndex, endIndex);
	else if(object instanceof SDBSolution)	
		solutions.setFocusToTextBox(startIndex, endIndex);
	else if (object instanceof SDBDirective)
		directives.setFocusToTextBox(startIndex, endIndex);
   }   
   
   public int getCursorPositionFor(Object object)
   {
	if(object instanceof SDBRuntime)
		return dbDetails.getCursorPosition();
	else if(object instanceof SDBSymptom)
		return symptoms.getCursorPosition();
	else if(object instanceof SDBSolution)	
		return solutions.getCursorPosition();
	else if (object instanceof SDBDirective)
		return directives.getCursorPosition();
	else
		return 0;
   }
   
   public boolean updateCurrentSelection(EObject sel){
   		
   		if(sel instanceof SDBRuntime)
   			 return dbDetails.updateCurrentSelection(sel);
   		if(sel instanceof SDBSymptom)
   			 return symptoms.updateCurrentSelection(sel);
   		else if(sel instanceof SDBSolution)	
   			return solutions.updateCurrentSelection(sel);
   		else if (sel instanceof SDBDirective)
   			return directives.updateCurrentSelection(sel);
   			
   		return false;	   			
   }
   
   private void hideDetails(){
		dbDetails.setVisible(false);
	    symptoms.setVisible(false);
	    solutions.setVisible(false);
	    directives.setVisible(false);
   }
   
   private void showDetail(Control detail, EObject data){
   		((IDetails)detail).display(data);
   		detailsLayout.topControl = (Control)detail;
   		layout();
   }
   
   protected void updateRegistry(EObject object, boolean add){
		if(object instanceof SDBSolution)
			solutions.updateSolutionRegistry((SDBSolution)object, add);
		else if(object instanceof SDBDirective)
			directives.updateDirectiveRegistry((SDBDirective)object, add);		
		
   }
}
