/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.views.internal.*;
import org.eclipse.jface.action.*;
import org.eclipse.swt.widgets.*;


/*
* CONTEXT_ID clst0000 for Execution Statistic view
*/

/**
 * Insert the type's description here.
 * Creation date: (06/14/2000 12:34:21 PM)
 * @author: Administrator
 */
public class InvocationTablePage extends TraceViewerPage
{
	protected MethodInvocationStatistic _view;

public InvocationTablePage(EObject mofObject, TraceViewer _viewer)
{
	super(mofObject, _viewer);
}
/**
 * Insert the method's description here.
 * Creation date: (06/14/2000 12:38:21 PM)
 * @return com.ibm.swt.widgets.Control
 * @param parent com.ibm.swt.widgets.Composite
 */
public void createControl(Composite parent)
{
	_view = new MethodInvocationStatistic(parent, this);
	
	setContextMenu(_view.getTable(), _view.getTableViewer());	
	makeActions();
	
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
	this.getControl(),
	TraceUIPlugin.getPluginId()+".clst0000");
}
/**
 * @see IPage#dispose
 */
public void dispose()
{
	if(_view != null && _view.getControl() != null)
		super.dispose();
		
	if(_view != null)
	  _view.dispose();
				  
	_mofObject = null;  
	_view = null;
	
}
/**
 * Returns the SWT control for this page
 *
 * @return the SWT control for this page
 */
public Control getControl() {
//	System.out.println("invocationtablepage - getcontrol");
	return _view.getControl();
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 3:12:27 PM)
 * @return com.ibm.etools.trace.views.ExecutionStatistic
 */
public MethodInvocationStatistic getView() {
	return _view;
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 2:54:24 PM)
 */
public void makeActions()
{
	_viewer.makeActions();
}
public Action percentMode() {
	return ((InvocationTableViewer)_viewer).percentMode();
}
/**
 * Insert the method's description here.
 * Creation date: (8/1/2001 6:31:38 PM)
 * @return org.eclipse.jface.action.Action
 */
public Action openSource() {
	return ((InvocationTableViewer)_viewer).openSource();
}

public Action baseTime() {
	return((InvocationTableViewer)_viewer).baseTime();
}

public Action rawTime() {
	return((InvocationTableViewer)_viewer).rawTime();
}

/**
 * Insert the method's description here.
 * Creation date: (6/5/2001 2:45:25 PM)
 */
public void refreshPage()
{
//	System.out.println("invocationtablepage - refreshpage");
	getView().refresh();
}
/**
 * Insert the method's description here.
 * Creation date: (6/5/2001 2:45:25 PM)
 */
public void selectionChanged()
{
	getView().selectionChanged();
}
/**
 * Sets focus to a part in the page.
 */
public void setFocus() {
	_view.getControl().setFocus();
	_view.showNewSelection();
}
/**
 * Insert the method's description here.
 * Creation date: (08/14/2000 5:50:25 PM)
 */
public void update(boolean newPage)
{
	if(newPage)
		_view.updateUI(_view.getColumnDataList());
}

/**
 * Contribute to the view popup menu
 * @param menu
 */
public void fillContextMenu(IMenuManager menu)
{	
	if(_view != null)
	{
		_view.menuAboutToShow(menu);
	}
}

public boolean isEmpty()
{
	return _view.isEmpty();
}

}
