/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

public class TraceConstants {

	/**
	 * RGB colors for displaying graph colors
	 */
	public static final String BACKGROUND_RGB= "background_rgb";
	public static final String SELECTION_RGB= "selection_rgb";
	public static final String UNKNOWN_RGB= "unknown_rgb";
	public static final String CLASSES_RGB= "classes_rgb";

	public static final String BACKGROUND_OPTION= "bg_option";
	public static final String BACKGROUND_DEFAULT= "system_default";	
	public static final String BACKGROUND_CUSTOM= "bg_custom";
	public static final String CLASSES_OPTION= "class_option";	
	public static final String CLASS_ONE_COLOR= "class_one_color";
	public static final String CLASS_DEFAULT_COLOR= "class_default_color";

    public static final String OBJ_REF_OPTION = "obj_ref_display";
    public static final String TIME_OPTION = "time_display";
    
    public static final int OBJ_REF_REFERANDS = 0;	
    public static final int OBJ_REF_REFEREES = 1;	
   
    public static final int COMPENSATED_TIME = 0;	
    public static final int RAW_TIME = 1;	
    
	/**
	 * The name of the font to use for the graph views
	 **/
	public static final String GRAPH_FONT= "graph.font";
	
	public static final String PERCENTAGE= "percent";
	public static final String DELTA= "delta";
	
	public static final String VIEW_OPTION = "viewoption.";
	public static final String METHOD_STATS_VIEW = VIEW_OPTION + "method";
	public static final String CLASS_INSTANCE_STATS_VIEW = VIEW_OPTION + "classinstance";
	public static final String CLASS_STATS_VIEW = VIEW_OPTION + "class";	
	public static final String COVERAGE_STATS_VIEW = VIEW_OPTION + "coverage";	
	public static final String EXECUTION_STATS_VIEW = VIEW_OPTION + "execution";	
	public static final String METHOD_INVOCATION_STATS_VIEW = VIEW_OPTION + "methodinvocation";	
	public static final String PACKAGE_STATS_VIEW = VIEW_OPTION + "package";
	public static final String REFERENCE_VIEW = VIEW_OPTION + "reference";
	
}
