/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.recorder.local.appadapters;

/**
 * This object provides the client side functionality for the internet explorer Application adapter.
 * associated with extension point org.eclipse.hyades.execution.recorder.RecorderApplication
 * 
 * @author Ernest Jessee
 */
public class InternetExplorerAdapterClient implements IRecorderApplicationAdapterClient
{
	
	/**
	 * stores the initialization string which will be passed to the agent side adapter object at runtime
	 */
	private String initString = null;
	
	
	/**
	 * called by the recorder to acquire the adapters init string for passing to the agent side of the rac
	 */
	public String getInitString()
	{
		return initString;
	}

	
	/**
	 * used for external objects to set the adapters initialization String
	 * @param String initString - a semi-colon delimeted collection of comma delimeted name-value pairs (host,localhost;port,450)
	 */
	public void setInitString(String initString)
	{
		this.initString = initString;
	}

}
