/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.logc;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * The main plugin class to be used in the desktop.
 */
public class SDLogcPlugin extends AbstractUIPlugin {
	/**
	 * The shared instance.
	 */
	private static SDLogcPlugin plugin;
	/**
	 * Resource bundle.
	 */
	private ResourceBundle resourceBundle;
	
	/**
	 * The constructor.
	 */
	public SDLogcPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		
		try {
			resourceBundle = getDescriptor().getResourceBundle();
		} catch (MissingResourceException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Returns the shared instance.
	 */
	public static SDLogcPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle= SDLogcPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	
	public static String getString(String key) {
		return getResourceString(key);
	}
	
	/**
	 * Logs an exception in Eclipse's .log file.
	 * @param e The exception to log.
	 */
	public static void log(Throwable e) { 
		String msg = e.getMessage();
		getDefault().getLog().log(new Status(IStatus.ERROR, getPluginId(), IStatus.ERROR, msg == null ? "" : msg, e));							
	}
	
	protected void initializeDefaultPreferences(IPreferenceStore store) {
		store.setDefault(SDLogcConstants.UML2SD_EXTEND_FILTER_OPTIONS, "");
		store.setDefault(SDLogcConstants.UML2SD_EXTEND_FIND_OPTIONS, "");
		store.setDefault(SDLogcConstants.UML2SD_FIND_DIRECTION_OPTIONS, "1");
		store.setDefault(SDLogcConstants.PAGE_SIZE, 500);
	}
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.Plugin#shutdown()
	 */
	public void shutdown() throws CoreException {
		SDLogcPluginImages.shutdown();
		super.shutdown();
	}

	public static String getPluginId() {
		return getDefault().getDescriptor().getUniqueIdentifier();
	}
}
