/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.sd.logc.internal.actions;

import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogGraphNode;

/**
 * Action delegate for 'Collapse' on a group of log records
 */
public class LogGraphNodeCollapseAction extends LogGraphNodeAction {

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.actions.internal.TraceGraphNodeAction#run(org.eclipse.hyades.uml2sd.trace.loaders.TraceInteractions)
	 */
	public void run(LogInteractions loader) {
		loader.collapseLogGraphNode(graphNodes);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.sd.logc.internal.actions.LogGraphNodeAction#isObjectValid(org.eclipse.hyades.sd.logc.internal.uml2sd.LogGraphNode)
	 */
	protected boolean isObjectValid(LogGraphNode o) {
		return o.isExpanded();
	}
}
