/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.logc.internal.actions;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.util.LogUtil;
import org.eclipse.hyades.logc.internal.util.CorrelationHelper;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.sd.logc.SDLogcConstants;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;


public class OpenTimeBaseUML2SDViewAction  implements IObjectActionDelegate {

	private final String corrName = SDLogcPlugin.getString("CORR_NAME");
	private CBECommonBaseEvent cbeEvent;

	public void run() {
		//System.out.println("OpenSDViewAction.run");
		IWorkbenchWindow window =
		SDLogcPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();

		try {
			IWorkbenchPage persp = UIPlugin.getActivePage();

			SDView view = view = (SDView) persp.showView(SDLogcConstants.LogInteractionsViewID); //$NON-NLS-1$;
			LoadersManager.getLoadersManager().createLoader("org.eclipse.hyades.sd.logc.internal.loader.LogInteractions", getClass().getClassLoader(), view);
			EObject sel = HyadesUtil.getMofObject();
			LogInteractions loader = (LogInteractions)LoadersManager.getLoadersManager().getCurrentLoader(SDLogcConstants.LogInteractionsViewID);
			loader.generateLogInteractions(sel,CorrelationHelper.getInstance().getCorrelationByName(getcorrName()));
			LogUtil.selectInLogNavigator(loader.getCorrelationContainerProxy());
	
			UIPlugin.getDefault().getSelectionModel(loader.getCorrelationContainerProxy()).add(cbeEvent);
			LogUtil.notifyViewSelectionChanged(loader,cbeEvent);
			
		} catch (Exception e) {
			String msg = SDLogcPlugin.getString("STR_LOAD_SD_ERR_");

			Status err =
				new Status(
					Status.WARNING,
					ResourcesPlugin.PI_RESOURCES,
					IResourceStatus.INTERNAL_ERROR,
					e.toString(),
					null);

			ErrorDialog.openError(window.getShell(), msg, "",err);

			e.printStackTrace();
		}
	}
	
	public String getcorrName() {
		return corrName;
	}
	
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {}

	public void run(IAction action) {
		run();
	}

	public void selectionChanged(IAction action, ISelection selection) {
		if (selection != null && ((IStructuredSelection)selection).getFirstElement() instanceof CBECommonBaseEvent) {
				cbeEvent = (CBECommonBaseEvent)(((IStructuredSelection)selection).getFirstElement());
		}
		else
		{
			cbeEvent = null;
		}
	}
	
}

