/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.statistical;

import java.util.Map;

import org.eclipse.hyades.loaders.util.GenericLookupService;
import org.eclipse.hyades.model.statistical.SDDescriptor;
/**
 * @author slavescu
 */
public class StatisticalLookupService extends GenericLookupService {
	//~ Constructors
	// -------------------------------------------------------------------------------

	public StatisticalLookupService() {
		super();
		types.add(SDDescriptor.class);
//		types.add(SDSampleDescriptorImpl.class);
//		types.add(SDCounterDescriptorImpl.class);
	}

	//~ Methods
	// ------------------------------------------------------------------------------------

	protected boolean doProcessObject(
		Map typeMap,
		Class type,
		Object object,
		boolean remove) {
		if (object == null) {
			return false;
		}
		if(object instanceof SDDescriptor)
		{	
				addOrRemove(
					typeMap,
					((SDDescriptor) object).getId(),
					object,
					remove);

				return true;
		}
		
		return false;
	}
	
	protected Class getEquivalentClass(Class type) {
		if(SDDescriptor.class.isAssignableFrom(type))
			return SDDescriptor.class;
		return type;
	}
	
}
