/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.java.internal.junit.wizard;

import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.test.common.TestCommon;
import org.eclipse.hyades.test.common.internal.wizard.TestSuiteNewWizard;
import org.eclipse.hyades.test.java.TestJavaImages;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.AttributeWizardPage;
import org.eclipse.hyades.ui.internal.wizard.LocationPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * Extends the HyadesNewWizard to create the JUnit Test Suite.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class JUnitTestSuiteNewWizard 
extends TestSuiteNewWizard
{
	/**
	 * Constructor for TestSuiteNewWizard
	 */
	public JUnitTestSuiteNewWizard()
	{
		super();
		setWindowTitle(TestJavaPlugin.getString("WIZ_JUNIT_TST_SUITE_TTL"));
		setDefaultPageImageDescriptor(TestJavaImages.INSTANCE.getImageDescriptor(TestJavaImages.IMG_WIZBAN_NEW_JUNIT_TESTSUITE));

		IDialogSettings dialogSettings = TestJavaPlugin.getInstance().getDialogSettings();
		IDialogSettings settings = dialogSettings.getSection("JUnitTestSuiteNewWizard");
		if(settings == null)
			settings = dialogSettings.addNewSection("JUnitTestSuiteNewWizard");
		setDialogSettings(settings);
	}

	/**
	 * Returns the type for the test suite created by this wizard.
	 * @return String
	 */
	protected String getType()
	{
		return TestCommon.JUNIT_TEST_SUITE_TYPE;
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		getLocationPage().setTitle(TestJavaPlugin.getString("WIZ_NEW_JUNIT_TST_SUITE_PG_TTL"));
		getLocationPage().setDescription(TestJavaPlugin.getString("WIZ_TST_SUITE_GEN_PG_LOC_DSC"));
		
		getAttributeWizardPage().setTitle(TestJavaPlugin.getString("WIZ_NEW_JUNIT_TST_SUITE_PG_TTL"));
		getAttributeWizardPage().setDescription(TestJavaPlugin.getString("WIZ_NEW_JUNIT_TST_SUITE_PG_ATT_DSC"));
		
		super.addPages();
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
	 */
	protected void initPages()
	{
		IStructuredSelection structuredSelection = adjustSeletion();
		
		LocationPage locationPage = new LocationPage("location", structuredSelection) {
			/**
			 * @see org.eclipse.ui.dialogs.WizardNewFileCreationPage#validatePage()
			 */
			protected boolean validatePage() {
				setMessage(null);	
				if (!super.validatePage()) {
					return false;
				}
				
				if(!allowOverwrite())
				{
					IPath path = getContainerFullPath();
					if(path != null)
					{
						String fileName = getFileName();
						if(fileName.length() == 0) {
							setErrorMessage(null);
							return false;
						} else {
							/*
							 * Test for any invalid characters within the file name or if it begins with
							 * a period.
							 */
							String invalidChar = UIUtil.validateJavaFileName(fileName);
							if (invalidChar != null) {						
								if (Character.isDigit(invalidChar.charAt(0))) {
									String [] errors = { HyadesUIPlugin.getString("PHYSICAL_FILE_NAME"), HyadesUIPlugin.getString("NUMERIC_VALUE") };
									setErrorMessage(HyadesUIPlugin.getString("_ERROR_NAME_EXT", errors));
									return false;					
								} else {
									String [] errors = { HyadesUIPlugin.getString("PHYSICAL_FILE_NAME"), invalidChar};
									setErrorMessage(HyadesUIPlugin.getString("_ERROR_NAME_SPECIAL_CHAR", errors));
									return false;
								}							
							}
						}
					}
				}		
				return true;
			}
		};
		// Set the super.locationPage value
		setLocationPage(locationPage);
		
		String fileExtension = getFileExtension();
		if(fileExtension != null)
		{
			locationPage.setFileExtension(fileExtension);
			locationPage.setFileName("");
		}

		AttributeWizardPage attributeWizardPage = new AttributeWizardPage("nameDescription") {
			/**
			 * Returns whether this page's controls currently all contain valid 
			 * values.
			 * @return <code>true</code> if all controls are valid, and
			 * <code>false</code> if at least one is invalid
			 */
			protected boolean validatePage()
			{				
				setErrorMessage(null);
				if (!super.validatePage()) {
					return false;
				}
					
				if((getItemName() != null) && (getItemName().trim().length() != 0)) {
					/*
					 * Test for any invalid characters within the file name
					 */
					String invalidChar = UIUtil.validateJavaFileName(getItemName());
					if (invalidChar != null) {		
						if (Character.isDigit(invalidChar.charAt(0))) {
							String [] errors = { HyadesUIPlugin.getString("LOGICAL_NAME"), HyadesUIPlugin.getString("NUMERIC_VALUE") };
							setErrorMessage(HyadesUIPlugin.getString("_ERROR_NAME_EXT", errors));
							return false;					
						} else {
							String [] errors = { HyadesUIPlugin.getString("LOGICAL_NAME"), invalidChar};
							setErrorMessage(HyadesUIPlugin.getString("_ERROR_NAME_SPECIAL_CHAR", errors));
							return false;
						}							
					}
				}
				return true;
			}
			
		};
		// Set the super.attributeWizardPage value
		setAttributeWizardPage(attributeWizardPage);
		getAttributeWizardPage().addActivationListener(this);
	}
}
