/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.test.ui;

import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;

/**
 * <p>Interface used by Hyades extenders to add new element in the Hyades Test Navigator.
 * <p>This interface is used in the following extension point:
 * <ul>
 * <li> <code>org.eclipse.hyades.test.ui.testNavigatorFile</code></li>
 * <li> <code>org.eclipse.hyades.test.ui.testNavigatorObject</code></li>
 * <li> <code>org.eclipse.hyades.test.ui.testNavigatorType</code></li>
 * </ul>
 * @author jgout
 */
public interface IHyadesTestNavigatorProvider extends ITreeContentProvider, ILabelProvider, IExecutableExtension  
{
	public final static int VERDICT_NONE = 0;
	public final static int VERDICT_FAILED = 1;
    public final static int VERDICT_PASSED = 2;
    public final static int VERDICT_ERROR = 3;
    public final static int VERDICT_INCONCLUSIVE = 4;
   
   
   	/** This method returns the status of the passed element, on an execution node, it can return 
	 * for exemple passed or failed. 
	 * @param element the element in the Test Navigator
	 * @return the verdict after the execution of the test for the node element. 
	 */
	public int getVerdict(Object element);
}
