/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui;

import org.eclipse.hyades.ui.internal.util.ImageManager;

/**
 * Image manager for the Hyades Test UI plugin.
 *  
 * @author marcelop
 * @since 0.0.1
 */
public class TestUIImages extends ImageManager {
    /**
     * HyadesUIImages' singleton.
     */
    public static final TestUIImages INSTANCE = new TestUIImages();

    /*
     * Available cached Images in the Java plugin image registry.
     */
    public static final String IMG_WIZBAN_NEWTESTSUITE = "newtestsuite_wiz.gif";
    public static final String IMG_WIZBAN_NEWDEPLOYMENT = "newdeployment_wiz.gif";
    public static final String IMG_WIZBAN_RUN = "run_wiz.gif";
    public static final String IMG_WIZBAN_NEWARTIFACT = "new_artifact_wiz.gif";
    public static final String IMG_WIZBAN_NEWLOCATION = "new_location_wiz.gif";
    public static final String IMG_WIZBAN_NEWTESTCASE = "newtestcase_wiz.gif";
    public static final String IMG_WIZBAN_NEWDATAPOOL = "new_datapool_wiz.gif";
    public static final String IMG_WIZBAN_EXPORT_DATAPOOL = "export_datapool_wiz.gif";

    public static final String IMG_FORM_BANNER = "form_banner.gif";

    public static final String IMG_TEST_SUITE = "testsuite_obj.gif";
    public static final String IMG_TEST_CASE = "testcase_obj.gif";
    public static final String IMG_TEST_COMPONENT = "testcomponent_obj.gif";
    public static final String IMG_ARBITER = "arbiter_obj.gif";
    public static final String IMG_DEPLOYMENT = "deployment_obj.gif";
    public static final String IMG_DEPLOYMENT_SPEC = "deployspec_obj.gif";
    public static final String IMG_LOCATION = "location_obj.gif";
    public static final String IMG_PROPERTY_GROUP = "propertyGroup_obj.gif";
    public static final String IMG_PROPERTY = "property_obj.gif";
    public static final String IMG_REPORT = "report_obj.gif";
    public static final String IMG_BEHAVIOR = "behavior_obj.gif";
    public static final String IMG_SUT = "sut_obj.gif";
    public static final String IMG_EXECUTION = "execution_obj.gif";
    public static final String IMG_DATAPOOL = "datapool_obj.gif";
    public static final String IMG_ARTIFACT = "artifact_obj.gif";
    public static final String IMG_DOWNARROW = "downArrow.gif"; //$NON-NLS-1$

    // icons added for HTN : BCO (3/5/04)
    public static final String IMG_VERDICT_ERROR = "verdict_error.gif";
    public static final String IMG_VERDICT_FAILED = "verdict_failed.gif";
    public static final String IMG_VERDICT_INC = "verdict_inc.gif";
    public static final String IMG_VERDICT_PASSED = "verdict_passed.gif";

    public static final String IMG_EVENT_EXECUTION = "eveexecution_obj.gif";
    // modified the icons to have separate images for different invocation events :BGB(12/1/03)
    public static final String IMG_EVENT_INVOCATION = "eveinvocation_obj.gif";
    public static final String IMG_EVENT_INVOCATION_PASS = "eveinvocationpass_obj.gif";
    public static final String IMG_EVENT_INVOCATION_FAIL = "eveinvocationfail_obj.gif";
    public static final String IMG_EVENT_INVOCATION_INCONCLUSIVE = "eveinvocationinc_obj.gif";
    public static final String IMG_EVENT_INVOCATION_ERROR = "eveinvocationerror_obj.gif";
    public static final String IMG_EVENT_MESSAGE = "evemessage_obj.gif";
    // modified the icons to have separate images for different typed events :BGB(12/1/03)
    public static final String IMG_EVENT_TYPED = "evetyped_obj.gif";
    public static final String IMG_EVENT_TYPED_START = "evetypedstart_obj.gif";
    public static final String IMG_EVENT_TYPED_STOP = "evetypedstop_obj.gif";
    // modified the icons to have separate images for different typed events :BGB(12/1/03)
    public static final String IMG_EVENT_VERDICT = "eveverdict_obj.gif";
    public static final String IMG_EVENT_VERDICT_PASS = "eveverdictpass_obj.gif";
    public static final String IMG_EVENT_VERDICT_FAIL = "eveverdictfail_obj.gif";
    public static final String IMG_EVENT_VERDICT_INCONCLUSIVE = "eveverdictinc_obj.gif";
    public static final String IMG_EVENT_VERDICT_ERROR = "eveverdicterror_obj.gif";
    // added new loop event :BGB(12/1/03)
    public static final String IMG_EVENT_LOOP = "eveloop_obj.gif";

    public static final String IMG_UNCHECKED = "unchecked_obj.gif";
    public static final String IMG_ERROR = "error_obj.gif";

    public static final String ACT_SHOW_FOLDER = "showfolders_co.gif";
    public static final String ACT_SHOW_EOBJECT_CHILDREN = "showchild_co.gif";
    public static final String ACT_NEW_TEST_SUITE = "newtestsuite_wiz.gif";
    public static final String ACT_NEW_DEPLOYMENT = "newdeployment_wiz.gif";
    public static final String ACT_DOWN = "down_nav.gif";
    public static final String ACT_UP = "up_nav.gif";

    public static final String IMG_LCONFIG_TEST_TAB = "launch_testtab.gif";
    public static final String IMG_LCONFIG_TCOMPONENT_TAB = "launch_tcomponenttab.gif";
    public static final String IMG_LCONFIG_EXECRESULTS_TAB = "launch_execresultstab.gif";

    public static final String IMG_DEFAULT = IMG_UNCHECKED;

    /**
     * @see org.eclipse.hyades.ui.util.ImageManager#addImages()
     */
    protected void addImages() {
        add(T_WIZBAN, IMG_WIZBAN_NEWTESTSUITE);
        add(T_WIZBAN, IMG_WIZBAN_RUN);
        add(T_WIZBAN, IMG_WIZBAN_NEWDEPLOYMENT);
        add(T_WIZBAN, IMG_FORM_BANNER);
        add(T_WIZBAN, IMG_WIZBAN_NEWTESTCASE);
        add(T_WIZBAN, IMG_WIZBAN_EXPORT_DATAPOOL);
        add(T_WIZBAN, IMG_WIZBAN_NEWDATAPOOL);
        add(T_WIZBAN, IMG_WIZBAN_NEWARTIFACT);
        add(T_WIZBAN, IMG_WIZBAN_NEWLOCATION);
        
        add(T_OBJ, IMG_TEST_SUITE);
        add(T_OBJ, IMG_TEST_CASE);
        add(T_OBJ, IMG_TEST_COMPONENT);
        add(T_OBJ, IMG_ARBITER);
        add(T_OBJ, IMG_DEPLOYMENT);
        add(T_OBJ, IMG_DEPLOYMENT_SPEC);
        add(T_OBJ, IMG_LOCATION);
        add(T_OBJ, IMG_PROPERTY_GROUP);
        add(T_OBJ, IMG_PROPERTY);
        add(T_OBJ, IMG_REPORT);
        add(T_OBJ, IMG_BEHAVIOR);
        add(T_OBJ, IMG_SUT);
        add(T_OBJ, IMG_EXECUTION);
        add(T_OBJ, IMG_DATAPOOL);
        add(T_OBJ, IMG_ARTIFACT);
        add(T_OBJ, IMG_DOWNARROW);

        add(T_OBJ, IMG_EVENT_EXECUTION);
        //modified the icons to have separate images for different invocation events :BGB(12/1/03)
        add(T_OBJ, IMG_EVENT_INVOCATION);
        add(T_OBJ, IMG_EVENT_INVOCATION_PASS);
        add(T_OBJ, IMG_EVENT_INVOCATION_FAIL);
        add(T_OBJ, IMG_EVENT_INVOCATION_INCONCLUSIVE);
        add(T_OBJ, IMG_EVENT_INVOCATION_ERROR);
        add(T_OBJ, IMG_EVENT_MESSAGE);
        //modified the icons to have separate images for different typed events :BGB(12/1/03)
        add(T_OBJ, IMG_EVENT_TYPED);
        add(T_OBJ, IMG_EVENT_TYPED_START);
        add(T_OBJ, IMG_EVENT_TYPED_STOP);
        //modified the icons to have separate images for different verdict events :BGB(12/1/03)
        add(T_OBJ, IMG_EVENT_VERDICT);
        add(T_OBJ, IMG_EVENT_VERDICT_PASS);
        add(T_OBJ, IMG_EVENT_VERDICT_FAIL);
        add(T_OBJ, IMG_EVENT_VERDICT_INCONCLUSIVE);
        add(T_OBJ, IMG_EVENT_VERDICT_ERROR);
        //added new loop event :BGB(12/1/03)
        add(T_OBJ, IMG_EVENT_LOOP);

        add(T_OBJ, IMG_UNCHECKED);
        add(T_OBJ, IMG_ERROR);

        // Added by JC
        add(T_OBJ, IMG_LCONFIG_TEST_TAB);
        add(T_OBJ, IMG_LCONFIG_TCOMPONENT_TAB);
        add(T_OBJ, IMG_LCONFIG_EXECRESULTS_TAB);

        add("c", T_LCL, ACT_SHOW_FOLDER);
        add("d", T_LCL, ACT_SHOW_FOLDER);
        add("e", T_LCL, ACT_SHOW_FOLDER);

        add("c", T_LCL, ACT_SHOW_EOBJECT_CHILDREN);
        add("d", T_LCL, ACT_SHOW_EOBJECT_CHILDREN);
        add("e", T_LCL, ACT_SHOW_EOBJECT_CHILDREN);

        add("c", T_TOOL, ACT_NEW_TEST_SUITE);
        add("e", T_TOOL, ACT_NEW_TEST_SUITE);
        add("c", T_TOOL, ACT_NEW_DEPLOYMENT);
        add("e", T_TOOL, ACT_NEW_DEPLOYMENT);

        add("c", T_LCL, ACT_DOWN);
        add("d", T_LCL, ACT_DOWN);
        add("e", T_LCL, ACT_DOWN);

        add("c", T_LCL, ACT_UP);
        add("d", T_LCL, ACT_UP);
        add("e", T_LCL, ACT_UP);

        // Added by BCO (3/5/04)
        add(T_OVR, IMG_VERDICT_ERROR);
        add(T_OVR, IMG_VERDICT_PASSED);
        add(T_OVR, IMG_VERDICT_FAILED);
        add(T_OVR, IMG_VERDICT_INC);

    }
}