/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFLoopEvent;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFSUT;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * @author kdarcour
 */
public class DefaultLabelProvider implements ILabelProvider 
{
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
	 */
	public Image getImage(Object element) 
	{
		Image icon = null;
		
		if(element instanceof Resource)
			return PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_OBJ_FILE);
		
		if(element instanceof EObject)
		{
			if(element instanceof TPFTestSuite)
			{
				TPFTestSuite testSuite = (TPFTestSuite)element;
				String type = testSuite.getType();
				if(type != null)
				{
					IAssociationMapping mapping = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS);
					IAssociationDescriptor descriptor = mapping.getDefaultAssociationDescriptor(type);
					if(descriptor != null)
						icon  = descriptor.getImage();
				}
				if(icon == null)
					icon = TestUIImages.INSTANCE.getImage(TestUIImages.IMG_DEFAULT);
				return icon;
			}

			if(element instanceof TPFTestCase)
			{
				TPFTestCase testCase = (TPFTestCase)element;
				String type = testCase.getType();
				if(type != null)
				{
					IAssociationMapping mapping = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS);
					IAssociationDescriptor descriptor = mapping.getDefaultAssociationDescriptor(type);
					if(descriptor != null)
						icon = descriptor.getImage();
						
					if(icon == null)
					{
						mapping = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping(TestUIPlugin.EP_TEST_CASE_WIZARD);
						descriptor = mapping.getDefaultAssociationDescriptor(type);
						if(descriptor != null)
							icon = descriptor.getImage();						
					}
				}
				if(icon == null)
					icon = TestUIImages.INSTANCE.getImage(TestUIImages.IMG_DEFAULT);
				return icon;
			}
			
			if(element instanceof TPFExecutionResult)
				return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EXECUTION);

			if(element instanceof TPFExecutionEvent)
			{
				if(element instanceof TPFTypedEvent)
				{
					//modified the icons to have separate images for different typed events :BGB(12/1/03)
					TPFExecutionType	exeType	= null;
					exeType = ((TPFTypedEvent)element).getType();
					if ( exeType != null )
					{
						if ( exeType.getValue() == TPFExecutionType.START )
							return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_TYPED_START);
						else if ( exeType.getValue() == TPFExecutionType.STOP )
							return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_TYPED_STOP);
					}
					return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_TYPED);
				}
				
				//added new loop event :BGB(12/1/03)
				if(element instanceof TPFLoopEvent)
					return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_LOOP);

				if(element instanceof TPFMessageEvent)
					return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_MESSAGE);

				if(element instanceof TPFVerdictEvent)
				{
					TPFVerdict	verdict	= null;
					verdict	= ((TPFVerdictEvent)element).getVerdict();
					if ( verdict != null )
					{
						if ( verdict.getValue() == TPFVerdict.PASS )
							return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_VERDICT_PASS);
						if ( verdict.getValue() == TPFVerdict.FAIL )
							return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_VERDICT_FAIL);
						if ( verdict.getValue() == TPFVerdict.INCONCLUSIVE )
							return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_VERDICT_INCONCLUSIVE);
						if ( verdict.getValue() == TPFVerdict.ERROR )
							return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_VERDICT_ERROR);
					}
					return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_VERDICT_PASS);
				}

				if(element instanceof TPFInvocationEvent)
				{
					//added support for rollup icons in invocation events :BGB(12/1/03)
					TPFExecutionResult	exeResult	= null;
					TPFExecutionHistory	exeHistory	= null;
					EList				eventList	= null;
					exeResult	= ((TPFInvocationEvent)element).getInvokedExecutionResult();
					if ( exeResult != null )
						exeHistory	= exeResult.getExecutionHistory();
					if ( exeHistory != null )
						eventList	= exeHistory.getExecutionEvents();
					if ( eventList != null & eventList.isEmpty() == false )
					{
						TPFVerdict	curVerdict		= null;
						int			rollupVerdict	= TPFVerdict.PASS,
									i				= 0;
						boolean		bRollupVerFound	= false;
						Object		curObject		= null;
						
						//traverse through the list of events to get the final verdict; this
						//final verdict represents the rollup verdict
						i = eventList.size() - 1;
						while( ( i >= 0 ) && ( bRollupVerFound == false ) )
						{
							curObject	= eventList.get(i);
							if ( curObject instanceof EObject )
							{
								if ( curObject instanceof TPFVerdictEvent )
								{
									curVerdict = ((TPFVerdictEvent)curObject).getVerdict();
									if ( curVerdict.getValue() != TPFVerdict.PASS )
										rollupVerdict	= curVerdict.getValue();
									bRollupVerFound = true;
								}
							}
							i--;
						}
						if ( rollupVerdict == TPFVerdict.PASS )
							return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_INVOCATION_PASS);
						else if ( rollupVerdict == TPFVerdict.FAIL )
							return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_INVOCATION_FAIL);
						if ( rollupVerdict == TPFVerdict.ERROR )
							return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_INVOCATION_ERROR);
						if ( rollupVerdict == TPFVerdict.INCONCLUSIVE )
							return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_INVOCATION_INCONCLUSIVE);
					}
					return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_INVOCATION);
				}
				
				return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_EXECUTION);
			}

			if(element instanceof TPFTestComponent)
				return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_TEST_COMPONENT);

			if(element instanceof TPFBehavior)
				return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_BEHAVIOR);

			if(element instanceof TPFSUT)
				return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_SUT);
				
			if(element instanceof TPFDeployment)
				return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_DEPLOYMENT);

			if(element instanceof DPLDatapool)
				return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_DATAPOOL);

			if(element instanceof CFGLocation)
				return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_LOCATION);
			
			if(element instanceof CFGArtifact)
				return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_ARTIFACT);
			
			if(element instanceof CFGPropertyGroup)
				return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_PROPERTY_GROUP);
			
			if(element instanceof CFGComparableProperty)
				return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_PROPERTY);
		}		
		return icon;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element) 
	{
		String label = "";
		

		if(element instanceof Resource)
		{
			IFile file = EMFUtil.getWorkspaceFile((Resource)element);
			if(file != null)
				return ((IWorkbenchAdapter)file.getAdapter(IWorkbenchAdapter.class)).getLabel(file);
			return ""; //$NON-NLS-1$
		}
		
		if(element instanceof TPFExecutionEvent)
		{
			String name = ((TPFExecutionEvent)element).getName();
			if(name != null) {
				return name;
			} else {
				if(element instanceof TPFTypedEvent)
				{
					TPFTypedEvent typedEvent = (TPFTypedEvent)element;
					if(typedEvent.getType() == null)
						return TestUIPlugin.getString("W_EVT_TYPED"); //$NON-NLS-1$
					return typedEvent.getType().getLabel();
				}
	
				if(element instanceof TPFMessageEvent)
					return TestUIPlugin.getString("W_EVT_MSG"); //$NON-NLS-1$
	
				if(element instanceof TPFVerdictEvent)
				{
					TPFVerdictEvent verdictEvent = (TPFVerdictEvent)element;
					if(verdictEvent.getVerdict() == null)
						return TestUIPlugin.getString("W_EVT_VER"); //$NON-NLS-1$
					return verdictEvent.getVerdict().getLabel();
				}
	
				if(element instanceof TPFInvocationEvent)
					return TestUIPlugin.getString("W_EVT_INV"); //$NON-NLS-1$
					
				//added new label for loop event :BGB(12/1/03)
				if(element instanceof TPFLoopEvent)
				{
					//now getting loop name first for label, if no name, label is generic object name :BGB(12/4/03)
					TPFLoopEvent			loopEvent			= null;
					BVRInteractionFragment	interactionFragment	= null;
					loopEvent	= ((TPFLoopEvent)element);
					interactionFragment	= loopEvent.getInteractionFragment();
					if ( interactionFragment != null )
					{
						if ( ( interactionFragment.getName() != null) &&
						     ( interactionFragment.getName().length() > 0 ) )
							return( interactionFragment.getName() );
					}
					return TestUIPlugin.getString("W_EVT_LOOP"); //$NON-NLS-1$
				}
			}
			return TestUIPlugin.getString("W_EVT_EXEC"); //$NON-NLS-1$
		}
		
		if (element instanceof TPFExecutionResult) 
		{
			if (((TPFExecutionResult)element).getName() == null)
			{
				return TestUIPlugin.getString("W_TST_EXE"); //$NON-NLS-1$
				// if ((label = execEvent.getName()) == null)
				//	label = "unamed";
			}
			else
				return ((TPFExecutionResult)element).getName();
		}
			
		
		return label;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void addListener(ILabelProviderListener listener) 
	{
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() 
	{
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object, java.lang.String)
	 */
	public boolean isLabelProperty(Object element, String property) 
	{
		return false;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void removeListener(ILabelProviderListener listener) 
	{
	}
}
