/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

/** Location Hyades Test Navigator provider
 *  It allows the test navigator to display files '.location'
 */
public class LocationHTNProvider implements IHyadesTestNavigatorProvider {

    /** This method returns the verdict of the passed element, in this case, there is no status
     * because this is not an execution node.
     * @param element the element in the Test Navigator
     * @return  IHyadesTestNavigatorProvider.VERDICT_NONE
     */
    public int getVerdict(Object element) {
        return IHyadesTestNavigatorProvider.VERDICT_NONE;
    }

    public Object[] getChildren(Object parentElement) {
        //- no children for this kind of node
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile) element;
            return file.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        //- no children for this kind of node
        return false;
    }

    public Image getImage(Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile) element;
            String ext = file.getFileExtension();
            if (ext.equals(ICommonConstants.LOCATION_FILE_EXTENSION)) return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_LOCATION);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile) element;
            String ext = file.getFileExtension();
            if (ext.equals(ICommonConstants.LOCATION_FILE_EXTENSION)) {
                EObject[] eObjects = EMFUtil.load(null, file);
                for (int i = 0; i < eObjects.length; i++) {
                    if (eObjects[i] instanceof CFGLocation) {
                        return ((CFGLocation) eObjects[i]).getName();
                    }
                }
            }
        }
        return ""; //$NON-NLS-1$
    }

    public Object[] getElements(Object inputElement) {
        return getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}