/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * @deprecated Run Wizard is replaced by Run Configuration. Extension point for Run Wizard
 * is also deprecated.
 */
public class RunAction 
extends Action implements IDisposable
{
	private IStructuredSelection structuredSelection;
	private IAssociationDescriptor wizardDescriptor;

	public RunAction()
	{
		super(TestUIPlugin.getString("RUN_TEXT")); //$NON-NLS-1$
		WorkbenchHelp.setHelp(this, TestUIPlugin.getID() + ContextIds.RUN_ACT);												
		
	}
	
	public void dispose()
	{
		structuredSelection = null;
		wizardDescriptor = null;
	}

	protected IStructuredSelection getStructuredSelection()
	{
		return structuredSelection;
	}
	
	public void selectionChanged(IStructuredSelection structuredSelection)
	{
		wizardDescriptor = null;
		this.structuredSelection = structuredSelection;
	}

	protected IAssociationDescriptor getWizardDescriptor()
	{
		return wizardDescriptor;
	}

	public void run()
	{
		if(getWizardDescriptor() == null)
			return;
			
		IWorkbenchWizard workbenchWizard = (IWorkbenchWizard)getWizardDescriptor().createImplementationClassInstance();
		workbenchWizard.init(PlatformUI.getWorkbench(), getStructuredSelection());
		
		WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), workbenchWizard);
		dialog.open();
		workbenchWizard.dispose();

		wizardDescriptor = null;
		structuredSelection = null;
	}

	public boolean isApplicableForSelection()
	{
		return false;
		
		/*wizardDescriptor = null;
		if((structuredSelection == null) || (structuredSelection.size() != 1))
			return false;

		Object selection = structuredSelection.getFirstElement();
		if(selection instanceof ITest)
		{
			String type = ((ITest)selection).getType();
			if(type != null)
			{
				IAssociationDescriptor descriptor = null;
				if(selection instanceof ITestSuite)
					descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping(TestUIPlugin.EP_RUN_WIZARDS).getDefaultAssociationDescriptor(type);
				else if(selection instanceof ITestCase)
					descriptor = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping(TestUIPlugin.EP_RUN_WIZARDS).getDefaultAssociationDescriptor(type);
					
				if((descriptor != null) && (descriptor.getImplementationClass() != null))
				{
					if(IWorkbenchWizard.class.isAssignableFrom(descriptor.getImplementationClass()))
						wizardDescriptor = descriptor;
				}
			}
		}

		return (wizardDescriptor != null);*/
	}
}
