/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.selection.SelectionPage;
import org.eclipse.ui.INewWizard;

/**
 * The Hyades generic New Test Case wizard
 * 
 * @author pnedelec
 * @since 3.0.0
 */
public class TestCaseNewWizard extends HyadesWizard implements INewWizard {
    private TestCaseDefinitionPage testCaseDefinitionPage;
    private SelectionPage selectionPage;

    /**
     * Constructor for TestCaseNewWizard
     */
    public TestCaseNewWizard() {
        super();
        setWindowTitle(TestUIPlugin.getString("WIZ_TST_CASE_TTL")); //$NON-NLS-1$
        setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_WIZBAN_NEWTESTCASE));
    }

    /**
     * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
     */
    protected void initPages() {
        testCaseDefinitionPage = new TestCaseDefinitionPage("TestCaseDefinitionPage", getWorkbench(), getSelection()); //$NON-NLS-1$
        selectionPage = new TestCaseSelectionPage("SelectionPage", getWorkbench(), getSelection()); //$NON-NLS-1$
    }

    /**
     * @see org.eclipse.jface.wizard.IWizard#addPages()
     */
    public void addPages() {
        addPage(testCaseDefinitionPage);
        addPage(selectionPage);
    }

    /** 
     * @see org.eclipse.jface.wizard.IWizard#canFinish()
     */
    public boolean canFinish() {
        return false;
    }

    /**
     * @see org.eclipse.jface.wizard.IWizard#performFinish()
     */
    public boolean performFinish() {
        return true;
    }
}
